/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FileToMultipartFileConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileToMultipartFileConverter.class);

    public static MultipartFile getMultipartFile(File file) {
        FileItem item = new DiskFileItemFactory().createItem("file", "multipart/form-data", true, file.getName());
        try (FileInputStream input = new FileInputStream(file);
             OutputStream os = item.getOutputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error("");
            return null;
        }
        return new CommonsMultipartFile(item);
    }
}

