/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.utils;

import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.utils.QRCodeUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.springframework.stereotype.Component;

@Component
public class LabelsUtils {
    public ImageIcon getJLabelCodeImage(String codeInfo) {
        BufferedImage bufferedImage = QRCodeUtil.createImage(codeInfo);
        return new ImageIcon(bufferedImage);
    }

    public JLabel getJLabelImage(String imageName, Rectangle rectangle, Color color, Map<TextAttribute, Object> attributes) {
        JLabel jLabel = new JLabel(ImageUtils.generateImage(imageName));
        jLabel.setBounds(rectangle);
        jLabel.setBackground(color);
        return jLabel;
    }

    public JTextField getJTextField(Font font, String name, Rectangle rectangle, Color color) {
        JTextField jTextField = new JTextField(name);
        jTextField.setBounds(rectangle);
        jTextField.setBackground(color);
        Border insideBorder = BorderFactory.createEmptyBorder(1, 5, 1, 0);
        jTextField.setBorder(BorderFactory.createCompoundBorder(jTextField.getBorder(), insideBorder));
        jTextField.setMargin(new Insets(1, 5, 1, 0));
        return jTextField;
    }

    public JButton getJButtonImage(Rectangle rectangle, Color color) {
        JButton jButton = new JButton(ImageUtils.generateImage("close.png"));
        jButton.setBounds(rectangle);
        jButton.setBackground(color);
        jButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 22));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        return jButton;
    }

    public JLabel getJLabel(Font font, String name, Rectangle rectangle, Color color, Map<TextAttribute, Object> attributes) {
        JLabel jLabel = new JLabel(name);
        jLabel.setFont(font);
        jLabel.setBackground(color);
        Font deriveFont = font.deriveFont(attributes);
        jLabel.setBounds(rectangle);
        jLabel.setFont(deriveFont);
        return jLabel;
    }

    public JButton getButton(Font font, String name, Rectangle rectangle, Color color) {
        JButton jButton = new JButton(name);
        jButton.setBounds(rectangle);
        jButton.setBackground(color);
        jButton.setFont(font);
        jButton.setFocusPainted(false);
        jButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        return jButton;
    }

    public JSeparator getJSeparator(int width, int height) {
        JSeparator jSeparator = new JSeparator();
        jSeparator.setBounds(new Rectangle(0, height, width, 1));
        jSeparator.setBackground(new Color(205, 208, 214));
        return jSeparator;
    }

    public JTextArea getTextArea(Font font, Rectangle rectangle, Color color, Map<TextAttribute, Object> attributes) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBounds(rectangle);
        jTextArea.setBackground(color);
        Font deriveFont = font.deriveFont(attributes);
        jTextArea.setFont(deriveFont);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        return jTextArea;
    }

    public JCheckBox getCheckBox(Font font, String name, Rectangle rectangle, Color color, Map<TextAttribute, Object> attributes) {
        JCheckBox jCheckBox = new JCheckBox(name);
        jCheckBox.setBounds(rectangle);
        jCheckBox.setBackground(color);
        Font deriveFont = font.deriveFont(attributes);
        jCheckBox.setFont(deriveFont);
        return jCheckBox;
    }

    public WhitePanel initWhitePanel(int xPoint, int yPoint, int width, int height, FlowLayout flowLayout) {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(xPoint, yPoint, width, height);
        panel.setLayout(flowLayout);
        return panel;
    }
}

