/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.BlockListMenuInfoBo;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.HighRiskCommandInfoBo;
import com.huawei.netcareinsidesdk.bo.HighRiskInterceptRecordBo;
import com.huawei.netcareinsidesdk.bo.InternationalizeBo;
import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.VerifyCodeRecordBo;
import com.huawei.netcareinsidesdk.bo.WhiteListCommandInfoBo;
import com.huawei.netcareinsidesdk.bo.WhiteListMenuInfoBo;
import com.huawei.netcareinsidesdk.constants.PostInterceptModeEnum;
import com.huawei.netcareinsidesdk.dao.BlockListMenuInfoDao;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.HighRiskCommandInfoDao;
import com.huawei.netcareinsidesdk.dao.HighRiskInterceptRecordDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.VerifyCodeRecordDao;
import com.huawei.netcareinsidesdk.dao.WhiteListCommandInfoDao;
import com.huawei.netcareinsidesdk.dao.WhiteListMenuInfoDao;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.swingservice.AsyncCommandSwingService;
import com.huawei.netcareinsidesdk.utils.DataInternationalizationUtil;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.PageBean;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.RsaUtil;
import com.huawei.netcareinsidesdk.utils.VerifyCodeUtil;
import com.huawei.netcareinsidesdk.vo.CommandInfoVo;
import com.huawei.netcareinsidesdk.vo.HighRiskCommandInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.HighRiskCommandQueryVo;
import com.huawei.netcareinsidesdk.vo.HighRiskInterceptRecordQueryVo;
import com.huawei.netcareinsidesdk.vo.HighRiskMenuInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.InterceptionVerifyCodeVo;
import com.huawei.netcareinsidesdk.vo.MenuInfoVo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommandSwingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandSwingService.class);
    private static final Integer COMMANDS_LENGTH = 84;
    private static final Integer VERIFY_NUM = 6;
    @Autowired
    private HighRiskInterceptRecordDao highRiskInterceptRecordDao;
    @Autowired
    private VerifyCodeRecordDao verifyCodeRecordDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private AsyncCommandSwingService asyncCommand;
    @Autowired
    private HighRiskCommandInfoDao highRiskCommandInfoDao;
    @Autowired
    private WhiteListCommandInfoDao whiteListCommandInfoDao;
    @Autowired
    private VerifyCodeUtil verifyCodeUtil;
    @Autowired
    private DataInternationalizationUtil dataInternationalizationUtil;
    @Autowired
    private DeviceInfoDao deviceIdInfoDao;
    @Autowired
    private BlockListMenuInfoDao blockListMenuInfoDao;
    @Autowired
    private WhiteListMenuInfoDao whiteListMenuInfoDao;
    @Autowired
    private CommonServiceForSdk commonServiceForSdk;

    public String getInterceptionQRCode(HighRiskInterceptRecordBo highRiskInterceptRecordBo) {
        LOGGER.info("Start getInterceptionQRCode");
        HighRiskInterceptRecordBo interceptRecordBo = this.highRiskInterceptRecordDao.queryHighRiskInterceptRecord(highRiskInterceptRecordBo);
        if (ObjectUtils.isEmpty((Object)interceptRecordBo)) {
            LOGGER.error("The highRiskInterceptRecord data is empty. The QR code create error.");
            return "";
        }
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)userAuthenticateInfoBo)) {
            LOGGER.error("The userAuthenticateInfo data does not exist. The userAuthenticateInfo is abnormal.");
            return "";
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (ObjectUtils.isEmpty((Object)taskInfoBo)) {
            LOGGER.error("The taskInfo data does not exist. The taskInfo is abnormal.");
            return "";
        }
        List inputCommands = JSONObject.parseArray((String)interceptRecordBo.getInputCommand(), String.class);
        String strCommands = String.join((CharSequence)",", inputCommands);
        if (strCommands.length() > COMMANDS_LENGTH) {
            strCommands = strCommands.substring(0, COMMANDS_LENGTH - 3) + "...";
        }
        String deviceId = this.getDeviceId();
        String verifyCode = this.getVerifyCode(taskInfoBo);
        String pubKey = PropertyUtil.getString("pubkeyByEncrypt");
        try {
            String taskId = taskInfoBo.getTaskId();
            String accountAndVerifyCode = null;
            accountAndVerifyCode = Objects.nonNull(userAuthenticateInfoBo.getIsPublicOmTerminal()) && userAuthenticateInfoBo.getIsPublicOmTerminal() != false ? URLEncoder.encode(RsaUtil.encrypt(verifyCode, pubKey), "UTF-8") : URLEncoder.encode(RsaUtil.encrypt(verifyCode + "@" + userAuthenticateInfoBo.getLoginAccount(), pubKey), "UTF-8");
            LOGGER.info("End getInterceptionQRCode");
            String siteInfo = StringUtils.isNotBlank((CharSequence)userAuthenticateInfoBo.getSite()) ? userAuthenticateInfoBo.getSite() : "China";
            return PropertyUtil.getScanQrUrl("sdkAuthApply", siteInfo) + "?" + String.join((CharSequence)"&", "taskId=" + taskId, "matchCommand=" + strCommands, "type=" + interceptRecordBo.getCommandType(), "accountAndVerifyCode=" + accountAndVerifyCode, "deviceId=" + deviceId);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException exception) {
            LOGGER.error("The verifyCode data create error.");
            LOGGER.info("End getInterceptionQRCode");
            return "";
        }
    }

    private String getDeviceId() {
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceIdInfoDao.queryDeviceInfo(windowsAccount);
        String deviceId = "";
        if (ObjectUtils.isNotEmpty((Object)deviceIdInfoBo)) {
            deviceId = deviceIdInfoBo.getDeviceId();
        }
        return deviceId;
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    private String getVerifyCode(TaskInfoBo taskInfoBo) {
        String verifyCode = this.verifyCodeUtil.generalVerifyCode(VERIFY_NUM);
        VerifyCodeRecordBo verifyCodeRecordBo = new VerifyCodeRecordBo();
        verifyCodeRecordBo.setOperator(taskInfoBo.getTaskExecutor());
        verifyCodeRecordBo.setAccount(taskInfoBo.getTaskExecutor());
        verifyCodeRecordBo.setTaskId(taskInfoBo.getTaskId());
        verifyCodeRecordBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        verifyCodeRecordBo.setVerifyCode(verifyCode);
        verifyCodeRecordBo.setVerifyType("\u4efb\u52a1\u9a8c\u8bc1");
        verifyCodeRecordBo.setVerifyStatus(2);
        verifyCodeRecordBo.setActivePeriod("30");
        this.verifyCodeRecordDao.insertRecord(verifyCodeRecordBo);
        return verifyCode;
    }

    public String checkInterceptionVerifyCode(InterceptionVerifyCodeVo verifyCodeVo) {
        LOGGER.info("Start checkInterceptionVerifyCode");
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        HighRiskInterceptRecordBo recordBo = new HighRiskInterceptRecordBo();
        recordBo.setGuid(verifyCodeVo.getInterceptionId());
        HighRiskInterceptRecordBo highRiskInterceptRecordBo = this.highRiskInterceptRecordDao.queryHighRiskInterceptRecord(recordBo);
        if (Objects.isNull(highRiskInterceptRecordBo)) {
            return "The Intercept Record data does not exist.";
        }
        String taskId = highRiskInterceptRecordBo.getTaskId();
        TaskInfoBo taskInfo = this.taskInfoDao.queryTaskInfoByTaskId(taskId);
        if (ObjectUtils.isEmpty((Object)taskInfo)) {
            return "The taskInfoBo data does not exist. The task is abnormal.";
        }
        if (StringUtils.isNotBlank((CharSequence)highRiskInterceptRecordBo.getPostInterceptMode())) {
            LOGGER.error("Do not click repeatedly.");
            return "The high-risk command is unlocked or canceled. Do not unlock or cancel the command again.";
        }
        OperationRecordBo operationRecordBo = new OperationRecordBo();
        operationRecordBo.setGuid(verifyCodeVo.getInterceptionId());
        operationRecordBo.setInteface("checkCommandExecute");
        operationRecordBo.setMoudle(highRiskInterceptRecordBo.getCommandType());
        if (verifyCodeVo.getPostInterceptMode().equals(PostInterceptModeEnum.ABANDONMENT.getCode())) {
            this.asyncCommand.abandonCommand(authenticateInfoBo, verifyCodeVo, taskInfo);
            operationRecordBo.setCloseType(PostInterceptModeEnum.ABANDONMENT.getValue().toLowerCase(Locale.ROOT));
        } else {
            TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), authenticateInfoBo.getLoginAccount());
            if (Objects.isNull(taskInfoBo)) {
                return "Expired";
            }
            Map<String, String> checkResultMap = this.verifyCodeUtil.checkVerifyCode(taskInfoBo, verifyCodeVo.getVerifyCode(), "\u4efb\u52a1\u9a8c\u8bc1", 1);
            String checkResult = checkResultMap.get("errorMsg");
            if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
                return checkResult;
            }
            this.asyncCommand.passCommand(authenticateInfoBo, verifyCodeVo, taskInfo, highRiskInterceptRecordBo);
            operationRecordBo.setCloseType(PostInterceptModeEnum.UNLOCK.getValue().toLowerCase(Locale.ROOT));
            LOGGER.info("End checkInterceptionVerifyCode");
        }
        this.commonServiceForSdk.insertOperationRecord(operationRecordBo);
        return null;
    }

    public HighRiskCommandInfoQueryVo queryHighRiskCommandInfo(HighRiskCommandQueryVo highRiskCommandQueryVo) {
        LOGGER.info("Start queryHighRiskCommandInfo");
        UserAuthenticateInfoBo userInfo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        Integer pageNum = Integer.parseInt(highRiskCommandQueryVo.getPageNum());
        Integer pageSize = Integer.parseInt(highRiskCommandQueryVo.getPageSize());
        HighRiskCommandInfoQueryVo infoQueryVo = new HighRiskCommandInfoQueryVo();
        ArrayList<CommandInfoVo> commandInfoVos = new ArrayList<CommandInfoVo>();
        if (highRiskCommandQueryVo.getHighRiskCode().equals("1")) {
            this.putHighRiskCommandInfo(userInfo, pageNum, pageSize, infoQueryVo, commandInfoVos);
            LOGGER.info("End queryHighRiskCommandInfo");
            return infoQueryVo;
        }
        this.putWhiteCommandInfo(userInfo, pageNum, pageSize, infoQueryVo, commandInfoVos);
        LOGGER.info("End queryHighRiskCommandInfo");
        return infoQueryVo;
    }

    public HighRiskInterceptRecordBo queryHighRiskInterceptCommandInfo(HighRiskInterceptRecordQueryVo highRiskInterceptRecordQueryVo) {
        LOGGER.info("Start queryHighRiskInterceptCommandInfo.");
        HighRiskInterceptRecordBo interceptRecordBo = new HighRiskInterceptRecordBo();
        BeanUtils.copyProperties((Object)highRiskInterceptRecordQueryVo, (Object)interceptRecordBo);
        return this.highRiskInterceptRecordDao.queryHighRiskInterceptRecord(interceptRecordBo);
    }

    private void putWhiteCommandInfo(UserAuthenticateInfoBo userInfo, Integer pageNum, Integer pageSize, HighRiskCommandInfoQueryVo infoQueryVo, List<CommandInfoVo> commandInfoVos) {
        List<WhiteListCommandInfoBo> whiteListCommandInfoBos = this.whiteListCommandInfoDao.queryWhiteListCommandInfoByUser(userInfo.getLoginAccount(), null);
        PageBean<WhiteListCommandInfoBo> pb = new PageBean<WhiteListCommandInfoBo>(pageNum, pageSize, whiteListCommandInfoBos);
        for (WhiteListCommandInfoBo white : pb.getList()) {
            CommandInfoVo commandInfoVo = new CommandInfoVo();
            BeanUtils.copyProperties((Object)white, (Object)commandInfoVo);
            commandInfoVo.setOperator(userInfo.getLoginAccountName());
            commandInfoVos.add(commandInfoVo);
        }
        ArrayList<InternationalizeBo> internationalizeBos = this.dataInternationalizationUtil.getRegOfficeProductInternationalizeBos();
        this.dataInternationalizationUtil.setInternationalizeData(LanguageManager.getInstance().getCurLanguage().toLanguageTag(), commandInfoVos, (List<InternationalizeBo>)internationalizeBos);
        infoQueryVo.setTotal(this.whiteListCommandInfoDao.queryWhiteListCommandInfoCount(userInfo.getLoginAccount()));
        infoQueryVo.setCommandInfoVos(commandInfoVos);
    }

    private void putHighRiskCommandInfo(UserAuthenticateInfoBo userInfo, Integer pageNum, Integer pageSize, HighRiskCommandInfoQueryVo infoQueryVo, List<CommandInfoVo> commandInfoVos) {
        List<HighRiskCommandInfoBo> highRiskCommandInfoBos = this.highRiskCommandInfoDao.queryHighRiskCommandInfoByUser(userInfo.getLoginAccount(), null);
        PageBean<HighRiskCommandInfoBo> pb = new PageBean<HighRiskCommandInfoBo>(pageNum, pageSize, highRiskCommandInfoBos);
        for (HighRiskCommandInfoBo high : pb.getList()) {
            CommandInfoVo commandInfoVo = new CommandInfoVo();
            BeanUtils.copyProperties((Object)high, (Object)commandInfoVo);
            commandInfoVos.add(commandInfoVo);
        }
        ArrayList<InternationalizeBo> internationalizeBos = this.dataInternationalizationUtil.getRegOfficeProductInternationalizeBos();
        this.dataInternationalizationUtil.setInternationalizeData(LanguageManager.getInstance().getCurLanguage().toLanguageTag(), commandInfoVos, (List<InternationalizeBo>)internationalizeBos);
        infoQueryVo.setTotal(this.highRiskCommandInfoDao.queryHighRiskCommandInfoCount(userInfo.getLoginAccount()));
        infoQueryVo.setCommandInfoVos(commandInfoVos);
    }

    public HighRiskMenuInfoQueryVo queryHighRiskMenuInfo(HighRiskCommandQueryVo highRiskCommandQueryVo) {
        LOGGER.info("Start queryHighRiskMenuInfo.");
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        Integer pageNum = Integer.parseInt(highRiskCommandQueryVo.getPageNum());
        Integer pageSize = Integer.parseInt(highRiskCommandQueryVo.getPageSize());
        HighRiskMenuInfoQueryVo highRiskMenuInfoQueryVo = new HighRiskMenuInfoQueryVo();
        ArrayList<MenuInfoVo> menuInfoVos = new ArrayList<MenuInfoVo>();
        if (highRiskCommandQueryVo.getHighRiskCode().equals("1")) {
            this.putHighRiskMenuInfo(authenticateInfoBo, pageNum, pageSize, highRiskMenuInfoQueryVo, menuInfoVos);
            LOGGER.info("End queryHighRiskCommandInfo");
            return highRiskMenuInfoQueryVo;
        }
        this.putWhiteMenuInfo(authenticateInfoBo, pageNum, pageSize, highRiskMenuInfoQueryVo, menuInfoVos);
        LOGGER.info("End queryHighRiskCommandInfo");
        return highRiskMenuInfoQueryVo;
    }

    private void putHighRiskMenuInfo(UserAuthenticateInfoBo userInfo, Integer pageNum, Integer pageSize, HighRiskMenuInfoQueryVo infoQueryVo, List<MenuInfoVo> menuInfoVos) {
        DeviceIdInfoBo deviceIdInfoBo = this.deviceIdInfoDao.queryDeviceInfo(this.getWindowsAccount());
        List<BlockListMenuInfoBo> highRiskMenuInfoBos = this.blockListMenuInfoDao.queryBlockListMenuInfoByUser(userInfo.getLoginAccount(), null, deviceIdInfoBo.getDeviceId(), null);
        PageBean<BlockListMenuInfoBo> pb = new PageBean<BlockListMenuInfoBo>(pageNum, pageSize, highRiskMenuInfoBos);
        for (BlockListMenuInfoBo high : pb.getList()) {
            MenuInfoVo menuInfoVo = new MenuInfoVo();
            BeanUtils.copyProperties((Object)high, (Object)menuInfoVo);
            menuInfoVos.add(menuInfoVo);
        }
        ArrayList<InternationalizeBo> internationalizeBos = this.dataInternationalizationUtil.getRegOfficeProductInternationalizeBos();
        this.dataInternationalizationUtil.setInternationalizeData(LanguageManager.getInstance().getCurLanguage().toLanguageTag(), menuInfoVos, (List<InternationalizeBo>)internationalizeBos);
        infoQueryVo.setTotal(this.blockListMenuInfoDao.queryHighRiskMenuInfoCount(userInfo.getLoginAccount(), deviceIdInfoBo.getDeviceId()));
        infoQueryVo.setMenuInfoVos(menuInfoVos);
    }

    private void putWhiteMenuInfo(UserAuthenticateInfoBo userInfo, Integer pageNum, Integer pageSize, HighRiskMenuInfoQueryVo infoQueryVo, List<MenuInfoVo> menuInfoVos) {
        DeviceIdInfoBo deviceIdInfoBo = this.deviceIdInfoDao.queryDeviceInfo(this.getWindowsAccount());
        List<WhiteListMenuInfoBo> whiteListMenuInfoBos = this.whiteListMenuInfoDao.queryWhiteListMenuInfoByUser(userInfo.getLoginAccount(), null, deviceIdInfoBo.getDeviceId(), null);
        PageBean<WhiteListMenuInfoBo> pb = new PageBean<WhiteListMenuInfoBo>(pageNum, pageSize, whiteListMenuInfoBos);
        for (WhiteListMenuInfoBo white : pb.getList()) {
            MenuInfoVo menuInfoVo = new MenuInfoVo();
            BeanUtils.copyProperties((Object)white, (Object)menuInfoVo);
            menuInfoVo.setOperator(userInfo.getLoginAccountName());
            menuInfoVos.add(menuInfoVo);
        }
        ArrayList<InternationalizeBo> internationalizeBos = this.dataInternationalizationUtil.getRegOfficeProductInternationalizeBos();
        this.dataInternationalizationUtil.setInternationalizeData(LanguageManager.getInstance().getCurLanguage().toLanguageTag(), menuInfoVos, (List<InternationalizeBo>)internationalizeBos);
        infoQueryVo.setTotal(this.whiteListMenuInfoDao.queryWhiteListMenuInfoCount(userInfo.getLoginAccount(), deviceIdInfoBo.getDeviceId()));
        infoQueryVo.setMenuInfoVos(menuInfoVos);
    }
}

