/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.VerifyCodeRecordBo;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.VerifyCodeRecordDao;
import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.RsaUtil;
import com.huawei.netcareinsidesdk.utils.VerifyCodeUtil;
import com.huawei.netcareinsidesdk.vo.TaskVo;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScanCompleteSwingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanCompleteSwingService.class);
    private static TaskInfoBo taskInfoCache;
    @Autowired
    private VerifyCodeUtil verifyCodeUtil;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private VerifyCodeRecordDao verifyCodeRecordDao;

    public String getTaskCompletionStatusQR(TaskVo taskVo) {
        LOGGER.info("Start getTaskCompletionStatusQR");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("The current effective user does not exist!");
            throw new NetCareInsideSdkException("The current effective user does not exist!");
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryTaskInfoByTaskId(taskVo.getTaskId());
        if (Objects.isNull(taskInfoBo)) {
            LOGGER.error("Task {} does not exist.", (Object)taskVo.getTaskId());
            throw new NetCareInsideSdkException("The task does not exist.");
        }
        String taskType = taskInfoBo.getTaskType();
        if (Objects.nonNull(taskType) && !StringUtils.equalsAny((CharSequence)taskType, (CharSequence[])new CharSequence[]{TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeEn()})) {
            LOGGER.error("The task type must be change operation or routine mobile network.");
            throw new NetCareInsideSdkException("The task type must be change operation or routine mobile network.");
        }
        if (Objects.nonNull(taskInfoBo.getTaskStatus()) && !TaskStatusNameEnum.ONGOING.getCode().equals(taskInfoBo.getTaskStatus())) {
            LOGGER.error("The task status must be In Progress.");
            throw new NetCareInsideSdkException("The task status must be In Progress.");
        }
        String verifyCode = this.verifyCodeUtil.generalVerifyCode(6);
        this.insertVerifyCodeRecord(taskVo.getTaskId(), userAuthenticateInfoBo, verifyCode);
        ScanCompleteSwingService.setTaskInfoBo(new TaskInfoBo());
        taskInfoCache.setTaskId(taskVo.getTaskId());
        taskInfoCache.setTaskExecutor(userAuthenticateInfoBo.getLoginAccount());
        String pubkey = PropertyUtil.getString("pubkeyByEncrypt");
        String accountOrVerifyCode = null;
        try {
            accountOrVerifyCode = Objects.nonNull(userAuthenticateInfoBo.getIsPublicOmTerminal()) && userAuthenticateInfoBo.getIsPublicOmTerminal().booleanValue() ? URLEncoder.encode(RsaUtil.encrypt(verifyCode, pubkey), "UTF-8") : URLEncoder.encode(RsaUtil.encrypt(verifyCode + "@" + userAuthenticateInfoBo.getLoginAccount(), pubkey), "UTF-8");
        }
        catch (UnsupportedEncodingException | GeneralSecurityException except) {
            LOGGER.error("get accountAndVerifyCodeEncrypt exception.");
            return null;
        }
        String siteInfo = StringUtils.isNotBlank((CharSequence)userAuthenticateInfoBo.getSite()) ? userAuthenticateInfoBo.getSite() : "China";
        String offlineTaskUrl = PropertyUtil.getScanQrUrl("offlineTaskCompleteUrl", siteInfo);
        return offlineTaskUrl + "?" + String.join((CharSequence)"&", "taskId=" + taskVo.getTaskId(), "accountAndVerifyCode=" + accountOrVerifyCode);
    }

    private void insertVerifyCodeRecord(String taskId, UserAuthenticateInfoBo userAuthenticateInfoBo, String verifyCode) {
        VerifyCodeRecordBo verifyCodeBo = new VerifyCodeRecordBo();
        verifyCodeBo.setVerifyType("\u4efb\u52a1\u9a8c\u8bc1");
        verifyCodeBo.setTaskId(taskId);
        verifyCodeBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        verifyCodeBo.setAccount(userAuthenticateInfoBo.getLoginAccount());
        verifyCodeBo.setVerifyCode(verifyCode);
        verifyCodeBo.setVerifyStatus(2);
        verifyCodeBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
        verifyCodeBo.setActivePeriod("30");
        this.verifyCodeRecordDao.insertRecord(verifyCodeBo);
        LOGGER.info("VerifyCodeRecordBo insert success.");
    }

    private static void setTaskInfoBo(TaskInfoBo taskInfoCache) {
        ScanCompleteSwingService.taskInfoCache = taskInfoCache;
    }

    public Result checkTaskCompletionStatusQRVerifyCode(VerifyCodeVo verifyCodeVo) {
        LOGGER.error("checkTaskCompletionStatusQRVerifyCode enter.");
        UserAuthenticateInfoBo userAuthenticateBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateBo)) {
            LOGGER.error("The current effective user does not exist!");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        if (Objects.isNull(taskInfoCache)) {
            return Result.fail(ErrorCodeEnum.GENERATE_QR_CODE.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.GENERATE_QR_CODE.getErrorCode()));
        }
        Map<String, String> checkResultMap = this.verifyCodeUtil.checkVerifyCode(taskInfoCache, verifyCodeVo.getVerifyCode(), "\u4efb\u52a1\u9a8c\u8bc1", 1);
        String errorCode = checkResultMap.get("errorCode");
        String checkResultMsg = checkResultMap.get("errorMsg");
        if (StringUtils.isNotEmpty((CharSequence)checkResultMsg)) {
            LOGGER.error(checkResultMsg);
            return Result.fail(errorCode, checkResultMsg);
        }
        taskInfoCache.setTaskStatus(TaskStatusNameEnum.COMPLETE.getCode());
        taskInfoCache.setIsCurTask(false);
        this.taskInfoDao.updateTask(taskInfoCache);
        LOGGER.info("Check verifyCode success, task {} update status success.", (Object)taskInfoCache.getTaskId());
        return Result.success();
    }
}

