/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.TaskFinishBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskSubtypeBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.InitManageControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.EngineeringCommissioningNesMapper;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskSubtypeDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.VerifyCodeRecordDao;
import com.huawei.netcareinsidesdk.swing.pageService.ApplyWorkOrderPage;
import com.huawei.netcareinsidesdk.swing.pageService.ControlPolicyTips;
import com.huawei.netcareinsidesdk.swing.pageService.OrderDetailPage;
import com.huawei.netcareinsidesdk.swing.pageService.OrderInfoWarningPage;
import com.huawei.netcareinsidesdk.swing.pageService.RollbackComplete;
import com.huawei.netcareinsidesdk.swing.pageService.RollbackCompleteAbroad;
import com.huawei.netcareinsidesdk.swing.pageService.RollbackCompleteAbroadPosition;
import com.huawei.netcareinsidesdk.swing.pageService.RollbackCompletePosition;
import com.huawei.netcareinsidesdk.swing.pageService.ScanComplete;
import com.huawei.netcareinsidesdk.swing.pageService.WorkOrderFinishPage;
import com.huawei.netcareinsidesdk.utils.CommonDataDeal;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.utils.VerifyCodeUtil;
import com.huawei.netcareinsidesdk.vo.UpdateTaskInfoParamVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import javax.swing.JDialog;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskOperationSwingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskOperationSwingService.class);
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private VerifyCodeRecordDao verifyCodeRecordDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private VerifyCodeUtil verifyCodeUtil;
    @Autowired
    private TaskSubtypeDao taskSubtypeDao;
    @Autowired
    private DeviceInfoDao deviceInfoDao;
    @Autowired
    private EngineeringCommissioningNesMapper nesMapper;
    @Autowired
    private ApplyWorkOrderPage applyWorkOrderPage;
    @Autowired
    private OrderInfoWarningPage orderInfoWarningPage;
    @Autowired
    private WorkOrderFinishPage workOrderFinishPage;
    @Autowired
    private ScanComplete scanComplete;
    @Autowired
    private RollbackComplete rollbackComplete;
    @Autowired
    private CommonDataDeal commonDataDeal;
    @Autowired
    private RollbackCompletePosition rollbackCompletePosition;
    @Autowired
    private RollbackCompleteAbroad rollbackCompleteAbroad;
    @Autowired
    private RollbackCompleteAbroadPosition rollbackCompleteAbroadPosition;
    @Autowired
    private ControlPolicyTips controlPolicyTips;

    public Result applyTask(OrderDetailPage detailPage) {
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("The current effective user does not exist!");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        if (Objects.nonNull(userAuthenticateInfoBo.getInitManageControlPolicy()) && !StringUtils.equals((CharSequence)userAuthenticateInfoBo.getInitManageControlPolicy(), (CharSequence)InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode())) {
            this.controlPolicyTips.controlPolicyTips();
            return Result.success();
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        boolean isConnected = hasConnectedClient.get("isConnected");
        JSONObject returnUrlJsonObj = new JSONObject();
        if (isConnected) {
            if (Objects.nonNull(taskInfoBo)) {
                this.orderInfoWarningPage.getOrderInfoWaringFrame(true);
            } else {
                this.orderInfoWarningPage.getOrderInfoWaringFrame(false);
            }
        } else {
            this.applyWorkOrderPage.generateWorkOrderPage(Objects.nonNull(taskInfoBo), StringUtils.isEmpty((CharSequence)userAuthenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)userAuthenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{"027425", "common"}), detailPage, new ArrayList<Integer>());
        }
        return Result.success(returnUrlJsonObj);
    }

    public Result updateTaskInfo(JDialog mainJFrame, UpdateTaskInfoParamVo updateTaskInfoParamVo, OrderDetailPage orderDetailPage) {
        LOGGER.info("Start operateTask.");
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(authenticateInfoBo)) {
            LOGGER.error("This userAuthenticateInfo is abnormal.");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        TaskInfoBo taskInfoInDb = this.taskInfoDao.queryTaskInfoByTaskId(updateTaskInfoParamVo.getTaskId());
        if (Objects.isNull(taskInfoInDb) || DateUtil.getUtcDate(new Date()).after(taskInfoInDb.getTaskEndTime())) {
            LOGGER.error("Invalid task ID.");
            return Result.fail(ErrorCodeEnum.TICKET_ID_NOT_EXIST.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TICKET_ID_NOT_EXIST.getErrorCode()));
        }
        TaskInfoBo taskInfoBo = new TaskInfoBo();
        BeanUtils.copyProperties((Object)updateTaskInfoParamVo, (Object)taskInfoBo);
        taskInfoBo.setTaskStatus(Integer.valueOf(updateTaskInfoParamVo.getTaskStatus()));
        JSONObject returnObj = new JSONObject();
        if (String.valueOf(TaskStatusNameEnum.CANCEL.getCode()).equals(updateTaskInfoParamVo.getTaskStatus())) {
            return this.cancelTask(taskInfoInDb, taskInfoBo);
        }
        if (String.valueOf(TaskStatusNameEnum.COMPLETE.getCode()).equals(updateTaskInfoParamVo.getTaskStatus())) {
            return this.completeTask(mainJFrame, updateTaskInfoParamVo, authenticateInfoBo, taskInfoBo, returnObj, orderDetailPage);
        }
        return this.cutCurTask(updateTaskInfoParamVo, authenticateInfoBo, taskInfoInDb, taskInfoBo, returnObj);
    }

    private Result cutCurTask(UpdateTaskInfoParamVo updateTaskInfoParamVo, UserAuthenticateInfoBo authenticateInfoBo, TaskInfoBo taskInfoInDb, TaskInfoBo taskInfoBo, JSONObject returnObj) {
        String windowsAccount;
        DeviceIdInfoBo deviceIdInfoBo;
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        if (hasConnectedClient.get("isConnected").booleanValue()) {
            LOGGER.warn("The connection between inside and NetCareClient is detected. If you want to switch tasks, set the current task on the NetCareClient and click to NetCare task refresh.");
            this.putResultMessage(returnObj, "0", this.internationalizeUtil.getMessage("10049"));
            return Result.success(returnObj);
        }
        if (!Objects.equals(taskInfoInDb.getTaskStatus(), TaskStatusNameEnum.TO_DO.getCode())) {
            LOGGER.error("Only to-do tasks can be executed.");
            return Result.fail(ErrorCodeEnum.ONLY_TODO_TICKET_CANCEL.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.ONLY_TODO_TICKET_CANCEL.getErrorCode()));
        }
        TaskSubtypeBo taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(updateTaskInfoParamVo.getTaskId());
        if (Objects.isNull(taskSubtypeBo)) {
            if (StringUtils.equals((CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), (CharSequence)taskInfoInDb.getTaskType())) {
                if (DateUtil.getUtcDate(new Date()).before(taskInfoInDb.getOperationPreparationTime())) {
                    LOGGER.warn("Not reach the task preparation time. Switch to Ongoing status not allowed.");
                    this.putResultMessage(returnObj, "0", this.internationalizeUtil.getMessage("10058"));
                    return Result.success(returnObj);
                }
            } else if (DateUtil.getUtcDate(new Date()).before(taskInfoInDb.getTaskStartTime())) {
                LOGGER.warn("The current time is not within the task time range.");
                this.putResultMessage(returnObj, "0", this.internationalizeUtil.getMessage("10050"));
                return Result.success(returnObj);
            }
        }
        if (Objects.nonNull(deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(windowsAccount = this.getWindowsAccount())) && "Easy-CRT".equals(deviceIdInfoBo.getDeviceId())) {
            this.cutTaskInEasyCrtTool(returnObj, authenticateInfoBo, taskInfoInDb);
            return Result.success(returnObj);
        }
        TaskInfoBo curTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), authenticateInfoBo.getLoginAccount());
        if (Objects.nonNull(curTask)) {
            this.updateCurTaskStatusToDo(curTask);
        }
        this.taskInfoDao.setCurTask(taskInfoBo.getTaskId());
        this.taskInfoDao.setOtherTask(taskInfoBo.getTaskId(), authenticateInfoBo.getLoginAccount());
        LOGGER.info("In Mop tool, The current task is switched from {} to {} success.", (Object)(Objects.nonNull(curTask) ? curTask.getTaskId() : null), (Object)taskInfoBo.getTaskId());
        return Result.success();
    }

    private Result completeTask(JDialog mainJFrame, UpdateTaskInfoParamVo updateTaskInfoParamVo, UserAuthenticateInfoBo authenticateInfoBo, TaskInfoBo taskInfoBo, JSONObject returnObj, OrderDetailPage orderDetailPage) {
        TaskInfoBo curActiveTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), authenticateInfoBo.getLoginAccount());
        if (!StringUtils.equals((CharSequence)taskInfoBo.getTaskId(), (CharSequence)curActiveTask.getTaskId())) {
            LOGGER.error("Only the current task can be completed.");
            return Result.fail(ErrorCodeEnum.ONLY_CURRENT_TICKET_COMPLETED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.ONLY_CURRENT_TICKET_COMPLETED.getErrorCode()));
        }
        if (TaskTypeEnum.QUERY.getTaskTypeEn().equals(curActiveTask.getTaskType()) && !StringUtils.equals((CharSequence)"027425", (CharSequence)authenticateInfoBo.getRegionCode())) {
            LOGGER.info("The current task is not a change operation. The task cannot be completed.");
            return Result.fail(ErrorCodeEnum.TASK_NOT_COMPLETE_EXCEPTION.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TASK_NOT_COMPLETE_EXCEPTION.getErrorCode()));
        }
        if (Objects.nonNull(this.taskSubtypeDao.queryTaskSubtype(updateTaskInfoParamVo.getTaskId()))) {
            LOGGER.warn("The Easy-Crt task must be completed on the dotting completion interface.");
            this.putResultMessage(returnObj, "0", this.internationalizeUtil.getMessage("10047"));
            return Result.success(returnObj);
        }
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        if (hasConnectedClient.get("isConnected").booleanValue()) {
            if (!StringUtils.equals((CharSequence)"\u672c\u5730\u81ea\u5efa", (CharSequence)curActiveTask.getTaskObtainMode())) {
                return this.completeTaskFromNetCareClient(mainJFrame, curActiveTask, returnObj, taskInfoBo, authenticateInfoBo);
            }
            if (StringUtils.equalsAny((CharSequence)curActiveTask.getTaskType(), (CharSequence[])new CharSequence[]{TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeEn()})) {
                LOGGER.info("NetCare Client is connected, scan the QR code to complete the task {}.", (Object)curActiveTask.getTaskId());
                this.putResultMessage(returnObj, "1", "scan the QR code to complete the task");
                mainJFrame.dispose();
                this.scanComplete.scanComplete(curActiveTask, orderDetailPage);
                return Result.success(returnObj);
            }
        } else if (StringUtils.equalsAny((CharSequence)curActiveTask.getTaskType(), (CharSequence[])new CharSequence[]{TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeEn()})) {
            LOGGER.info("NetCare Client is not connected, scan the QR code to complete the task {}.", (Object)curActiveTask.getTaskId());
            this.putResultMessage(returnObj, "1", "scan the QR code to complete the task");
            mainJFrame.dispose();
            this.scanComplete.scanComplete(curActiveTask, orderDetailPage);
            return Result.success(returnObj);
        }
        taskInfoBo.setIsCurTask(false);
        this.taskInfoDao.updateTask(taskInfoBo);
        LOGGER.info("Task {} completion success.", (Object)taskInfoBo.getTaskId());
        return Result.success();
    }

    private Result cancelTask(TaskInfoBo taskInfoInDb, TaskInfoBo taskInfoBo) {
        if (!Objects.equals(taskInfoInDb.getTaskStatus(), TaskStatusNameEnum.TO_DO.getCode())) {
            LOGGER.error("Only to-do or ongoing tasks can be canceled.");
            return Result.fail(ErrorCodeEnum.ONLY_TODO_TICKET_CANCEL.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.ONLY_TODO_TICKET_CANCEL.getErrorCode()));
        }
        taskInfoBo.setIsCurTask(false);
        this.taskInfoDao.updateTask(taskInfoBo);
        this.deleteEngineeringCommissioningNesByTaskId(taskInfoInDb);
        LOGGER.info("Task {} cancel success.", (Object)taskInfoBo.getTaskId());
        return Result.success();
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    private void updateCurTaskStatusToDo(TaskInfoBo taskInfoBo) {
        if (Objects.nonNull(taskInfoBo)) {
            TaskInfoBo curtTaskBo = new TaskInfoBo();
            curtTaskBo.setTaskId(taskInfoBo.getTaskId());
            curtTaskBo.setTaskStatus(TaskStatusNameEnum.TO_DO.getCode());
            curtTaskBo.setIsCurTask(false);
            this.taskInfoDao.updateTask(curtTaskBo);
        }
    }

    private void cutTaskInEasyCrtTool(JSONObject jsonObject, UserAuthenticateInfoBo authenticateInfoBo, TaskInfoBo updateTaskInfo) {
        TaskInfoBo curTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), authenticateInfoBo.getLoginAccount());
        TaskSubtypeBo updateTaskSubTypeBo = this.taskSubtypeDao.queryTaskSubtype(updateTaskInfo.getTaskId());
        if (Objects.isNull(curTask)) {
            if (Objects.isNull(updateTaskSubTypeBo)) {
                this.setCurTaskAndPutTip(jsonObject, updateTaskInfo, authenticateInfoBo);
                LOGGER.info("No current task. Switch task {} to the current task success.", (Object)updateTaskInfo.getTaskId());
            } else {
                this.putResultMessage(jsonObject, "0", this.internationalizeUtil.getMessage("10052"));
            }
            return;
        }
        this.updateCurTaskStatusToDo(curTask);
        if (Objects.nonNull(updateTaskSubTypeBo) || Objects.nonNull(this.taskSubtypeDao.queryTaskSubtype(curTask.getTaskId()))) {
            this.putResultMessage(jsonObject, "0", this.internationalizeUtil.getMessage("10052"));
        } else {
            this.setCurTaskAndPutTip(jsonObject, updateTaskInfo, authenticateInfoBo);
            LOGGER.info("The current task is switched from {} to {} success.", (Object)curTask.getTaskId(), (Object)updateTaskInfo.getTaskId());
        }
    }

    private void setCurTaskAndPutTip(JSONObject jsonObject, TaskInfoBo updateTaskInfo, UserAuthenticateInfoBo authenticateInfoBo) {
        this.putResultMessage(jsonObject, "0", this.internationalizeUtil.getMessage("10051"));
        this.taskInfoDao.setCurTask(updateTaskInfo.getTaskId());
        this.taskInfoDao.setOtherTask(updateTaskInfo.getTaskId(), authenticateInfoBo.getLoginAccount());
    }

    private void putResultMessage(JSONObject returnObj, String resultCode, String resultMessage) {
        returnObj.put("resultCode", (Object)resultCode);
        returnObj.put("resultMessage", (Object)resultMessage);
    }

    private Result completeTaskFromNetCareClient(JDialog mainJFrame, TaskInfoBo curActiveTask, JSONObject returnObj, TaskInfoBo taskInfoBo, UserAuthenticateInfoBo authenticateInfoBo) {
        LOGGER.info("NetCare Client is connected, invoke the client interface to complete the task {}.", (Object)curActiveTask.getTaskId());
        RequestData data = new RequestData();
        data.setUrl(PropertyUtil.getString("completeTaskFromNetCareClientUrl"));
        data.setType("POST");
        JSONObject paramJson = new JSONObject();
        paramJson.put("taskNum", (Object)taskInfoBo.getTaskId());
        data.setParam(paramJson);
        JSONObject returnResult = HttpUtil.sendRest(data);
        LOGGER.info("NetCare Client returnObj is {}", (Object)(Objects.nonNull(returnResult) ? returnResult.toJSONString() : null));
        if (Objects.nonNull(returnResult) && returnResult.containsKey((Object)"returnValue")) {
            String returnValue;
            switch (returnValue = returnResult.getString("returnValue")) {
                case "10060": {
                    taskInfoBo.setIsCurTask(false);
                    this.taskInfoDao.updateTask(taskInfoBo);
                    this.deleteEngineeringCommissioningNesByTaskId(curActiveTask);
                    LOGGER.info("Task {} completion success.", (Object)taskInfoBo.getTaskId());
                    return Result.success();
                }
                case "10063": {
                    LOGGER.info("Task {} not completion.", (Object)taskInfoBo.getTaskId());
                    this.putResultMessage(returnObj, "0", this.internationalizeUtil.getMessage("10054"));
                    return Result.success(returnObj);
                }
                case "10065": {
                    String guid = UUID.randomUUID().toString();
                    this.workOrderFinish(mainJFrame, curActiveTask, guid);
                    this.getCompleteResultMessage(returnObj, guid);
                    return Result.success(returnObj);
                }
                case "10066": {
                    this.getRollbackCompleteResultMessage(mainJFrame, returnObj, authenticateInfoBo, curActiveTask);
                    return Result.success(returnObj);
                }
                case "10067": {
                    this.putResultMessage(returnObj, "0", this.internationalizeUtil.getMessage("10048"));
                    return Result.success(returnObj);
                }
            }
            LOGGER.error("NetCare Client return error.");
            return Result.fail(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode()));
        }
        LOGGER.error("NetCare Client return error.");
        return Result.fail(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode()));
    }

    private void workOrderFinish(JDialog mainJFrame, TaskInfoBo curActiveTask, String guid) {
        mainJFrame.dispose();
        if (this.commonDataDeal.checkPositionAllowanceEmployee(curActiveTask.getTaskExecutorName())) {
            LOGGER.info("is huawei.");
            this.workOrderFinishPage.drawNormalWorkOrderFinish(0, curActiveTask, null, guid);
        } else {
            LOGGER.info("no huawei.");
            this.workOrderFinishPage.drawNormalWorkOrderFinish(1, curActiveTask, null, guid);
        }
    }

    private void getCompleteResultMessage(JSONObject returnObj, String guid) {
        returnObj.put("guid", (Object)guid);
        returnObj.put("resultCode", (Object)"1");
        returnObj.put("resultMessage", (Object)"Work Order finish.");
    }

    private void getRollbackCompleteResultMessage(JDialog mainJFrame, JSONObject returnObj, UserAuthenticateInfoBo authenticateInfoBo, TaskInfoBo curActiveTask) {
        String plannedNes = Objects.isNull(curActiveTask.getPlannedNes()) ? "0" : curActiveTask.getPlannedNes();
        boolean isHuawei = this.commonDataDeal.checkPositionAllowanceEmployee(curActiveTask.getTaskExecutorName());
        TaskFinishBo taskFinishBo = new TaskFinishBo();
        taskFinishBo.setTaskId(curActiveTask.getTaskId());
        taskFinishBo.setPlannedNes(plannedNes);
        String guid = UUID.randomUUID().toString();
        returnObj.put("resultCode", (Object)"1");
        returnObj.put("guid", (Object)guid);
        taskFinishBo.setGuid(guid);
        taskFinishBo.setInteface("updateTaskInfo");
        if (StringUtils.isEmpty((CharSequence)authenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)authenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{"027425", "common"})) {
            mainJFrame.dispose();
            if (isHuawei) {
                returnObj.put("resultMessage", (Object)"The rollback in the China Region is completed, including position allowances.");
                this.rollbackCompletePosition.rollbackNotContainDelay(taskFinishBo);
            } else {
                returnObj.put("resultMessage", (Object)"The rollback in the China Region is complete, excluding position allowances.");
                this.rollbackComplete.rollbackNotContainPositionAndDelay(taskFinishBo);
            }
        } else {
            mainJFrame.dispose();
            if (isHuawei) {
                returnObj.put("resultMessage", (Object)"Overseas rollback is completed, including position allowance.");
                this.rollbackCompleteAbroadPosition.abroadRollbackPosition(taskFinishBo);
            } else {
                returnObj.put("resultMessage", (Object)"The position allowance is not included after the overseas rollback is complete.");
                this.rollbackCompleteAbroad.abroadRollback(taskFinishBo);
            }
        }
    }

    private void deleteEngineeringCommissioningNesByTaskId(TaskInfoBo curActiveTask) {
        if (StringUtils.equals((CharSequence)curActiveTask.getTaskType(), (CharSequence)TaskTypeEnum.PROJECT.getTaskTypeEn())) {
            this.nesMapper.deleteEngineeringCommissioningNesByTaskId(curActiveTask.getTaskId());
            LOGGER.info("deleteEngineeringCommissioningNesByTaskId success.");
        }
    }
}

