/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.DotInfoBo;
import com.huawei.netcareinsidesdk.bo.InternationalizeBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.TaskDotFinishBo;
import com.huawei.netcareinsidesdk.bo.TaskDotInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskSubtypeBo;
import com.huawei.netcareinsidesdk.bo.ToolConfig;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.VerifyCodeRecordBo;
import com.huawei.netcareinsidesdk.constants.ControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.FileTypeEnum;
import com.huawei.netcareinsidesdk.constants.InsidePolicyEnum;
import com.huawei.netcareinsidesdk.constants.InterceptPolicyEnum;
import com.huawei.netcareinsidesdk.constants.LocalTaskTypeEnum;
import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.constants.TaskSubtypeEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.DotInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskSubtypeDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.VerifyCodeRecordDao;
import com.huawei.netcareinsidesdk.dto.TaskDotFinishDto;
import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.swing.utils.ApplyOrderComponentUtils;
import com.huawei.netcareinsidesdk.utils.CmsSignUtils;
import com.huawei.netcareinsidesdk.utils.CommonDataDeal;
import com.huawei.netcareinsidesdk.utils.DataInternationalizationUtil;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.FileDealUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.JsonParseUtils;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.PageBean;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.RsaUtil;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.utils.VerifyCodeUtil;
import com.huawei.netcareinsidesdk.utils.ZipUtils;
import com.huawei.netcareinsidesdk.vo.PageRequestVo;
import com.huawei.netcareinsidesdk.vo.TaskDelayInfoVo;
import com.huawei.netcareinsidesdk.vo.TaskInfoQuery;
import com.huawei.netcareinsidesdk.vo.TaskInfoQueryListVo;
import com.huawei.netcareinsidesdk.vo.TaskInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.TaskInfoVo;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import com.huawei.us.common.file.UsFileSafeUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TaskServiceSwingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceSwingService.class);
    private static TaskInfoBo taskInfoCache;
    private static final String TEMP_PATH;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private VerifyCodeRecordDao verifyCodeRecordDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private ApplyOrderComponentUtils applyOrderComponentUtils;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private TaskSubtypeDao taskSubtypeDao;
    @Autowired
    private DotInfoDao dotInfoDao;
    @Autowired
    private DeviceInfoDao deviceInfoDao;
    @Autowired
    private VerifyCodeUtil verifyCodeUtil;
    @Autowired
    private CommonDataDeal commonDataDeal;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private DataInternationalizationUtil dataInternationalizationUtil;

    public String getEncryptStr(TaskInfoVo taskInfoVo) {
        LOGGER.info("Start getEncryptStr");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("The current effective user does not exist!");
            throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("NOT_EXIST_USER"));
        }
        this.checkTaskInfoVo(taskInfoVo);
        this.calculateTaskTime(taskInfoVo);
        String commandVersionStr = this.getCommandVersionStr(taskInfoVo, userAuthenticateInfoBo);
        String taskId = "iTK" + DateUtil.formatDateToStr(new Date(), "yyyyMMddHHmmss");
        String verifyCode = this.generalVerifyCodeStr(taskInfoVo, taskId, userAuthenticateInfoBo);
        this.cacheTaskInfo(userAuthenticateInfoBo, taskInfoVo, taskId);
        String pubkey = PropertyUtil.getString("pubkeyByEncrypt");
        String accountAndVerifyCodeEncrypt = null;
        try {
            accountAndVerifyCodeEncrypt = Objects.nonNull(userAuthenticateInfoBo.getIsPublicOmTerminal()) && userAuthenticateInfoBo.getIsPublicOmTerminal().booleanValue() ? URLEncoder.encode(RsaUtil.encrypt(verifyCode, pubkey), "UTF-8") : URLEncoder.encode(RsaUtil.encrypt(verifyCode + "@" + userAuthenticateInfoBo.getLoginAccount(), pubkey), "UTF-8");
        }
        catch (UnsupportedEncodingException | GeneralSecurityException except) {
            LOGGER.error("Get accountAndVerifyCodeEncrypt failed.");
            return null;
        }
        LOGGER.info("End getEncryptStr");
        return this.joinParamsInQR(taskInfoVo, userAuthenticateInfoBo, commandVersionStr, taskId, accountAndVerifyCodeEncrypt);
    }

    private String joinParamsInQR(TaskInfoVo taskInfoVo, UserAuthenticateInfoBo userAuthenticateInfoBo, String commandVersionStr, String taskId, String accountAndVerifyCodeEncrypt) {
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(windowsAccount);
        String offlineTaskUrl = this.applyOrderComponentUtils.getOfflineTaskUrl(taskInfoVo.getTaskTypeCode(), userAuthenticateInfoBo);
        String joinStr = String.join((CharSequence)"&", "deviceId=" + (Objects.isNull(deviceIdInfoBo.getDeviceId()) ? "" : deviceIdInfoBo.getDeviceId()), "taskId=" + taskId, "accountAndVerifyCode=" + accountAndVerifyCodeEncrypt, "taskStartTime=" + taskInfoVo.getTaskStartTime().getTime(), "taskEndTime=" + taskInfoVo.getTaskEndTime().getTime());
        if (StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.QUERY.getTaskTypeCode())) {
            joinStr = String.join((CharSequence)"&", joinStr, "&isDomestic=" + (StringUtils.isEmpty((CharSequence)userAuthenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)userAuthenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{"027425", "common"})));
        }
        if (StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode())) {
            joinStr = StringUtils.isNotBlank((CharSequence)userAuthenticateInfoBo.getCustomerGroup()) ? String.join((CharSequence)"&", joinStr, "customerGroup=" + userAuthenticateInfoBo.getCustomerGroup()) : String.join((CharSequence)"&", joinStr, "responsibleNetworkCode=" + (Objects.isNull(userAuthenticateInfoBo.getResponsibleNetworkCode()) ? "" : userAuthenticateInfoBo.getResponsibleNetworkCode()));
            return offlineTaskUrl + "?" + String.join((CharSequence)"&", joinStr, "prePolicy=" + (Objects.isNull(userAuthenticateInfoBo.getOperationPreparationInsidePolicy()) ? "" : userAuthenticateInfoBo.getOperationPreparationInsidePolicy()), "version=" + (Objects.isNull(commandVersionStr) ? "" : commandVersionStr), "operationPreparationTime=" + taskInfoVo.getOperationPreparationTime().getTime());
        }
        if (!StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.EMERGENCY.getTaskTypeCode())) {
            joinStr = StringUtils.isNotBlank((CharSequence)userAuthenticateInfoBo.getCustomerGroup()) ? String.join((CharSequence)"&", joinStr, "customerGroup=" + userAuthenticateInfoBo.getCustomerGroup()) : String.join((CharSequence)"&", joinStr, "responsibleNetworkCode=" + (Objects.isNull(userAuthenticateInfoBo.getResponsibleNetworkCode()) ? "" : userAuthenticateInfoBo.getResponsibleNetworkCode()));
        }
        if (StringUtils.equalsAny((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence[])new CharSequence[]{TaskTypeEnum.EMERGENCY.getTaskTypeCode(), TaskTypeEnum.PROJECT.getTaskTypeCode()})) {
            joinStr = String.join((CharSequence)"&", joinStr, "operationDuration=" + taskInfoVo.getOperationDuration());
        }
        return offlineTaskUrl + "?" + joinStr;
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    private void cacheTaskInfo(UserAuthenticateInfoBo userAuthenticateInfoBo, TaskInfoVo taskInfoVo, String taskId) {
        TaskServiceSwingService.setTaskInfoBo(new TaskInfoBo());
        taskInfoCache.setTaskId(taskId);
        if (StringUtils.isNotEmpty((CharSequence)taskInfoVo.getTaskName())) {
            taskInfoCache.setTaskName(taskInfoVo.getTaskName());
        }
        taskInfoCache.setTaskType(taskInfoVo.getTaskTypeCode());
        taskInfoCache.setTaskExecutor(userAuthenticateInfoBo.getLoginAccount());
        taskInfoCache.setTaskStartTime(taskInfoVo.getTaskStartTime());
        taskInfoCache.setTaskEndTime(taskInfoVo.getTaskEndTime());
        if (StringUtils.equals((CharSequence)taskInfoCache.getTaskType(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode())) {
            LOGGER.info("Adding a field to the cache during the change operation.");
            taskInfoCache.setOperationPreparationTime(taskInfoVo.getOperationPreparationTime());
        }
    }

    private String getCommandVersionStr(TaskInfoVo taskInfoVo, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        if (StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()) && StringUtils.isNotBlank((CharSequence)userAuthenticateInfoBo.getCommandVersion())) {
            return userAuthenticateInfoBo.getCommandVersion();
        }
        return null;
    }

    public Result checkOfflineTaskVerifyCode(VerifyCodeVo verifyCodeVo) {
        LOGGER.info("checkOfflineTaskVerifyCode enter.");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("The current effective user does not exist!");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        if (Objects.isNull(taskInfoCache)) {
            LOGGER.error("Refresh the task delay QR code.");
            return Result.fail(ErrorCodeEnum.GENERATE_QR_CODE.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.GENERATE_QR_CODE.getErrorCode()));
        }
        int codeNum = StringUtils.equalsAny((CharSequence)taskInfoCache.getTaskType(), (CharSequence[])new CharSequence[]{TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeCode(), TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeEn()}) ? 7 : (StringUtils.equalsAny((CharSequence)taskInfoCache.getTaskType(), (CharSequence[])new CharSequence[]{TaskTypeEnum.QUERY.getTaskTypeCode(), TaskTypeEnum.QUERY.getTaskTypeEn()}) ? 2 : 1);
        Map<String, String> checkResultMap = this.verifyCodeUtil.checkVerifyCode(taskInfoCache, verifyCodeVo.getVerifyCode(), "\u4efb\u52a1\u9a8c\u8bc1", codeNum);
        String errorCode = checkResultMap.get("errorCode");
        String checkResult = checkResultMap.get("errorMsg");
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            LOGGER.error(checkResult);
            return Result.fail(errorCode, checkResult);
        }
        this.insertTaskInfo(userAuthenticateInfoBo, checkResultMap.get("verifyCodeType"));
        LOGGER.info("End checkOfflineTaskVerifyCode.");
        return Result.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result importOfflineTask(MultipartFile multipartFile) {
        block30: {
            Serializable serializable;
            boolean isFlag;
            LOGGER.info("Start importOfflineTask.");
            if (!FileDealUtil.isSecureFile(multipartFile)) {
                LOGGER.error("US-Check,Check zip file failed.");
                return Result.fail(ErrorCodeEnum.COMPRESS_PACKAGE_VERIFY_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.COMPRESS_PACKAGE_VERIFY_FAILED.getErrorCode()));
            }
            String errMsg = this.checkOfflineTaskZip(multipartFile);
            if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                LOGGER.error(errMsg);
                return Result.fail(errMsg, this.internationalizeUtil.getMessage(errMsg));
            }
            String path = TEMP_PATH + File.separator;
            File file = new File(path);
            if (!file.exists() && !(isFlag = file.mkdirs())) {
                LOGGER.error("Create temp dir failed.");
                return Result.fail(ErrorCodeEnum.CREATE_TEMP_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.CREATE_TEMP_FAILED.getErrorCode()));
            }
            try {
                Result result;
                InputStream fileStream = multipartFile.getInputStream();
                serializable = null;
                try {
                    JSONObject warnMsgJsonObj = new JSONObject();
                    String resultCode = this.parseAndImportTask(multipartFile, path, fileStream, warnMsgJsonObj);
                    if (Objects.nonNull(warnMsgJsonObj.getString("resultMessage"))) {
                        LOGGER.info(warnMsgJsonObj.getString("resultMessage"));
                        Result result2 = Result.success(warnMsgJsonObj);
                        return result2;
                    }
                    if (resultCode == null) break block30;
                    LOGGER.error(resultCode);
                    result = Result.fail(resultCode, this.internationalizeUtil.getMessage(resultCode));
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (fileStream != null) {
                        if (serializable != null) {
                            try {
                                fileStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            fileStream.close();
                        }
                    }
                }
                return result;
            }
            catch (IOException except) {
                LOGGER.error("importOfflineTask error.");
                serializable = Result.fail(ErrorCodeEnum.TICKET_INFO_IMPORT_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TICKET_INFO_IMPORT_FAILED.getErrorCode()));
                return serializable;
            }
            catch (JSONException exception) {
                LOGGER.error("The format of the imported information is incorrect.");
                serializable = Result.fail(ErrorCodeEnum.DATA_PARSE_EXCEPTION.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.DATA_PARSE_EXCEPTION.getErrorCode()));
                return serializable;
            }
            finally {
                FileDealUtil.clearTempFiles(file);
            }
        }
        this.commonDataDeal.updateTaskInfoPolicy();
        LOGGER.info("End importOfflineTask.");
        return Result.success("Import success.");
    }

    private String parseAndImportTask(MultipartFile multipartFile, String path, InputStream fileStream, JSONObject warnMsgJsonObj) throws IOException {
        String safeFilePath = UsFileSafeUtils.getSafeFilePath((String)(path + multipartFile.getOriginalFilename()));
        File zipFile = new File(safeFilePath);
        FileUtils.copyInputStreamToFile((InputStream)fileStream, (File)zipFile);
        String unZipReturnMsg = ZipUtils.unZipFiles(zipFile, path);
        if (Objects.nonNull(unZipReturnMsg)) {
            return unZipReturnMsg;
        }
        String checkSignReturnMsg = this.checkSignFile();
        if (StringUtils.isNotEmpty((CharSequence)checkSignReturnMsg)) {
            return checkSignReturnMsg;
        }
        JSONObject jsonObject = JsonParseUtils.parseJson(TEMP_PATH + File.separator + "offlineTask.json");
        String returnMsg = this.insertOfflineTaskInfo(jsonObject, warnMsgJsonObj);
        if (StringUtils.isNotEmpty((CharSequence)returnMsg)) {
            return returnMsg;
        }
        LOGGER.info("Offline Task import success.");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String checkOfflineTaskZip(MultipartFile multipartFile) {
        if (Objects.isNull(multipartFile) || multipartFile.getOriginalFilename() == null) {
            LOGGER.error("offlineTask zip file is null.");
            return ErrorCodeEnum.COMPRESS_FILE_IS_EMPTY.getErrorCode();
        }
        String fileName = multipartFile.getOriginalFilename();
        try (InputStream inputStream = multipartFile.getInputStream();){
            boolean isOk = FileDealUtil.checkFileType(inputStream, FileTypeEnum.ZIP);
            if (isOk) {
                if (fileName.startsWith("offlineTask")) return "";
            }
            LOGGER.error("offlineTask file check failed.");
            String string = ErrorCodeEnum.COMPRESS_FILE_FORMAT_VERIFY_FAILED.getErrorCode();
            return string;
        }
        catch (IOException except) {
            LOGGER.error("offlineTask file check except.");
            return ErrorCodeEnum.COMPRESS_FILE_FORMAT_VERIFY_FAILED.getErrorCode();
        }
    }

    public List<TaskInfoQueryListVo> getTaskList(List<Integer> taskTypes) {
        LOGGER.info("Start getTaskList.");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        List<TaskInfoBo> taskInfoBos = this.taskInfoDao.queryTasksInTimeRange(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        List<TaskInfoBo> crtFutureTasks = this.taskInfoDao.queryCrtTasksInFutureTime(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        taskInfoBos.addAll(crtFutureTasks);
        ArrayList<TaskInfoQueryListVo> taskInfoVos = new ArrayList<TaskInfoQueryListVo>();
        for (TaskInfoBo taskInfoBo : taskInfoBos) {
            if (!CollectionUtils.isEmpty(taskTypes) && !taskTypes.contains(Integer.parseInt(Objects.requireNonNull(TaskTypeEnum.getTaskTypeCodeByEn(taskInfoBo.getTaskType()))))) continue;
            TaskInfoQueryListVo taskInfoVo = new TaskInfoQueryListVo();
            BeanUtils.copyProperties((Object)taskInfoBo, (Object)taskInfoVo);
            taskInfoVo.setTaskStatus(String.valueOf(taskInfoBo.getTaskStatus()));
            taskInfoVo.setTaskStartTime(taskInfoBo.getTaskStartTime());
            taskInfoVo.setTaskEndTime(taskInfoBo.getTaskEndTime());
            taskInfoVos.add(taskInfoVo);
        }
        DateUtil.dbTimeTranslationWebUtc(taskInfoVos, new String[]{"taskStartTime", "taskEndTime"});
        ArrayList<InternationalizeBo> internationalizeBos = new ArrayList<InternationalizeBo>();
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("taskStatus", "taskStatusName", "taskStatus"));
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("taskType", "taskTypeName", "taskType"));
        this.dataInternationalizationUtil.setInternationalizeData(LanguageManager.getInstance().getCurLanguage().toLanguageTag(), taskInfoVos, (List<InternationalizeBo>)internationalizeBos);
        LOGGER.info("End getTaskList.");
        return taskInfoVos;
    }

    public String getTaskDelayEncryptStr(TaskDelayInfoVo taskDelayInfoVo) {
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("The current effective user does not exist!");
            throw new NetCareInsideSdkException("The current effective user does not exist!");
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryTaskInfoByTaskId(taskDelayInfoVo.getTaskId());
        String errMsg = this.checkDelayParams(taskInfoBo, taskDelayInfoVo);
        if (Objects.nonNull(errMsg)) {
            throw new NetCareInsideSdkException(errMsg);
        }
        String verifyCode = this.verifyCodeUtil.generalVerifyCode(6);
        this.insertVerifyCodeRecord(taskDelayInfoVo.getTaskId(), userAuthenticateInfoBo, verifyCode, null);
        String pubkeyByEncrypt = PropertyUtil.getString("pubkeyByEncrypt");
        String accountAndVerifyCodeEncrypt = null;
        try {
            accountAndVerifyCodeEncrypt = Objects.nonNull(userAuthenticateInfoBo.getIsPublicOmTerminal()) && userAuthenticateInfoBo.getIsPublicOmTerminal().booleanValue() ? URLEncoder.encode(RsaUtil.encrypt(verifyCode, pubkeyByEncrypt), "UTF-8") : URLEncoder.encode(RsaUtil.encrypt(verifyCode + "@" + userAuthenticateInfoBo.getLoginAccount(), pubkeyByEncrypt), "UTF-8");
        }
        catch (UnsupportedEncodingException | GeneralSecurityException except) {
            LOGGER.error("get accountAndVerifyCodeEncrypt exception.");
            return null;
        }
        BigDecimal delayTimeDecimal = new BigDecimal(taskDelayInfoVo.getDelayTime());
        BigDecimal oneHourSecondsDecimal = new BigDecimal(3600000);
        BigDecimal multiply = delayTimeDecimal.multiply(oneHourSecondsDecimal);
        long secondsLong = multiply.longValue();
        Date delayStartTime = taskInfoBo.getTaskEndTime();
        Date delayEndTime = new Date(delayStartTime.getTime() + secondsLong);
        TaskServiceSwingService.setTaskInfoBo(new TaskInfoBo());
        taskInfoCache.setTaskId(taskDelayInfoVo.getTaskId());
        taskInfoCache.setTaskEndTime(delayEndTime);
        taskInfoCache.setDelayNum(Objects.isNull(taskInfoBo.getDelayNum()) ? 1 : taskInfoBo.getDelayNum() + 1);
        taskInfoCache.setTaskExecutor(userAuthenticateInfoBo.getLoginAccount());
        String siteInfo = StringUtils.isNotBlank((CharSequence)userAuthenticateInfoBo.getSite()) ? userAuthenticateInfoBo.getSite() : "China";
        return PropertyUtil.getScanQrUrl("taskDelayUrl", siteInfo) + "?" + String.join((CharSequence)"&", "taskId=" + taskDelayInfoVo.getTaskId(), "delayTime=" + taskDelayInfoVo.getDelayTime(), "delayStartTime=" + delayStartTime.getTime(), "delayEndTime=" + delayEndTime.getTime(), "delayReason=" + taskDelayInfoVo.getDelayReason(), "accountAndVerifyCode=" + accountAndVerifyCodeEncrypt);
    }

    private String checkDelayParams(TaskInfoBo taskInfoBo, TaskDelayInfoVo taskDelayInfoVo) {
        if (Objects.isNull(taskInfoBo)) {
            LOGGER.error("Task id is illegal!");
            return ErrorCodeEnum.TICKET_ID_NOT_EXIST.getErrorCode();
        }
        if (StringUtils.equals((CharSequence)taskInfoBo.getTaskObtainMode(), (CharSequence)"\u672c\u5730\u81ea\u5efa")) {
            LOGGER.error("Self-build task no need delay.");
            return ErrorCodeEnum.SELF_CREATE_TICKET_NOT_EXTEND.getErrorCode();
        }
        if (StringUtils.equalsAny((CharSequence)taskDelayInfoVo.getDelayTime(), (CharSequence[])new CharSequence[]{"0", "0.0"})) {
            LOGGER.error("The delay time cannot be 0.");
            return ErrorCodeEnum.TICKET_EXTEND_DURATION_INCORRECT.getErrorCode();
        }
        if (Float.parseFloat(taskDelayInfoVo.getDelayTime()) > 8.0f) {
            LOGGER.error("Delay time is exceeds 8!");
            return ErrorCodeEnum.TICKET_EXTEND_DURATION_INCORRECT.getErrorCode();
        }
        if (!taskInfoBo.getIsCurTask().booleanValue()) {
            LOGGER.error("The task is not current effective task!");
            return ErrorCodeEnum.TICKET_ID_INVALID.getErrorCode();
        }
        if (DateUtil.getUtcDate(new Date()).before(taskInfoBo.getTaskEndTime())) {
            LOGGER.error("The task has not expired and cannot be delay!");
            return ErrorCodeEnum.TICKET_ID_INVALID.getErrorCode();
        }
        if (Objects.nonNull(taskInfoBo.getDelayNum()) && taskInfoBo.getDelayNum() >= 2) {
            LOGGER.error("The task has delay twice and cannot be delay again!");
            return ErrorCodeEnum.TICKET_NOT_EXTEND_AGAIN.getErrorCode();
        }
        return null;
    }

    public Result checkTaskDelayVerifyCode(VerifyCodeVo verifyCodeVo) {
        LOGGER.info("Start checkTaskDelayVerifyCode.");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("This userAuthenticateInfo is abnormal.");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        if (Objects.isNull(taskInfoCache)) {
            LOGGER.error("Refresh the task delay QR code.");
            return Result.fail(ErrorCodeEnum.GENERATE_QR_CODE.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.GENERATE_QR_CODE.getErrorCode()));
        }
        Map<String, String> checkResultMap = this.verifyCodeUtil.checkVerifyCode(taskInfoCache, verifyCodeVo.getVerifyCode(), "\u4efb\u52a1\u9a8c\u8bc1", 1);
        String errorCode = checkResultMap.get("errorCode");
        String checkResult = checkResultMap.get("errorMsg");
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            LOGGER.error(checkResult);
            return Result.fail(errorCode, checkResult);
        }
        this.taskInfoDao.updateTask(taskInfoCache);
        LOGGER.info("Check verifyCode success, task {} delay success.", (Object)taskInfoCache.getTaskId());
        return Result.success();
    }

    public Result reportTaskDelayTime(TaskDelayInfoVo taskDelayInfoVo) {
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        if (!hasConnectedClient.get("isConnected").booleanValue()) {
            LOGGER.error("The NetCare Client cannot be connected!");
            return Result.fail(ErrorCodeEnum.NETCARECLIENT_DISCONNECT.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.NETCARECLIENT_DISCONNECT.getErrorCode()));
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryTaskInfoByTaskId(taskDelayInfoVo.getTaskId());
        String errCode = this.checkDelayParams(taskInfoBo, taskDelayInfoVo);
        if (Objects.nonNull(errCode)) {
            return Result.fail(errCode, this.internationalizeUtil.getMessage(errCode));
        }
        return this.reportDelayTimeToClient(taskDelayInfoVo, taskInfoBo);
    }

    public Result queryTaskInfo(PageRequestVo pageRequest) {
        DateUtil.userTimeZoneTimeTranslationUtc(pageRequest, "startTime", "endTime");
        if (Objects.nonNull(pageRequest.getStartTime()) && Objects.nonNull(pageRequest.getEndTime()) && pageRequest.getStartTime().after(pageRequest.getEndTime())) {
            LOGGER.info("The start time cannot be later than the end time.");
            return Result.fail(ErrorCodeEnum.STARTTIME_NOT_LATER_ENDTIME.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.STARTTIME_NOT_LATER_ENDTIME.getErrorCode()));
        }
        LOGGER.info("Start queryTaskInfo.");
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)authenticateInfoBo)) {
            LOGGER.info("The subscriber data does not exist.");
            return Result.fail(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.QUERY_USER_INIT_INFO_FAILED.getErrorCode()));
        }
        Integer pageNum = Integer.parseInt(pageRequest.getPageNum());
        Integer pageSize = Integer.parseInt(pageRequest.getPageSize());
        TaskInfoQueryVo taskInfoQueryVo = new TaskInfoQueryVo();
        List<TaskInfoBo> taskInfoBos = this.queryAllTask(authenticateInfoBo, taskInfoQueryVo, pageRequest);
        PageBean<TaskInfoBo> taskInfoBoPageBean = new PageBean<TaskInfoBo>(pageNum, pageSize, taskInfoBos);
        ArrayList<TaskInfoQuery> taskInfoQueries = new ArrayList<TaskInfoQuery>();
        if (ObjectUtils.isNotEmpty(taskInfoBos) && taskInfoBos.size() > 0) {
            for (TaskInfoBo taskInfoBo : taskInfoBoPageBean.getList()) {
                TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
                BeanUtils.copyProperties((Object)taskInfoBo, (Object)taskInfoQuery);
                if (Objects.equals(taskInfoBo.getTaskStatus(), TaskStatusNameEnum.ONGOING.getCode()) && StringUtils.equals((CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), (CharSequence)taskInfoBo.getTaskType())) {
                    TaskSubtypeBo taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskInfoBo.getTaskId());
                    taskInfoQuery.setCurTaskIsCrt(Objects.nonNull(taskSubtypeBo));
                }
                taskInfoQueries.add(taskInfoQuery);
            }
        }
        ArrayList<InternationalizeBo> internationalizeBos = this.dataInternationalizationUtil.getRegOfficeProductInternationalizeBos();
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("taskStatus", "taskStatusName", "taskStatus"));
        internationalizeBos.add(this.dataInternationalizationUtil.getDictCodeInternationalizeBo("taskType", "taskTypeName", "taskType"));
        this.dataInternationalizationUtil.setInternationalizeData(LanguageManager.getInstance().getCurLanguage().toLanguageTag(), taskInfoQueries, (List<InternationalizeBo>)internationalizeBos);
        DateUtil.dbTimeTranslationWebUtc(taskInfoQueries, new String[]{"taskStartTime", "taskEndTime", "operationPreparationTime"});
        taskInfoQueryVo.setTaskInfoQueries(taskInfoQueries);
        LOGGER.info("End queryTaskInfo.");
        return Result.success(taskInfoQueryVo);
    }

    private Result reportDelayTimeToClient(TaskDelayInfoVo taskDelayInfoVo, TaskInfoBo taskInfoBo) {
        JSONObject returnResult;
        LOGGER.info("Start report task {} delayTime to NetCare Client.", (Object)taskDelayInfoVo.getTaskId());
        RequestData data = new RequestData();
        data.setUrl(PropertyUtil.getString("uploadSdkTaskDelay"));
        data.setType("POST");
        JSONObject paramJson = new JSONObject();
        paramJson.put("taskId", (Object)taskDelayInfoVo.getTaskId());
        paramJson.put("delayTime", (Object)taskDelayInfoVo.getDelayTime());
        paramJson.put("delayReason", (Object)taskDelayInfoVo.getDelayReason());
        JSONObject dataJson = new JSONObject();
        dataJson.put("data", (Object)paramJson);
        data.setParam(dataJson);
        try {
            returnResult = HttpUtil.sendRest(data);
        }
        catch (Exception except) {
            LOGGER.error("Send http request exception!");
            return Result.fail(ErrorCodeEnum.HTTP_SEND_EXCEPTION.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.HTTP_SEND_EXCEPTION.getErrorCode()));
        }
        if (Objects.nonNull(returnResult) && returnResult.getInteger("status") == 0) {
            BigDecimal delayTimeDecimal = new BigDecimal(taskDelayInfoVo.getDelayTime());
            BigDecimal oneHourSecondsDecimal = new BigDecimal(3600000);
            BigDecimal multiply = delayTimeDecimal.multiply(oneHourSecondsDecimal);
            long secondsLong = multiply.longValue();
            Date delayStartTime = taskInfoBo.getTaskEndTime();
            Date delayEndTime = new Date(delayStartTime.getTime() + secondsLong);
            TaskInfoBo infoBo = new TaskInfoBo();
            infoBo.setTaskId(taskDelayInfoVo.getTaskId());
            infoBo.setTaskEndTime(delayEndTime);
            infoBo.setDelayNum(Objects.isNull(taskInfoBo.getDelayNum()) ? 1 : taskInfoBo.getDelayNum() + 1);
            infoBo.setIsCurTask(true);
            this.taskInfoDao.updateTask(infoBo);
            LOGGER.info("Task {} delay success.", (Object)taskDelayInfoVo.getTaskId());
            return Result.success("Delay success.");
        }
        if (Objects.nonNull(returnResult) && returnResult.containsKey((Object)"returnValue")) {
            String returnValue = returnResult.getString("returnValue");
            LOGGER.error("Delay failed, NetCare Client return value is {}", (Object)returnValue);
        }
        return Result.fail(ErrorCodeEnum.TICKET_EXTEND_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TICKET_EXTEND_FAILED.getErrorCode()));
    }

    private String checkSignFile() {
        boolean signResult;
        String filepath = TEMP_PATH + File.separator + "offlineTask.json";
        String signFilePath = TEMP_PATH + File.separator + "offlineTask.json.sign";
        String content = null;
        byte[] signByte = null;
        try {
            content = FileUtils.readFileToString((File)new File(filepath), (Charset)StandardCharsets.UTF_8);
            signByte = FileUtils.readFileToByteArray((File)new File(signFilePath));
        }
        catch (IOException except) {
            LOGGER.error("Read Sign file failed.");
            return ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode();
        }
        String publicKey = PropertyUtil.getString("publicKeyToSign");
        try {
            signResult = CmsSignUtils.verifySignature(RsaUtil.getPublicKey(publicKey), content, signByte);
        }
        catch (GeneralSecurityException except) {
            LOGGER.error("Verify Sign file exception.");
            return ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode();
        }
        if (!signResult) {
            LOGGER.error("Verify Sign file failed.");
            return ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode();
        }
        LOGGER.info("Verify Sign the file succeed.");
        return "";
    }

    private void insertTaskInfo(UserAuthenticateInfoBo userAuthenticateInfoBo, String verifyCodeType) {
        this.setTaskInfoCache(userAuthenticateInfoBo);
        this.setInterceptPolicy(userAuthenticateInfoBo, verifyCodeType);
        this.taskInfoDao.insertTaskInfo(taskInfoCache);
        LOGGER.info("Insert {} taskInfo success.", (Object)taskInfoCache.getTaskType());
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (Objects.nonNull(taskInfoBo)) {
            return;
        }
        if ((Objects.nonNull(taskInfoCache.getTaskStartTime()) || Objects.nonNull(taskInfoCache.getOperationPreparationTime())) && Objects.nonNull(taskInfoCache.getTaskEndTime())) {
            if (StringUtils.equals((CharSequence)taskInfoCache.getTaskType(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn())) {
                if (DateUtil.getUtcDate(new Date()).after(taskInfoCache.getOperationPreparationTime()) && DateUtil.getUtcDate(new Date()).before(taskInfoCache.getTaskEndTime())) {
                    this.taskInfoDao.setCurTask(taskInfoCache.getTaskId());
                    this.taskInfoDao.setOtherTask(taskInfoCache.getTaskId(), userAuthenticateInfoBo.getLoginAccount());
                    LOGGER.info("Set networkChange task {} is_cur_task is true.", (Object)taskInfoCache.getTaskId());
                }
            } else if (DateUtil.getUtcDate(new Date()).after(taskInfoCache.getTaskStartTime()) && DateUtil.getUtcDate(new Date()).before(taskInfoCache.getTaskEndTime())) {
                this.taskInfoDao.setCurTask(taskInfoCache.getTaskId());
                this.taskInfoDao.setOtherTask(taskInfoCache.getTaskId(), userAuthenticateInfoBo.getLoginAccount());
                LOGGER.info("Set task {} is_cur_task is true.", (Object)taskInfoCache.getTaskId());
            }
        }
    }

    private void setTaskInfoCache(UserAuthenticateInfoBo userAuthenticateInfoBo) {
        if (StringUtils.isEmpty((CharSequence)taskInfoCache.getTaskName())) {
            taskInfoCache.setTaskName(LocalTaskTypeEnum.getTaskTypeEnByCode(taskInfoCache.getTaskType()));
        }
        taskInfoCache.setTaskObtainMode("\u672c\u5730\u81ea\u5efa");
        taskInfoCache.setTaskExecutorName(userAuthenticateInfoBo.getLoginAccountName());
        taskInfoCache.setTaskType(TaskTypeEnum.getTaskTypeEnByCode(taskInfoCache.getTaskType()));
        taskInfoCache.setRegionCode(userAuthenticateInfoBo.getRegionCode());
        taskInfoCache.setRegion(userAuthenticateInfoBo.getRegion());
        taskInfoCache.setRegionEn(userAuthenticateInfoBo.getRegionEn());
        taskInfoCache.setRepOfficeCode(userAuthenticateInfoBo.getRepOfficeCode());
        taskInfoCache.setRepOffice(userAuthenticateInfoBo.getRepOffice());
        taskInfoCache.setRepOfficeEn(userAuthenticateInfoBo.getRepOfficeEn());
        taskInfoCache.setProductLineCode(userAuthenticateInfoBo.getProductLineCode());
        taskInfoCache.setProductLine(userAuthenticateInfoBo.getProductLine());
        taskInfoCache.setProductLineEn(userAuthenticateInfoBo.getProductLineEn());
        taskInfoCache.setCreateTime(DateUtil.getUtcDate(new Date()));
        taskInfoCache.setOperator(userAuthenticateInfoBo.getLoginAccount());
        taskInfoCache.setTaskStatus(TaskStatusNameEnum.TO_DO.getCode());
        taskInfoCache.setIsCurTask(false);
    }

    private void setInterceptPolicy(UserAuthenticateInfoBo userAuthenticateInfoBo, String verifyCodeType) {
        String taskType = taskInfoCache.getTaskType();
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.NON_CHANGE.getTaskTypeEn())) {
            taskInfoCache.setInterceptPolicy(userAuthenticateInfoBo.getNotStructuralComponentPolicy());
        } else if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.QUERY.getTaskTypeEn())) {
            if (verifyCodeType.equals("0")) {
                taskInfoCache.setInterceptPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
            } else {
                taskInfoCache.setInterceptPolicy(InterceptPolicyEnum.BLOCKLIST.getValue());
            }
        } else if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeEn())) {
            taskInfoCache.setInterceptPolicy(InsidePolicyEnum.getPolicyByCode(verifyCodeType).getInterceptPolicyEnum().getValue());
            RiskLevelEnum riskLevelEnum = InsidePolicyEnum.getPolicyByCode(verifyCodeType).getRiskLevelEnum();
            taskInfoCache.setRiskLevel(Objects.isNull((Object)riskLevelEnum) ? null : riskLevelEnum.getRiskCode());
        } else {
            taskInfoCache.setInterceptPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        }
    }

    private String insertOfflineTaskInfo(JSONObject jsonObject, JSONObject warnMsgJsonObj) {
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        JSONObject taskInfo = jsonObject.getJSONObject("taskInfo");
        if (Objects.isNull(taskInfo)) {
            LOGGER.error("Task Info is empty!");
            return ErrorCodeEnum.TICKET_INFO_IS_EMPTY.getErrorCode();
        }
        TaskInfoBo taskInfoBo = (TaskInfoBo)JSONObject.toJavaObject((JSON)taskInfo, TaskInfoBo.class);
        String resultMessage = this.checkImportParam(taskInfoBo, userAuthenticateInfoBo, warnMsgJsonObj);
        if (resultMessage != null) {
            return resultMessage;
        }
        taskInfoBo.setOperationPreparationTime(Objects.isNull(taskInfoBo.getOperationPreparationTime()) ? taskInfoBo.getTaskStartTime() : taskInfoBo.getOperationPreparationTime());
        if (DateUtil.getUtcDate(new Date()).after(taskInfoBo.getTaskEndTime()) || taskInfoBo.getTaskStartTime().after(taskInfoBo.getTaskEndTime())) {
            LOGGER.error("The start time or end time of the task is invalid.");
            return ErrorCodeEnum.TICKET_TIME_IS_INCORRECT.getErrorCode();
        }
        TaskInfoBo taskInfoInDb = this.taskInfoDao.queryTaskInfoByTaskId(taskInfoBo.getTaskId());
        if (Objects.nonNull(taskInfoInDb) && StringUtils.equals((CharSequence)taskInfoInDb.getTaskExecutor(), (CharSequence)taskInfoBo.getTaskExecutor())) {
            LOGGER.error("The task already exists. Do not import it again.");
            return ErrorCodeEnum.TICKET_NOT_IMPORT_AGAIN.getErrorCode();
        }
        this.commonDataDeal.insertTaskAdditionalInfo(userAuthenticateInfoBo, jsonObject, taskInfoBo);
        this.insertTask(jsonObject, userAuthenticateInfoBo, taskInfoBo, taskInfoBo.getOperationPreparationTime(), taskInfoBo.getTaskEndTime());
        return "";
    }

    private void insertTask(JSONObject jsonObject, UserAuthenticateInfoBo userAuthenticateInfoBo, TaskInfoBo taskInfoBo, Date operationPreparationTime, Date taskEndLocalTime) {
        BeanUtils.copyProperties((Object)userAuthenticateInfoBo, (Object)taskInfoBo);
        taskInfoBo.setTaskObtainMode("\u79bb\u7ebf\u5bfc\u5165");
        taskInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        taskInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
        TaskInfoBo curActiveTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        taskInfoBo.setTaskStatus(TaskStatusNameEnum.TO_DO.getCode());
        if (jsonObject.containsKey((Object)"taskProcess") && Objects.nonNull(jsonObject.getJSONObject("taskProcess")) && jsonObject.getJSONObject("taskProcess").containsKey((Object)"rfcStages") && TaskSubtypeEnum.EASY_CRT_TYPE.getCode().equals(taskInfoBo.getTaskSubtype())) {
            taskInfoBo.setInterceptPolicy(jsonObject.getJSONObject("taskInfo").getString(ControlPolicyEnum.STRUCTURAL_COMPONENT_POLICY.getPolicyType()));
            TaskSubtypeBo subtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskInfoBo.getTaskId());
            if (ObjectUtils.isEmpty((Object)subtypeBo)) {
                this.commonDataDeal.updateTaskSubtype(jsonObject, taskInfoBo);
            }
            if (ObjectUtils.isEmpty((Object)curActiveTask)) {
                taskInfoBo.setTaskStatus(TaskStatusNameEnum.ONGOING.getCode());
                taskInfoBo.setIsCurTask(true);
                this.taskInfoDao.insertTaskInfo(taskInfoBo);
                LOGGER.info("Offline CRT-Task info insert success.");
                this.taskInfoDao.setOtherTask(taskInfoBo.getTaskId(), userAuthenticateInfoBo.getLoginAccount());
                return;
            }
        } else {
            taskInfoBo.setInterceptPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        }
        if (Objects.nonNull(curActiveTask)) {
            taskInfoBo.setIsCurTask(false);
        } else if (DateUtil.getUtcDate(new Date()).after(operationPreparationTime) && DateUtil.getUtcDate(new Date()).before(taskEndLocalTime)) {
            taskInfoBo.setTaskStatus(TaskStatusNameEnum.ONGOING.getCode());
            taskInfoBo.setIsCurTask(true);
            this.taskInfoDao.setOtherTask(taskInfoBo.getTaskId(), userAuthenticateInfoBo.getLoginAccount());
        }
        this.taskInfoDao.insertTaskInfo(taskInfoBo);
        LOGGER.info("OfflineTask info insert success.");
    }

    private String checkImportParam(TaskInfoBo taskInfoBo, UserAuthenticateInfoBo userAuthenticateInfoBo, JSONObject warnMsgJsonObj) {
        if (Objects.isNull(taskInfoBo) || StringUtils.isBlank((CharSequence)taskInfoBo.getTaskId())) {
            LOGGER.error("Task Info is empty!");
            return ErrorCodeEnum.TICKET_INFO_IS_EMPTY.getErrorCode();
        }
        if (Objects.isNull(userAuthenticateInfoBo.getIsPublicOmTerminal()) || !userAuthenticateInfoBo.getIsPublicOmTerminal().booleanValue()) {
            ToolConfig toolConfig = JsonParseUtils.getToolConfig();
            String tipMsg = this.internationalizeUtil.getMessage("10044", Collections.singletonList(toolConfig.getOrderDetailPathCn()));
            if (LanguageManager.isEnglish()) {
                tipMsg = this.internationalizeUtil.getMessage("10044", Collections.singletonList(toolConfig.getOrderDetailPathEn()));
            }
            if (!StringUtils.equals((CharSequence)userAuthenticateInfoBo.getLoginAccount(), (CharSequence)taskInfoBo.getTaskExecutor())) {
                warnMsgJsonObj.put("resultMessage", (Object)tipMsg);
                return "10044";
            }
        } else {
            taskInfoBo.setTaskExecutor(userAuthenticateInfoBo.getLoginAccount());
            taskInfoBo.setTaskExecutorName(userAuthenticateInfoBo.getLoginAccountName());
        }
        if (Objects.isNull(taskInfoBo.getTaskStartTime()) || Objects.isNull(taskInfoBo.getTaskEndTime())) {
            LOGGER.error("Task start or end time is null.");
            return ErrorCodeEnum.TICKET_TIME_IS_INCORRECT.getErrorCode();
        }
        return null;
    }

    public Result setTaskFinish(TaskDotFinishBo taskFinishBo) {
        List dotInfoBos;
        LOGGER.info("The setTaskFinish start.");
        TaskInfoBo taskBo = this.taskInfoDao.queryTaskInfoByTaskId(taskFinishBo.getTaskId());
        if (ObjectUtils.isNotEmpty((Object)taskBo) && !TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn().equals(taskBo.getTaskType())) {
            LOGGER.info("Non-dotting tasks cannot be completed and are automatically completed upon expiration.");
            return Result.fail(ErrorCodeEnum.NOT_SUPPORT_CRT.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.NOT_SUPPORT_CRT.getErrorCode()));
        }
        TaskInfoBo infoBo = this.taskInfoDao.queryTaskInfoByTaskId(taskFinishBo.getTaskId());
        if (ObjectUtils.isEmpty((Object)infoBo)) {
            LOGGER.info("The taskInfoBo data does not exist.");
            return Result.fail(ErrorCodeEnum.TICKET_ID_NOT_EXIST.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TICKET_ID_NOT_EXIST.getErrorCode()));
        }
        LOGGER.info("The taskId is {}.", (Object)infoBo.getTaskId());
        if (Objects.equals(TaskStatusNameEnum.COMPLETE.getCode(), infoBo.getTaskStatus())) {
            LOGGER.info("The current task has been completed.");
            return Result.fail(ErrorCodeEnum.TICKET_COMPLETED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TICKET_COMPLETED.getErrorCode()));
        }
        TaskSubtypeBo taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskFinishBo.getTaskId());
        TaskDotFinishDto taskDotFinishDto = new TaskDotFinishDto();
        TaskDotInfoBo taskDotInfoBo = new TaskDotInfoBo();
        if (ObjectUtils.isNotEmpty((Object)taskSubtypeBo)) {
            dotInfoBos = JSONArray.parseArray((String)taskSubtypeBo.getDotInfo(), DotInfoBo.class);
            taskDotFinishDto.setDotInfo(dotInfoBos);
            taskDotFinishDto.setTaskSubtype(taskSubtypeBo.getTaskSubtype());
            taskDotInfoBo.setTaskSubtype(taskSubtypeBo.getTaskSubtype());
        }
        taskDotInfoBo.setTaskId(taskFinishBo.getTaskId());
        if (ObjectUtils.isNotEmpty((Object)taskSubtypeBo) && !this.checkDotInfo(dotInfoBos = JSONArray.parseArray((String)taskSubtypeBo.getDotInfo(), DotInfoBo.class), taskDotFinishDto)) {
            LOGGER.info("The solution does not contain the data to the time point.");
            return Result.fail(ErrorCodeEnum.TICKET_NOT_CONTAIL_POINT.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TICKET_NOT_CONTAIL_POINT.getErrorCode()));
        }
        if (this.dotInfoDao.queryBackDotInfo(taskDotInfoBo) > 0) {
            return this.backFinishPoint(taskFinishBo, taskDotFinishDto, taskSubtypeBo);
        }
        return this.normalTaskFinish(taskFinishBo, taskDotFinishDto, taskSubtypeBo);
    }

    private Result backFinishPoint(TaskDotFinishBo taskFinishBo, TaskDotFinishDto taskDotFinishDto, TaskSubtypeBo taskSubtypeBo) {
        RequestData requestData = new RequestData();
        requestData.setUrl(PropertyUtil.getString("setTaskFinish"));
        requestData.setType("POST");
        JSONObject resultObject = new JSONObject();
        if (this.taskDotFinishUpload(taskFinishBo, requestData, taskDotFinishDto, resultObject, taskSubtypeBo) && resultObject.getString("resultCode").equals("1")) {
            LOGGER.info("The backFinishPoint end.");
            return Result.fail(1, resultObject.getString("resultMessage"));
        }
        LOGGER.info("The backFinishPoint end.");
        return Result.success("backPointTaskFinish success.");
    }

    private void insertVerifyCodeRecord(String taskId, UserAuthenticateInfoBo userAuthenticateInfoBo, String verifyCode, Integer verifyCodeType) {
        VerifyCodeRecordBo verifyCodeRecordBo = new VerifyCodeRecordBo();
        verifyCodeRecordBo.setVerifyType("\u4efb\u52a1\u9a8c\u8bc1");
        verifyCodeRecordBo.setTaskId(taskId);
        verifyCodeRecordBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        verifyCodeRecordBo.setAccount(userAuthenticateInfoBo.getLoginAccount());
        verifyCodeRecordBo.setVerifyCode(verifyCode);
        verifyCodeRecordBo.setVerifyStatus(2);
        verifyCodeRecordBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
        verifyCodeRecordBo.setActivePeriod("30");
        if (Objects.nonNull(verifyCodeType)) {
            verifyCodeRecordBo.setVerifyCodeType(String.valueOf(verifyCodeType));
        }
        this.verifyCodeRecordDao.insertRecord(verifyCodeRecordBo);
        LOGGER.info("VerifyCodeRecordBo insert success.");
    }

    private void checkTaskInfoVo(TaskInfoVo taskInfoVo) {
        if (StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()) && Objects.isNull(taskInfoVo.getOperationPreparationTime())) {
            LOGGER.error("The operationPreparationTime cannot be empty.");
            throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("PREPARE_TIME_NULL_ERROR"));
        }
        if (!StringUtils.equalsAny((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence[])new CharSequence[]{TaskTypeEnum.EMERGENCY.getTaskTypeCode()})) {
            if (Objects.isNull(taskInfoVo.getTaskStartTime())) {
                LOGGER.error("The taskStartTime cannot be empty.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("START_TIME_NULL_ERROR"));
            }
            if (Objects.isNull(taskInfoVo.getTaskEndTime())) {
                LOGGER.error("The taskEndTime cannot be empty.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("END_TIME_NULL_ERROR"));
            }
        }
        String operationDuration = taskInfoVo.getOperationDuration();
        String preparationDuration = taskInfoVo.getPreparationDuration();
        this.checkTimeFomat(taskInfoVo, operationDuration, preparationDuration);
        this.checkOperationAndPreparationDuration(taskInfoVo, operationDuration, preparationDuration);
    }

    private void checkOperationAndPreparationDuration(TaskInfoVo taskInfoVo, String operationDuration, String preparationDuration) {
        String taskTypeCode = taskInfoVo.getTaskTypeCode();
        LOGGER.info("checkTaskInfoVo -> operationDuration {}, preparationDuration {}, taskTypeCode {}", new Object[]{operationDuration, preparationDuration, taskTypeCode});
        Matcher operationDurationMatcher = StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.EMERGENCY.getTaskTypeCode()) ? Pattern.compile("^[1-8]$").matcher(operationDuration) : Pattern.compile("^\\d{2,3}:\\d{2}$").matcher(operationDuration);
        if (!operationDurationMatcher.matches()) {
            throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("OPERATION_DURATION_TIP"));
        }
        if (StringUtils.equalsAny((CharSequence)taskTypeCode, (CharSequence[])new CharSequence[]{TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeCode(), TaskTypeEnum.QUERY.getTaskTypeCode()})) {
            if (Float.parseFloat(DateUtil.converseDuration(operationDuration)) > 999.0f) {
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("MAX_999_OPERATION_DURATION"));
            }
        } else if (StringUtils.equals((CharSequence)taskTypeCode, (CharSequence)TaskTypeEnum.PROJECT.getTaskTypeCode())) {
            if (Float.parseFloat(DateUtil.converseDuration(operationDuration)) > 16.0f) {
                LOGGER.error("The maximum operation duration in the engineering commissioning scenario is 16.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("MAX_16_OPERATION_DURATION"));
            }
        } else if (StringUtils.equals((CharSequence)taskTypeCode, (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode())) {
            float operationDurationtTime = Float.parseFloat(DateUtil.converseDuration(operationDuration));
            float preparationDurationTime = Float.parseFloat(DateUtil.converseDuration(preparationDuration));
            if (operationDurationtTime > 24.0f) {
                LOGGER.error("The maximum operation duration of the change scenario is 24 hours.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("MAX_24_OPERATION_DURATION"));
            }
            if (preparationDurationTime > 3.0f) {
                LOGGER.error("The maximum preparation time for the change operation scenario is 3 hours.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("MAX_3_HOURS_TIP"));
            }
            if (preparationDurationTime + operationDurationtTime > 24.0f) {
                LOGGER.error("The preparation duration and operation duration of the operation scenario are changed to 24 hours at most.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("SUM_TIME_TIP"));
            }
        } else if (StringUtils.equals((CharSequence)taskTypeCode, (CharSequence)TaskTypeEnum.NON_CHANGE.getTaskTypeCode())) {
            if (Float.parseFloat(operationDuration) > 48.0f) {
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("MAX_48_OPERATION_DURATION"));
            }
        } else if (!operationDuration.matches("^[1-8]$")) {
            throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("MAX_8_OPERATION_DURATION"));
        }
    }

    private void checkTimeFomat(TaskInfoVo taskInfoVo, String operationDuration, String preparationDuration) {
        if (StringUtils.equalsAny((CharSequence)operationDuration, (CharSequence[])new CharSequence[]{"0", "0.0", "00:00"})) {
            LOGGER.error("The operation duration cannot be 0.");
            throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("OPERATION_DUR_GREATER"));
        }
        if (StringUtils.equalsAny((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence[])new CharSequence[]{TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()}) && taskInfoVo.getOperationPreparationTime().before(DateUtil.formatToSpecificDate(DateUtil.getUtcDate(new Date())))) {
            LOGGER.error("The operationPreparationTime cannot be earlier than the current system time.");
            throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("PRE_TIME_TIP"));
        }
        if (!StringUtils.equalsAny((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence[])new CharSequence[]{TaskTypeEnum.EMERGENCY.getTaskTypeCode()})) {
            if (taskInfoVo.getTaskStartTime().before(DateUtil.formatToSpecificDate(DateUtil.getUtcDate(new Date())))) {
                LOGGER.error("The start time cannot be earlier than the current system time.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("START_TIME_TIP"));
            }
            if (taskInfoVo.getTaskEndTime().before(DateUtil.formatToSpecificDate(DateUtil.getUtcDate(new Date())))) {
                LOGGER.error("The end time cannot be earlier than the current system time.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("END_BRFORE_CURRENT_TIP"));
            }
            if (taskInfoVo.getTaskEndTime().before(taskInfoVo.getTaskStartTime())) {
                LOGGER.error("The end time cannot be earlier than the current system time.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("END_TIME_TIP"));
            }
            this.checkDurationValid(taskInfoVo, operationDuration, preparationDuration);
        }
    }

    private void checkDurationValid(TaskInfoVo taskInfoVo, String operationDuration, String preparationDuration) {
        if (StringUtils.equalsAny((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence[])new CharSequence[]{TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()})) {
            if (StringUtils.isBlank((CharSequence)preparationDuration)) {
                LOGGER.error("The preparation duration cannot be empty.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("PREPARATION_DURATION_TIP"));
            }
            if (!DateUtil.calculateTimeDiff(taskInfoVo.getOperationPreparationTime(), taskInfoVo.getTaskStartTime(), preparationDuration)) {
                LOGGER.error("The sum of preparation time and preparation duration is not equal to the start time.");
                throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("PREPARATION_DURATION_ERROR"));
            }
        }
        if (StringUtils.isBlank((CharSequence)operationDuration)) {
            LOGGER.error("The operation duration cannot be empty.");
            throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("OPERATION_DURATION_NULL_ERROR"));
        }
        if (!DateUtil.calculateTimeDiff(taskInfoVo.getTaskStartTime(), taskInfoVo.getTaskEndTime(), operationDuration)) {
            LOGGER.error("The sum of start time and operation duration is not equal to the completion time.");
            throw new NetCareInsideSdkException(this.internationalizeUtil.getResource("OPERATION_DURATION_ERROR"));
        }
    }

    private void calculateTaskTime(TaskInfoVo taskInfoVo) {
        if (!StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.EMERGENCY.getTaskTypeCode())) {
            return;
        }
        LOGGER.info("Emergency task Schedule Time Calculation start.");
        BigDecimal operationDurationDecimal = new BigDecimal(taskInfoVo.getOperationDuration());
        BigDecimal oneHourMillsDecimal = new BigDecimal(3600000);
        BigDecimal multiply = operationDurationDecimal.multiply(oneHourMillsDecimal);
        long longOperationDuration = multiply.longValue();
        Date taskStartTime = DateUtil.getUtcDate(new Date());
        Date taskEndTime = new Date(taskStartTime.getTime() + longOperationDuration);
        taskInfoVo.setTaskStartTime(taskStartTime);
        taskInfoVo.setTaskEndTime(taskEndTime);
        LOGGER.info("Emergency task Schedule Time Calculation end.");
    }

    private String generalVerifyCodeStr(TaskInfoVo taskInfoVo, String taskId, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        StringBuilder verifyCodeStr = new StringBuilder();
        if (StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.QUERY.getTaskTypeCode())) {
            String codeOne = this.verifyCodeUtil.generalVerifyCode(6);
            this.insertVerifyCodeRecord(taskId, userAuthenticateInfoBo, codeOne, 0);
            String codeTwo = this.verifyCodeUtil.generalVerifyCode(6);
            this.insertVerifyCodeRecord(taskId, userAuthenticateInfoBo, codeTwo, 1);
            verifyCodeStr.append(codeOne).append("-0#").append(codeTwo).append("-1");
        } else if (StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeCode())) {
            for (int i = 1; i <= 7; ++i) {
                String verifyCode = this.verifyCodeUtil.generalVerifyCode(6);
                this.insertVerifyCodeRecord(taskId, userAuthenticateInfoBo, verifyCode, i);
                if (i == 7) {
                    verifyCodeStr.append(verifyCode);
                    continue;
                }
                verifyCodeStr.append(verifyCode).append("#");
            }
        } else {
            String verifyCode = this.verifyCodeUtil.generalVerifyCode(6);
            verifyCodeStr.append(verifyCode);
            this.insertVerifyCodeRecord(taskId, userAuthenticateInfoBo, verifyCode, null);
        }
        return verifyCodeStr.toString();
    }

    private Result normalTaskFinish(TaskDotFinishBo taskFinishBo, TaskDotFinishDto taskDotFinishDto, TaskSubtypeBo taskSubtypeBo) {
        LOGGER.info("The normalTaskFinish start. The input params is {}", (Object)JSONObject.toJSONString((Object)taskFinishBo));
        RequestData data = new RequestData();
        data.setUrl(PropertyUtil.getString("setTaskFinish"));
        data.setType("POST");
        BeanUtils.copyProperties((Object)taskFinishBo, (Object)taskDotFinishDto);
        JSONObject resultObject = new JSONObject();
        if (this.taskDotFinishUpload(taskFinishBo, data, taskDotFinishDto, resultObject, taskSubtypeBo)) {
            LOGGER.info("The normalTaskFinish end.");
            if (resultObject.getString("resultCode").equals("1")) {
                LOGGER.info("The normalTaskFinish end.");
                return Result.fail(1, resultObject.getString("resultMessage"));
            }
        }
        LOGGER.info("The normalTaskFinish end.");
        return Result.success("normalTaskFinish success.");
    }

    private boolean taskDotFinishUpload(TaskDotFinishBo taskFinishBo, RequestData data, TaskDotFinishDto taskDotFinishDto, JSONObject resultObject, TaskSubtypeBo taskSubtypeBo) {
        JSONObject uploadObject = new JSONObject();
        BeanUtils.copyProperties((Object)taskFinishBo, (Object)taskDotFinishDto);
        uploadObject.put("data", (Object)taskDotFinishDto);
        LOGGER.info("The taskDotFinishUpload jsonObject message {}.", (Object)JSONObject.toJSONString((Object)taskDotFinishDto));
        data.setParam(uploadObject);
        data.setRequestConfig(RequestConfig.custom().build());
        JSONObject sendRestMessage = new JSONObject();
        try {
            Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
            boolean isConnected = hasConnectedClient.get("isConnected");
            if (!isConnected) {
                return this.finishTask(taskFinishBo, resultObject, taskSubtypeBo);
            }
            sendRestMessage = HttpUtil.sendRest(data);
        }
        catch (Exception exception) {
            LOGGER.error("The setLogsPath error.");
        }
        LOGGER.info("The taskDotFinishUpload sendRestMessage message {}.", (Object)sendRestMessage.toJSONString());
        if (sendRestMessage.containsKey((Object)"status") && String.valueOf(sendRestMessage.get((Object)"status")).equals("0")) {
            return this.finishTask(taskFinishBo, resultObject, taskSubtypeBo);
        }
        resultObject.put("resultCode", (Object)"1");
        if (sendRestMessage.containsKey((Object)"status") && String.valueOf(sendRestMessage.get((Object)"status")).equals("1")) {
            resultObject.put("resultMessage", (Object)this.internationalizeUtil.getMessage(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode()));
            return true;
        }
        return false;
    }

    private boolean finishTask(TaskDotFinishBo taskFinishBo, JSONObject resultObject, TaskSubtypeBo taskSubtypeBo) {
        TaskInfoBo infoBo = new TaskInfoBo();
        infoBo.setTaskId(taskFinishBo.getTaskId());
        infoBo.setIsCurTask(false);
        infoBo.setTaskStatus(TaskStatusNameEnum.COMPLETE.getCode());
        this.taskInfoDao.updateTask(infoBo);
        TaskDotInfoBo taskDotInfoBo = new TaskDotInfoBo();
        taskDotInfoBo.setDotStageName("\u5b8c\u6210");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isNotEmpty((Object)userAuthenticateInfoBo)) {
            taskDotInfoBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
        }
        taskDotInfoBo.setDotStageTime(DateUtil.getUtcDate(new Date()));
        taskDotInfoBo.setTaskId(taskFinishBo.getTaskId());
        this.putDotInfo(taskDotInfoBo, taskSubtypeBo);
        this.dotInfoDao.insertDotInfo(taskDotInfoBo);
        resultObject.put("resultCode", (Object)"0");
        resultObject.put("resultMessage", (Object)"Request is successful.");
        return true;
    }

    private void putDotInfo(TaskDotInfoBo taskDotInfoBo, TaskSubtypeBo taskSubtypeBo) {
        if (ObjectUtils.isNotEmpty((Object)taskSubtypeBo)) {
            List dotInfoBos = JSONArray.parseArray((String)taskSubtypeBo.getDotInfo(), DotInfoBo.class);
            for (DotInfoBo dotStepBo : dotInfoBos) {
                if ("completed".equals(dotStepBo.getDotName()) || "Rollback Completed".equals(dotStepBo.getDotName()) || "\u5012\u56de\u5b8c\u6210".equals(dotStepBo.getDotName())) {
                    taskDotInfoBo.setDotStageName(dotStepBo.getDotName());
                    taskDotInfoBo.setDotStageId(dotStepBo.getDotNum());
                    break;
                }
                if (!"\u5b8c\u6210".equals(dotStepBo.getDotName()) && !"Complete".equals(dotStepBo.getDotName()) && !"complete".equals(dotStepBo.getDotName())) continue;
                taskDotInfoBo.setDotStageName(dotStepBo.getDotName());
                taskDotInfoBo.setDotStageId(dotStepBo.getDotNum());
                break;
            }
            taskDotInfoBo.setTaskSubtype(taskSubtypeBo.getTaskSubtype());
        }
    }

    private boolean checkDotInfo(List<DotInfoBo> stagesBos, TaskDotFinishDto easyCrtTaskDto) {
        for (DotInfoBo dotStage : stagesBos) {
            if ("completed".equals(dotStage.getDotName()) || "Rollback Completed".equals(dotStage.getDotName()) || "\u5012\u56de\u5b8c\u6210".equals(dotStage.getDotName())) {
                easyCrtTaskDto.setDotStageName(dotStage.getDotName());
                easyCrtTaskDto.setDotStageId(dotStage.getDotNum());
                return true;
            }
            if (!"\u5b8c\u6210".equals(dotStage.getDotName()) && !"Complete".equals(dotStage.getDotName()) && !"complete".equals(dotStage.getDotName())) continue;
            easyCrtTaskDto.setDotStageName(dotStage.getDotName());
            easyCrtTaskDto.setDotStageId(dotStage.getDotNum());
            return true;
        }
        return false;
    }

    private static void setTaskInfoBo(TaskInfoBo taskInfoCache) {
        TaskServiceSwingService.taskInfoCache = taskInfoCache;
    }

    private List<TaskInfoBo> queryAllTask(UserAuthenticateInfoBo authenticateInfoBo, TaskInfoQueryVo taskInfoQueryVo, PageRequestVo pageRequest) {
        List<TaskInfoBo> completionStatusTaskList;
        List<TaskInfoBo> todoStatusTaskList;
        ArrayList<TaskInfoBo> allTaskList = new ArrayList<TaskInfoBo>();
        TaskInfoBo curTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), authenticateInfoBo.getLoginAccount());
        if (Objects.nonNull(curTask) && !StringUtils.equals((CharSequence)"defaultTask", (CharSequence)curTask.getTaskId())) {
            allTaskList.add(curTask);
        }
        if (!CollectionUtils.isEmpty(todoStatusTaskList = this.taskInfoDao.queryTasksByTaskStatus(DateUtil.getUtcDate(new Date()), authenticateInfoBo.getLoginAccount(), TaskStatusNameEnum.TO_DO.getCode()))) {
            allTaskList.addAll(todoStatusTaskList);
        }
        if (!CollectionUtils.isEmpty(completionStatusTaskList = this.taskInfoDao.queryTasksByTaskStatus(null, authenticateInfoBo.getLoginAccount(), TaskStatusNameEnum.COMPLETE.getCode()))) {
            allTaskList.addAll(completionStatusTaskList);
        }
        Date startTime = Objects.isNull(pageRequest.getStartTime()) ? DateUtil.getUtcDate(new Date(System.currentTimeMillis() - 86400000L)) : pageRequest.getStartTime();
        Date endTime = Objects.isNull(pageRequest.getEndTime()) ? DateUtil.getUtcDate(new Date(System.currentTimeMillis() + 86400000L)) : pageRequest.getEndTime();
        ArrayList<TaskInfoBo> tasksInTimeRange = new ArrayList<TaskInfoBo>();
        if (!CollectionUtils.isEmpty(allTaskList)) {
            for (TaskInfoBo task : allTaskList) {
                if (Objects.nonNull(curTask) && StringUtils.equals((CharSequence)task.getTaskId(), (CharSequence)curTask.getTaskId())) {
                    tasksInTimeRange.add(task);
                    continue;
                }
                long taskStartTime = task.getTaskStartTime().getTime();
                if (taskStartTime < startTime.getTime() || taskStartTime > endTime.getTime()) continue;
                tasksInTimeRange.add(task);
            }
        }
        taskInfoQueryVo.setTotal(tasksInTimeRange.size());
        return tasksInTimeRange;
    }

    static {
        TEMP_PATH = System.getProperties().getProperty("user.home") + File.separator + "insideTemp";
    }
}

