/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskSubtypeBo;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskSubtypeDao;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkOrderSelectSwingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceSwingService.class);
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private TaskSubtypeDao taskSubtypeDao;

    public Result setCurTask(String taskId) {
        LOGGER.info("Start setCurTask.");
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryTaskInfoByTaskId(taskId);
        TaskSubtypeBo taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskId);
        String errMsg = this.checkTaskInfo(taskInfoBo, taskSubtypeBo);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            LOGGER.error(errMsg);
            return Result.fail(errMsg, this.internationalizeUtil.getMessage(errMsg));
        }
        this.updateCurTaskStatus(taskInfoBo);
        this.taskInfoDao.setCurTask(taskId);
        this.taskInfoDao.setOtherTask(taskId, taskInfoBo.getTaskExecutor());
        LOGGER.info("Set CurTask {} success.", (Object)taskId);
        return Result.success("Set success.");
    }

    private String checkTaskInfo(TaskInfoBo taskInfoBo, TaskSubtypeBo taskSubtypeBo) {
        if (Objects.isNull(taskInfoBo)) {
            LOGGER.error("The taskId does not exist.");
            return ErrorCodeEnum.TICKET_ID_NOT_EXIST.getErrorCode();
        }
        if (!Objects.equals(taskInfoBo.getTaskStatus(), TaskStatusNameEnum.TO_DO.getCode())) {
            LOGGER.error("The task is not in the to-do status and cannot be set.");
            return ErrorCodeEnum.TICKET_STATUS_IS_TO_DO.getErrorCode();
        }
        if (DateUtil.getUtcDate(new Date()).after(taskInfoBo.getTaskEndTime())) {
            LOGGER.error("The task has expired.");
            return ErrorCodeEnum.TICKET_HAS_EXPIRED.getErrorCode();
        }
        if (Objects.isNull(taskSubtypeBo)) {
            if (StringUtils.equals((CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), (CharSequence)taskInfoBo.getTaskType())) {
                if (DateUtil.getUtcDate(new Date()).before(taskInfoBo.getOperationPreparationTime())) {
                    LOGGER.error("The current time is not within the task time range.");
                    return ErrorCodeEnum.CURRENT_TIME_NOT_RANGE_TICKET.getErrorCode();
                }
            } else if (DateUtil.getUtcDate(new Date()).before(taskInfoBo.getTaskStartTime())) {
                LOGGER.error("The current time is not within the task time range.");
                return ErrorCodeEnum.CURRENT_TIME_NOT_RANGE_TICKET.getErrorCode();
            }
        }
        return "";
    }

    private void updateCurTaskStatus(TaskInfoBo taskInfoBo) {
        TaskInfoBo taskInfoBoInCur = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), taskInfoBo.getTaskExecutor());
        if (Objects.nonNull(taskInfoBoInCur)) {
            taskInfoBoInCur.setIsCurTask(false);
            taskInfoBoInCur.setTaskStatus(TaskStatusNameEnum.TO_DO.getCode());
            this.taskInfoDao.updateTask(taskInfoBoInCur);
            LOGGER.info("The task {} status is updated from In Progress to To-Do.", (Object)taskInfoBoInCur.getTaskId());
        }
    }
}

