/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.netcareinsidesdk.bo.InternationalizeBo;
import com.huawei.netcareinsidesdk.bo.InternationalizeDictBo;
import com.huawei.netcareinsidesdk.bo.ProductLineBo;
import com.huawei.netcareinsidesdk.bo.RegionOfficeDataBo;
import com.huawei.netcareinsidesdk.dao.SysDataInfoDao;
import com.huawei.netcareinsidesdk.dao.SysDictDataMapper;
import com.huawei.netcareinsidesdk.utils.ExportUtil;
import com.huawei.netcareinsidesdk.utils.ReflexesUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataInternationalizationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataInternationalizationUtil.class);
    private static ThreadLocal<Map<String, Object>> localStore = new ThreadLocal();
    private List<RegionOfficeDataBo> regionList = new ArrayList<RegionOfficeDataBo>();
    private List<RegionOfficeDataBo> officeList = new ArrayList<RegionOfficeDataBo>();
    private List<ProductLineBo> productLineList = new ArrayList<ProductLineBo>();
    @Autowired
    private SysDictDataMapper sysDictDataMapper;
    @Autowired
    private SysDataInfoDao sysDataInfoDao;

    public Map<String, ProductLineBo> getInternationalizeProductLine() {
        if (ObjectUtils.isEmpty(this.productLineList)) {
            this.productLineList = this.sysDataInfoDao.queryProductLineData();
        }
        return this.productLineList.stream().collect(Collectors.toMap(ProductLineBo::getProductLineCode, productLineBo -> productLineBo, (k1, k2) -> k1));
    }

    public Map<String, RegionOfficeDataBo> getInternationalizeRegion() {
        if (ObjectUtils.isEmpty(this.regionList)) {
            this.regionList = this.sysDataInfoDao.queryRegionData();
        }
        return this.regionList.stream().collect(Collectors.toMap(RegionOfficeDataBo::getDataCode, sysDataBo -> sysDataBo, (k1, k2) -> k1));
    }

    public Map<String, Map<String, InternationalizeDictBo>> getInternationalizeDict(String type) {
        HashMap<String, Map<String, InternationalizeDictBo>> dictMap = new HashMap<String, Map<String, InternationalizeDictBo>>();
        HashMap<String, InternationalizeDictBo> dictIddMap = new HashMap<String, InternationalizeDictBo>();
        HashMap<String, InternationalizeDictBo> dictValueMap = new HashMap<String, InternationalizeDictBo>();
        HashMap<String, InternationalizeDictBo> dictCodeMap = new HashMap<String, InternationalizeDictBo>();
        List<InternationalizeDictBo> dictList = this.sysDictDataMapper.getDictByTypeAndCode(type);
        for (InternationalizeDictBo internationalizeDictBo : dictList) {
            dictIddMap.put(internationalizeDictBo.getDataId().toString(), internationalizeDictBo);
            dictValueMap.put(internationalizeDictBo.getDictValue(), internationalizeDictBo);
            dictCodeMap.put(internationalizeDictBo.getDictCode(), internationalizeDictBo);
        }
        dictMap.put("dictId", dictIddMap);
        dictMap.put("dictValue", dictValueMap);
        dictMap.put("dictCode", dictCodeMap);
        return dictMap;
    }

    public <T> List<T> setInternationalizeData(String languageType, List<T> objList, List<InternationalizeBo> boList) {
        if (CollectionUtils.isEmpty(objList)) {
            return objList;
        }
        HashMap<String, Map<String, Object>> store = new HashMap<String, Map<String, Object>>();
        block11: for (InternationalizeBo internationalizeBo : boList) {
            switch (internationalizeBo.getType()) {
                case "productLineCode": 
                case "productLineCodeList": {
                    store.put("productLineCode", this.getInternationalizeProductLine());
                    continue block11;
                }
                case "regionCode": {
                    store.put("regionCode", this.getInternationalizeRegion());
                    continue block11;
                }
                case "repOfficeCode": {
                    store.put("repOfficeCode", this.getInternationalizeOffice());
                    continue block11;
                }
            }
            store.put(internationalizeBo.getType(), this.getInternationalizeDict(internationalizeBo.getType()));
        }
        localStore.set(store);
        for (InternationalizeBo obj : objList) {
            this.setInternationalizeData(languageType, obj, boList);
        }
        localStore.remove();
        return objList;
    }

    public <T> T setInternationalizeData(String languageType, T obj, List<InternationalizeBo> boList) {
        if (Objects.isNull(obj) || CollectionUtils.isEmpty(boList)) {
            LOGGER.warn("InternationalizeUtils setInternationalizeData objList is empty");
            return obj;
        }
        for (InternationalizeBo internationalizeBo : boList) {
            try {
                switch (internationalizeBo.getType()) {
                    case "productLineCode": {
                        this.setProductLineLanguage(obj, internationalizeBo.getCodeField(), internationalizeBo.getNameField(), obj.getClass(), languageType);
                        break;
                    }
                    case "productLineCodeList": {
                        this.setProductLineListStrLanguage(obj, internationalizeBo.getCodeField(), internationalizeBo.getNameField(), obj.getClass(), languageType);
                        break;
                    }
                    case "regionCode": {
                        this.setRegionLanguage(obj, internationalizeBo.getCodeField(), internationalizeBo.getNameField(), obj.getClass(), languageType);
                        break;
                    }
                    case "repOfficeCode": {
                        this.setOfficeLanguage(obj, internationalizeBo.getCodeField(), internationalizeBo.getNameField(), obj.getClass(), languageType);
                        break;
                    }
                    default: {
                        this.setDict(languageType, obj, internationalizeBo);
                        break;
                    }
                }
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("InternationalizeUtils setInternationalizeData error");
            }
        }
        return obj;
    }

    private <T> T setDictLanguage(T obj, Class<? extends T> aClass, String languageType, InternationalizeBo internationalizeBo) throws NoSuchFieldException {
        Map<String, InternationalizeDictBo> internationalizeDictMap;
        String dictTypeKey = internationalizeBo.getType();
        Field dictCodeField = aClass.getDeclaredField(internationalizeBo.getCodeField());
        Field dictNameField = aClass.getDeclaredField(internationalizeBo.getNameField());
        Object dictKeyObj = ReflexesUtils.getField(dictCodeField, obj, aClass);
        String dictKey = String.valueOf(dictKeyObj);
        if (Objects.isNull(dictKeyObj) || StringUtils.isEmpty((CharSequence)dictKey)) {
            ReflexesUtils.setField(dictNameField, obj, aClass, null);
            return obj;
        }
        Map<String, Map<String, InternationalizeDictBo>> internationalizeDict = null;
        if (localStore.get() != null) {
            try {
                internationalizeDict = ExportUtil.objConvertMapMap(localStore.get().get(dictTypeKey), InternationalizeDictBo.class);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("InternationalizeUtils setDictLanguage data format error");
            }
        } else {
            internationalizeDict = this.getInternationalizeDict(internationalizeBo.getType());
        }
        InternationalizeDictBo internationalizeDictBo = null;
        if (internationalizeDict != null && (internationalizeDictMap = internationalizeDict.get(internationalizeBo.getTagType())) != null && internationalizeDictMap.containsKey(dictKey)) {
            internationalizeDictBo = internationalizeDictMap.get(dictKey);
        }
        if (internationalizeDictBo != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{internationalizeDictBo.getDictValueEn(), internationalizeDictBo.getDictValueCn()})) {
            if (StringUtils.equalsIgnoreCase((CharSequence)languageType, (CharSequence)"en-US")) {
                ReflexesUtils.setField(dictNameField, obj, aClass, internationalizeDictBo.getDictValueEn());
            } else {
                ReflexesUtils.setField(dictNameField, obj, aClass, internationalizeDictBo.getDictValueCn());
            }
        } else if (!StringUtils.equals((CharSequence)internationalizeBo.getUpdateType(), (CharSequence)"NOT_UPDATE")) {
            ReflexesUtils.setField(dictNameField, obj, aClass, null);
        }
        return obj;
    }

    private <T> void setDict(String languageType, T obj, InternationalizeBo internationalizeBo) throws NoSuchFieldException {
        if (Objects.isNull(internationalizeBo.getTagType()) || Objects.isNull(internationalizeBo.getUpdateType())) {
            LOGGER.error("InternationalizeUtils setDict tagType or updateType is null");
            return;
        }
        this.setDictLanguage(obj, obj.getClass(), languageType, internationalizeBo);
    }

    private <T> T setProductLineListStrLanguage(T obj, String productCodeListFieldStr, String productLineNameList, Class<? extends T> aClass, String languageType) throws NoSuchFieldException {
        Field productCodeListField = aClass.getDeclaredField(productCodeListFieldStr);
        Field productNameField = aClass.getDeclaredField(productLineNameList);
        String productCodeList = (String)ReflexesUtils.getField(productCodeListField, obj, aClass);
        if (StringUtils.isEmpty((CharSequence)productCodeList)) {
            ReflexesUtils.setField(productNameField, obj, aClass, null);
            return obj;
        }
        if (StringUtils.equals((CharSequence)productCodeList, (CharSequence)"All")) {
            ReflexesUtils.setField(productNameField, obj, aClass, "All");
            return obj;
        }
        Map<String, ProductLineBo> internationalizeProductLine = this.getInternationalizeProductLineData();
        String[] split = productCodeList.split(",");
        ArrayList<String> productLineNameStrList = new ArrayList<String>();
        for (String productCode : split) {
            ProductLineBo productLineBo = null;
            if (internationalizeProductLine != null && internationalizeProductLine.containsKey(productCode)) {
                productLineBo = internationalizeProductLine.get(productCode);
            }
            if (productLineBo != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{productLineBo.getProductLineEn(), productLineBo.getProductLine()})) {
                if (StringUtils.equalsIgnoreCase((CharSequence)languageType, (CharSequence)"en-US")) {
                    productLineNameStrList.add(productLineBo.getProductLineEn());
                    continue;
                }
                productLineNameStrList.add(productLineBo.getProductLine());
                continue;
            }
            productLineNameStrList.add(null);
        }
        String productName = String.join((CharSequence)",", productLineNameStrList);
        ReflexesUtils.setField(productNameField, obj, aClass, productName);
        return obj;
    }

    private <T> T setRegionLanguage(T obj, String regionCodeFieldStr, String regionName, Class<? extends T> aClass, String languageType) throws NoSuchFieldException {
        Field regionCodeField = aClass.getDeclaredField(regionCodeFieldStr);
        Field regionNameField = aClass.getDeclaredField(regionName);
        String regionCode = (String)ReflexesUtils.getField(regionCodeField, obj, aClass);
        if (StringUtils.equals((CharSequence)regionCode, (CharSequence)"All")) {
            ReflexesUtils.setField(regionNameField, obj, aClass, "All");
            return obj;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)regionCode, (CharSequence)"common")) {
            ReflexesUtils.setField(regionNameField, obj, aClass, "common");
            return obj;
        }
        Map<String, RegionOfficeDataBo> internationalizeRegion = null;
        if (localStore.get() != null && localStore.get().containsKey("regionCode")) {
            try {
                internationalizeRegion = ExportUtil.objConvertMap(localStore.get().get("regionCode"), RegionOfficeDataBo.class);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("InternationalizeUtils setRegionLanguage data format error");
            }
        } else {
            internationalizeRegion = this.getInternationalizeRegion();
        }
        RegionOfficeDataBo regionBo = null;
        if (internationalizeRegion != null && internationalizeRegion.containsKey(regionCode)) {
            regionBo = internationalizeRegion.get(regionCode);
        }
        if (regionBo != null) {
            if (StringUtils.equalsIgnoreCase((CharSequence)languageType, (CharSequence)"en-US")) {
                ReflexesUtils.setField(regionNameField, obj, aClass, regionBo.getDataNameEn());
            } else {
                ReflexesUtils.setField(regionNameField, obj, aClass, regionBo.getDataNameCn());
            }
        }
        return obj;
    }

    private <T> T setOfficeLanguage(T obj, String officeCodeFieldStr, String officeName, Class<? extends T> aClass, String languageType) throws NoSuchFieldException {
        Field officeCodeField = aClass.getDeclaredField(officeCodeFieldStr);
        Field officeNameField = aClass.getDeclaredField(officeName);
        String officeCode = (String)ReflexesUtils.getField(officeCodeField, obj, aClass);
        if (StringUtils.equals((CharSequence)officeCode, (CharSequence)"All")) {
            ReflexesUtils.setField(officeNameField, obj, aClass, "All");
            return obj;
        }
        Map<String, RegionOfficeDataBo> internationalizeOffice = null;
        if (localStore.get() != null && localStore.get().containsKey("repOfficeCode")) {
            try {
                internationalizeOffice = ExportUtil.objConvertMap(localStore.get().get("repOfficeCode"), RegionOfficeDataBo.class);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("InternationalizeUtils setOfficeLanguage error");
            }
        } else {
            internationalizeOffice = this.getInternationalizeOffice();
        }
        RegionOfficeDataBo officeBo = null;
        if (internationalizeOffice != null && internationalizeOffice.containsKey(officeCode)) {
            officeBo = internationalizeOffice.get(officeCode);
        }
        if (officeBo != null) {
            if (StringUtils.equalsIgnoreCase((CharSequence)languageType, (CharSequence)"en-US")) {
                ReflexesUtils.setField(officeNameField, obj, aClass, officeBo.getDataNameEn());
            } else {
                ReflexesUtils.setField(officeNameField, obj, aClass, officeBo.getDataNameCn());
            }
        }
        return obj;
    }

    private <T> T setProductLineLanguage(T obj, String productCodeFieldStr, String productlLineName, Class<? extends T> aClass, String languageType) throws NoSuchFieldException {
        Field productNameField = aClass.getDeclaredField(productlLineName);
        Field productCodeField = aClass.getDeclaredField(productCodeFieldStr);
        String productCode = (String)ReflexesUtils.getField(productCodeField, obj, aClass);
        if (StringUtils.equals((CharSequence)productCode, (CharSequence)"All")) {
            ReflexesUtils.setField(productNameField, obj, aClass, "All");
            return obj;
        }
        Map<String, ProductLineBo> internationalizeProductLine = this.getInternationalizeProductLineData();
        ProductLineBo productLineBo = null;
        if (internationalizeProductLine != null && internationalizeProductLine.containsKey(productCode)) {
            productLineBo = internationalizeProductLine.get(productCode);
        }
        if (productLineBo != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{productLineBo.getProductLineEn(), productLineBo.getProductLine()})) {
            if (StringUtils.equalsIgnoreCase((CharSequence)languageType, (CharSequence)"en-US")) {
                ReflexesUtils.setField(productNameField, obj, aClass, productLineBo.getProductLineEn());
            } else {
                ReflexesUtils.setField(productNameField, obj, aClass, productLineBo.getProductLine());
            }
        }
        return obj;
    }

    private Map<String, ProductLineBo> getInternationalizeProductLineData() {
        Map<String, ProductLineBo> internationalizeProductLine = null;
        if (localStore.get() != null && localStore.get().containsKey("productLineCode")) {
            try {
                internationalizeProductLine = ExportUtil.objConvertMap(localStore.get().get("productLineCode"), ProductLineBo.class);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("InternationalizeUtils setProductLineListStrLanguage data format error");
            }
        } else {
            internationalizeProductLine = this.getInternationalizeProductLine();
        }
        return internationalizeProductLine;
    }

    public Map<String, RegionOfficeDataBo> getInternationalizeOffice() {
        if (ObjectUtils.isEmpty(this.officeList)) {
            this.officeList = this.sysDataInfoDao.queryOfficeData();
        }
        return this.officeList.stream().collect(Collectors.toMap(RegionOfficeDataBo::getDataCode, sysDataBo -> sysDataBo, (k1, k2) -> k1));
    }

    public InternationalizeBo getDictCodeInternationalizeBo(String codeField, String nameField, String dictCode) {
        return new InternationalizeBo(codeField, nameField, dictCode, "dictCode", "NULL");
    }

    public ArrayList<InternationalizeBo> getRegOfficeProductInternationalizeBos() {
        ArrayList<InternationalizeBo> internationalizeBos = new ArrayList<InternationalizeBo>();
        internationalizeBos.add(DataInternationalizationUtil.getRegionInternationalizeBo());
        internationalizeBos.add(this.getOfficeInternationalizeBo());
        internationalizeBos.add(this.getProductLineInternationalizeBo());
        return internationalizeBos;
    }

    public static InternationalizeBo getRegionInternationalizeBo() {
        return DataInternationalizationUtil.getInternationalizeBo("regionCode", "regionName", "regionCode");
    }

    public static InternationalizeBo getInternationalizeBo(String fieldCode, String fieldName, String fieldType) {
        return new InternationalizeBo(fieldCode, fieldName, fieldType);
    }

    public InternationalizeBo getOfficeInternationalizeBo() {
        return DataInternationalizationUtil.getInternationalizeBo("repOfficeCode", "repOfficeName", "repOfficeCode");
    }

    public InternationalizeBo getProductLineInternationalizeBo() {
        return DataInternationalizationUtil.getInternationalizeBo("productLineCode", "productLineName", "productLineCodeList");
    }
}

