/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ExportUtil {
    public static <V> Map<String, V> objConvertMap(Object obj, Class<V> vClass) throws IllegalAccessException {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)obj;
            for (String key : jsonObj.keySet()) {
                map.put(key, jsonObj.getObject(key, vClass));
            }
            return map;
        }
        if (obj instanceof HashMap) {
            JSONObject jsonObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)obj));
            for (String key : jsonObj.keySet()) {
                map.put(key, jsonObj.getObject(key, vClass));
            }
            return map;
        }
        Class<?> oClass = obj.getClass();
        for (Field field : oClass.getDeclaredFields()) {
            String key = ExportUtil.getFieldName(field);
            Object value = ExportUtil.getFieldValue(field, obj, oClass);
            if (value == null) {
                value = "";
            }
            map.put(key, vClass.cast(value));
        }
        return map;
    }

    public static <V> List<Map<String, V>> objConvertListMap(Object obj, Class<V> objectClass) throws IllegalAccessException {
        ArrayList<Map<String, V>> result = new ArrayList<Map<String, V>>();
        if (obj instanceof List) {
            List temp = (List)obj;
            for (Object objTemp : temp) {
                Map<String, V> stringVMap = ExportUtil.objConvertMap(objTemp, objectClass);
                result.add(stringVMap);
            }
            return result;
        }
        return null;
    }

    private static <T> Object getFieldValue(Field field, T obj, Class<? extends T> objClass) {
        String filedName = ExportUtil.getFieldName(field);
        String methodName2 = ExportUtil.getMethodName(filedName, "is");
        String methodName = ExportUtil.getMethodName(filedName, "get");
        try {
            Method[] methods;
            for (Method method : methods = objClass.getMethods()) {
                if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) && !StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName2)) continue;
                return method.invoke(obj, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    public static <V> Map<String, Map<String, V>> objConvertMapMap(Object obj, Class<V> objectClass) throws IllegalAccessException {
        HashMap<String, Map<String, Map<String, V>>> result = new HashMap<String, Map<String, Map<String, V>>>();
        if (obj instanceof Map) {
            Map temp = (Map)obj;
            Set entries = temp.entrySet();
            for (Map.Entry entry : entries) {
                String key = entry.getKey().toString();
                Map<String, V> stringVMap = ExportUtil.objConvertMap(entry.getValue(), objectClass);
                result.put(key, stringVMap);
            }
            return result;
        }
        return null;
    }

    private static String getMethodName(String filedName, String method) {
        return method + filedName.substring(0, 1).toUpperCase(Locale.ROOT) + filedName.substring(1);
    }

    private static String getFieldName(Field field) {
        return field.getName();
    }
}

