/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.netcareinsidesdk.constants.FileTypeEnum;
import com.huawei.us.common.file.UsFileUtils;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileDealUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDealUtil.class);
    private static final int MAX_POST_SIZE = 0x1E00000;

    public static void clearTempFiles(File tempFile) {
        if (Objects.isNull(tempFile) || !tempFile.isDirectory()) {
            return;
        }
        File[] files = tempFile.listFiles();
        if (Objects.isNull(files) || files.length < 1) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() || !StringUtils.isNotBlank((CharSequence)file.getName())) continue;
            boolean isFlag = file.delete();
            if (!isFlag) {
                LOGGER.error("delete file {} failed.", (Object)file.getName());
                continue;
            }
            LOGGER.info("delete file {} success.", (Object)file.getName());
        }
    }

    public static boolean checkFileType(InputStream inputStream, FileTypeEnum fileTypeEnum) {
        String fileHead = FileDealUtil.getFileHeader(inputStream);
        if (StringUtils.isNotEmpty((CharSequence)fileHead)) {
            fileHead = fileHead.toUpperCase(Locale.ROOT);
            return fileHead.startsWith(fileTypeEnum.getFileHeadtoHex());
        }
        return false;
    }

    private static String getFileHeader(InputStream inputStream) {
        byte[] bytes = new byte[28];
        try {
            int num = inputStream.read(bytes, 0, 28);
            if (num != -1) {
                return FileDealUtil.bytesToHex(bytes);
            }
        }
        catch (IOException except) {
            LOGGER.error("read file from inputStream error.");
        }
        return null;
    }

    private static String bytesToHex(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte bt : src) {
            int var = bt & 0xFF;
            String hv = Integer.toHexString(var);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static void deleteDir(File directory) {
        boolean isFlag;
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileDealUtil.deleteDir(file);
                continue;
            }
            isFlag = file.delete();
            if (!isFlag) {
                LOGGER.error("delete file {} failed", (Object)file.getName());
                continue;
            }
            LOGGER.info("delete file {} success", (Object)file.getName());
        }
        isFlag = directory.delete();
        if (!isFlag) {
            LOGGER.error("delete dir {} failed", (Object)directory.getName());
            return;
        }
        LOGGER.info("delete dir {} success", (Object)directory.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSecureFile(MultipartFile file) {
        String tmpDir = SystemConfigUtil.getStringValueByName((String)"us.file.check.temp.dir", (String)"");
        File tempFile = new File(tmpDir);
        try {
            String flag;
            if (!tempFile.exists()) {
                if (!tempFile.mkdirs()) {
                    LOGGER.error("US-Check,Create temp dir failed.");
                    boolean bl = false;
                    return bl;
                }
                LOGGER.info("US-Check,Create temp dir {} success", (Object)tmpDir);
            }
            String tempDir = System.getProperty("java.io.tmpdir");
            if (!StringUtils.endsWithAny((CharSequence)tempDir, (CharSequence[])new CharSequence[]{"temp", "Temp", "tmp", "Tmp"})) {
                System.setProperty("tempDirCheck", "true");
                LOGGER.warn("US-Check,tempDir is incorrect, set tempDirCheck to true.");
            }
            if (!(flag = UsFileUtils.checkInputStream((InputStream)file.getInputStream(), (String)file.getOriginalFilename(), (String)"zip", (long)0x1E00000L, (boolean)true, (String[])new String[]{"sign", "json"})).equals("0")) {
                LOGGER.error("US-Check,The initInfo .zip package file is abnormal.");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException exception) {
            LOGGER.error("US-Check,checkInputStream ioException.");
            boolean bl = false;
            return bl;
        }
        finally {
            FileDealUtil.deleteDir(tempFile);
        }
        return true;
    }
}

