/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.us.common.codec.USCodec;
import com.huawei.us.common.crypto.USKeyManager;
import com.huawei.us.common.crypto.USRandomizer;
import com.huawei.us.common.file.UsFileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyManagerUtil.class);
    private static final int MASTER_KEY_LEN = 64;
    private static final String DB_PROPERTY_DIR = System.getProperty("user.home") + File.separator + "netcareinside";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateMasterAndWorkKey() {
        LOGGER.info("Start generateMasterAndWorkKey.");
        byte[] bytes = USRandomizer.getRandomBytes((int)64);
        String factorKey = USCodec.encodeForBase64((byte[])bytes);
        FileOutputStream fileOutputStream = null;
        try (InputStream inStream = KeyManagerUtil.class.getResourceAsStream("/us.config.properties");){
            Properties props = new Properties();
            props.load(inStream);
            LOGGER.info("load us.config.properties success.");
            String filePath = "";
            File file = UsFileUtils.getFile((String)filePath);
            props.setProperty("keymanager.factor", factorKey);
            fileOutputStream = UsFileUtils.getFileOutputStream((File)file);
            props.store(fileOutputStream, null);
            LOGGER.info("write keymanager.factor to us.config.properties success.");
            String workKeyCipher = USKeyManager.getNewWorkKeyCipher();
            props.setProperty("keymanager.store", workKeyCipher);
            props.store(fileOutputStream, null);
            LOGGER.info("write keymanager.store to us.config.properties success.");
        }
        catch (IOException exception) {
            LOGGER.error("generateMasterAndWorkKey ioexception.");
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioException) {
                    LOGGER.error("close fileOutputStream error");
                }
            }
        }
    }
}

