/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RsaUtil.class);
    private static final String DEFAULT_CIPHER_AND_PADDING = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    public static String encrypt(String data, String publicKey) throws GeneralSecurityException {
        byte[] doFinal;
        if (StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        try {
            OAEPParameterSpec oaepParameterSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_AND_PADDING);
            cipher.init(1, (Key)RsaUtil.getPublicKey(publicKey), oaepParameterSpec);
            doFinal = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException except) {
            LOGGER.error("encrypt failed.");
            throw except;
        }
        return Base64.getEncoder().encodeToString(doFinal);
    }

    public static PublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (StringUtils.isEmpty((CharSequence)publicKey)) {
            throw new NetCareInsideSdkException("public key is empty!");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey));
        return keyFactory.generatePublic(keySpec);
    }
}

