/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextCommonUtils
implements ApplicationContextAware {
    private static final Logger RUN_LOG = LoggerFactory.getLogger(SpringContextCommonUtils.class);
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextCommonUtils.setApplicationContextValue(applicationContext);
    }

    public static void setApplicationContextValue(ApplicationContext applicationContext) {
        SpringContextCommonUtils.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return SpringContextCommonUtils.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return (T)SpringContextCommonUtils.getApplicationContext().getBean(clazz);
        }
        catch (BeansException ex) {
            RUN_LOG.error("SpringContextCommonUtils getBean error !! clazz ={}", (Object)ex.getMessage());
            return null;
        }
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringContextCommonUtils.getApplicationContext().getBean(name, clazz);
    }

    public static boolean containsBean(String name) {
        return SpringContextCommonUtils.getApplicationContext().containsBean(name);
    }

    public static String[] getBeanNamesForType(Class<?> clazz) {
        return SpringContextCommonUtils.getApplicationContext().getBeanNamesForType(clazz);
    }
}

