/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.utils;

import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.utils.QRCodeUtil;
import com.huawei.us.common.file.UsFileSafeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger RUN_LOGGER = LoggerFactory.getLogger(QRCodeUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String unZipFiles(File zipFile, String descDir) throws IOException {
        String safeFilePath = UsFileSafeUtils.getSafeFilePath((String)descDir);
        try (ZipFile zip = new ZipFile(zipFile, Charset.forName("GBK"));){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String msg = ZipUtils.unZipEntry(safeFilePath, zip, entries);
                if (!Objects.nonNull(msg)) continue;
                String string = msg;
                return string;
            }
        }
        catch (IOException exception) {
            RUN_LOGGER.error("Failed to compress the Zip file.");
            throw new IOException(exception);
        }
        RUN_LOGGER.info("Unzip file succeed!");
        return null;
    }

    private static String unZipEntry(String safeFilePath, ZipFile zip, Enumeration<? extends ZipEntry> entries) throws IOException {
        ZipEntry entry = entries.nextElement();
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            String returnMsg;
            in = zip.getInputStream(entry);
            String curEntryName = entry.getName();
            int endIndex = curEntryName.lastIndexOf(47);
            String outPath = (safeFilePath + File.separator + curEntryName).replaceAll("\\*", "/");
            if (endIndex != -1 && Objects.nonNull(returnMsg = ZipUtils.mkEntryDir(outPath))) {
                String string = returnMsg;
                return string;
            }
            File outFile = new File(outPath);
            if (outFile.isDirectory()) {
                String string = null;
                return string;
            }
            out = Files.newOutputStream(Paths.get(outPath, new String[0]), new OpenOption[0]);
            byte[] buf1 = new byte[1024];
            while ((len = in.read(buf1)) > 0) {
                out.write(buf1, 0, len);
            }
        }
        catch (IOException exception) {
            RUN_LOGGER.error("Failed to compress the ZipEntry file.");
            throw new IOException(exception);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    private static String mkEntryDir(String outPath) {
        boolean isFlag;
        File file = new File(outPath.substring(0, outPath.lastIndexOf("/")));
        if (!file.exists() && !(isFlag = file.mkdirs())) {
            RUN_LOGGER.error("Create EntryDir failed.");
            return ErrorCodeEnum.UNZIP_FILE_FAILED.getErrorCode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        FileInputStream fis = null;
        OutputStream os = null;
        try {
            fis = new FileInputStream(file);
            os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                RUN_LOGGER.error("[XLSParser] close stream failed!");
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                RUN_LOGGER.error("[XLSParser] close stream failed!");
            }
        }
        return item;
    }
}

