/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.infoqry;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.ui.action.SceneAddDeviceAction;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.devicemanager.utils.ModeTypeParse;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.ComputeStorageDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.FceRestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class ComputeStorageInfoQryServiceImpl
implements INodeTypeQuery {
    private static final Logger log = LoggerFactory.getLogger(ComputeStorageInfoQryServiceImpl.class);
    public static final String DEVICE_CANNOT_CONNECT = "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror";
    public static final String FCE_LOGIN_ROLE_NOT_OPENAPI = "fce.login.role.is.not.openapi";
    public static final String CLUSTER_INFO_QUERY_FAIL = "devicemanager.layout.device.add.deviceadddialog.query.cluster.info.fail";
    protected INodeSupport nodeSupport = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        TaskResult ret = new TaskResult();
        ret.setResultObject((Object)devNode);
        try {
            FceRestConnection restConn = RestConnectionManager.getFceRestConnection(devNode);
            if (restConn == null || !restConn.isLogin()) {
                String errId = DEVICE_CANNOT_CONNECT;
                ret.setErrorId(errId);
                ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)errId, (Object[])new Object[]{devNode.getIp()}));
                ret.setResult(TaskResult.Result.FAILED);
                log.error("rest conn is build failed.");
                TaskResult taskResult = ret;
                return taskResult;
            }
            if (!this.getStorageDeviceInfo(devNode, restConn)) {
                log.error("Query cluster info by rest failed.");
                this.makeQueryCluserInfoFailResult(devNode, ret);
                TaskResult taskResult = ret;
                return taskResult;
            }
            log.info("Query node info by fcv success.");
            ret.setResult(TaskResult.Result.SUCCESS);
            ret.setErrorLocaleDescription("");
            ret.setResultObject((Object)devNode);
            devNode.setItDeviceType(ItDeviceType.Storage);
            devNode.setStorageDeviceType(ItDeviceType.COMPUTE_STORAGE);
            this.nodeSupportCheck(devNode, ret);
            this.checkRestCert(restConn, devNode);
            TaskResult taskResult = ret;
            return taskResult;
        }
        catch (ToolException e) {
            if ("No trusted certificate found".equals(e.getErrorId())) {
                ret.setNeedCertWarn(true);
                TaskResult taskResult = ret;
                return taskResult;
            }
            ret.setErrorId(e.getErrorId());
            log.error("execute cmd error.", (Throwable)e);
            this.makeErrorTaskResult(devNode, ret);
            TaskResult taskResult = ret;
            return taskResult;
        }
        finally {
            RestConnectionManager.releaseFceConnection(devNode);
        }
    }

    protected void nodeSupportCheck(DevNode devNode, TaskResult ret) {
        if (this.nodeSupport == null || TaskResult.Result.FAILED.equals((Object)ret.getResult())) {
            return;
        }
        DeviceType tmpType = DeviceType.valueOf((String)(devNode.getDeviceType() + " " + devNode.getProductVersion()));
        com.huawei.ism.tool.framework.pubservice.entity.DevNode newDevNode = EntityUtils.toNewDev((DevNode)devNode);
        if (this.nodeSupport.isNodeSupport(newDevNode)) {
            return;
        }
        if (this.nodeSupport instanceof SceneAddDeviceAction) {
            this.setTaskFailedResultWithSceneNotSupportErrMsg((SceneAddDeviceAction)this.nodeSupport, ret, devNode, tmpType);
            return;
        }
        this.setTaskFailedResult(ret, devNode, tmpType);
    }

    protected void setTaskFailedResultWithSceneNotSupportErrMsg(SceneAddDeviceAction sceneAddDeviceAction, TaskResult ret, DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
        } else {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)sceneAddDeviceAction.getAddDevErrMsgPropKey(), (Object[])new Object[]{devNode.getIp(), tmpType}));
        }
        ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.devtype.or.version.scene.notsuport");
    }

    protected void setTaskFailedResult(TaskResult ret, DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
            return;
        }
        ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.nosupportdevtype", (Object[])new Object[]{devNode.getIp(), tmpType}));
    }

    public boolean getStorageDeviceInfo(DevNode devNode, FceRestConnection conn) {
        try {
            Map<String, List<String>> enclosureIpLists = this.queryClusterProductInfo(devNode, conn);
            this.queryStorageInfo(devNode, conn, enclosureIpLists);
            return !devNode.getComputeStorageDevNode().getStorageNodesInfo().isEmpty();
        }
        catch (JSONException e) {
            log.error("getStorageDeviceInfo JSONException:", (Throwable)e);
            return false;
        }
        catch (ToolException te) {
            log.error("getStorageDeviceInfo tool exception:", (Throwable)te);
            return false;
        }
        catch (Exception e) {
            log.error("getStorageDeviceInfo exception:", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getStorageProductInfo(DevNode tmpStorageDevNode, Map<String, String> storageInfoMap) {
        try (ICliConnection cli = null;){
            String[] tmpList;
            cli = SshConnectionManager.getSshConnection((DevNode)tmpStorageDevNode, null, (boolean)true, (boolean)false);
            String ret = cli.execCmd("show system general|filterColumn include columnList=Product\\sModel,Product\\sVersion,System\\sName,SN,Internal\\sProduct\\sModel");
            String cliResult = cli.execCmd("show system general");
            boolean needGetDeviceModeByRest = DeviceAddUtil.needGetDeviceModeByRest(cliResult);
            for (String line : tmpList = ret.split(System.lineSeparator())) {
                if (!line.contains(":")) continue;
                log.info("getStorageProductInfo ret line:{}", (Object)line);
                String[] valueList = line.split(":");
                String valueStr = valueList[1].trim();
                String keyStr = valueList[0].trim();
                this.setStorageInfo(tmpStorageDevNode, valueStr, keyStr, storageInfoMap, needGetDeviceModeByRest);
            }
        }
        log.info("queryClusterProductInfo : node info:{}", (Object)tmpStorageDevNode.toString());
        return true;
    }

    private void setStorageInfo(DevNode storageDevNode, String valueStr, String keyStr, Map<String, String> storageInfoMap, boolean needGetDeviceModeByRest) {
        if (keyStr.contains("System Name")) {
            storageDevNode.setDeviceName(valueStr);
            storageInfoMap.put("deviceName", valueStr);
        }
        if (keyStr.contains("Product Version")) {
            String productVersion = valueStr;
            String patchVersion = "--";
            if (valueStr.contains("SPH")) {
                productVersion = this.getProductVersion(valueStr);
                patchVersion = this.getPatchVersion(valueStr);
            }
            storageDevNode.setProductVersion(productVersion);
            storageDevNode.setHotPatchVersion(patchVersion);
            storageInfoMap.put("productVersion", productVersion);
            storageInfoMap.put("hotPatchVersion", patchVersion);
        }
        if (keyStr.contains("SN")) {
            storageDevNode.setDeviceSerialNumber(valueStr);
            storageInfoMap.put("sn", valueStr);
        }
        if (keyStr.contains("Internal Product Model")) {
            String deviceMode = ModeTypeParse.getModelType(needGetDeviceModeByRest ? DeviceAddUtil.getDeviceModeByRest(storageDevNode).orElse(valueStr) : valueStr);
            DeviceType type = DeviceType.valueOf((String)deviceMode);
            storageDevNode.setProductModel(deviceMode);
            storageInfoMap.put("productModel", deviceMode);
            storageDevNode.setDeviceType(type);
        } else if (keyStr.contains("Product Model")) {
            storageDevNode.setOemModel(valueStr);
            storageInfoMap.put("oemProductModel", valueStr);
        }
    }

    @NotNull
    private String getPatchVersion(String valueStr) {
        if (Products.isDigitalVer((String)valueStr)) {
            return "SPH" + valueStr.split(".SPH")[1];
        }
        return "SPH" + valueStr.split("SPH")[1];
    }

    private String getProductVersion(String valueStr) {
        if (Products.isDigitalVer((String)valueStr)) {
            return valueStr.split(".SPH")[0];
        }
        return valueStr.split("SPH")[0];
    }

    private void queryStorageInfo(DevNode devNode, FceRestConnection conn, Map<String, List<String>> enclosureIpLists) throws ToolException {
        ResponseInfo clusterSysInfoResp = conn.execGetWithNoLog(conn.getQueryStorageInfoUrl(), null);
        ComputeStorageDevNode csDevNode = devNode.getComputeStorageDevNode() == null ? new ComputeStorageDevNode() : devNode.getComputeStorageDevNode();
        csDevNode.setOpenapiUser(devNode.getLoginUser());
        csDevNode.setFcvIp(devNode.getIp());
        JSONObject jsonObj = new JSONObject(clusterSysInfoResp.getContent());
        String errorDes = jsonObj.getStringOrDefault("msg", "");
        String errorCode = jsonObj.getStringOrDefault("code", "-1");
        JSONObject sysObj = jsonObj.getJSONObject("data");
        if (!"0".equals(errorCode)) {
            log.error("Query cluster nodes failed, error code:{},error description:{}", (Object)errorCode, (Object)errorDes);
            throw new ToolException(DEVICE_CANNOT_CONNECT);
        }
        JSONObject storageObj = sysObj.getJSONObject("doradoStorage");
        DevNode tmpStorageDevNode = EntityUtils.cloneDevNode((DevNode)devNode);
        tmpStorageDevNode.setIp(storageObj.getStringOrDefault("ip", ""));
        User user = new User();
        user.setUserName(storageObj.getStringOrDefault("username", ""));
        user.setPassword(storageObj.getStringOrDefault("password", ""));
        Map<String, String> storageInfoMap = this.buildStorageMap(storageObj);
        tmpStorageDevNode.setLoginUser(user);
        tmpStorageDevNode.setComputeStorageDevNode(csDevNode);
        ArrayList<Map<String, String>> storageNodesInfo = new ArrayList<Map<String, String>>();
        List<String> allCtrlIp = enclosureIpLists.get("1");
        boolean isQuerySucc = this.isQueryProductSucc(tmpStorageDevNode, storageInfoMap, allCtrlIp);
        if (isQuerySucc) {
            this.packageDevNodeInfo(devNode, tmpStorageDevNode);
            storageNodesInfo.add(storageInfoMap);
        }
        log.info("queryStorageInfo:{}", (Object)devNode);
        this.getExtendStorageInfo(devNode, sysObj, storageNodesInfo, enclosureIpLists);
        devNode.getComputeStorageDevNode().setStorageNodesInfo(storageNodesInfo);
    }

    private boolean isQueryProductSucc(DevNode tmpStorageDevNode, Map<String, String> storageInfoMap, List<String> allCtrlIp) {
        boolean isQuerySucc = false;
        if (CollectionUtils.isEmpty(allCtrlIp)) {
            return isQuerySucc;
        }
        for (String ctrlIp : allCtrlIp) {
            tmpStorageDevNode.setIp(ctrlIp);
            storageInfoMap.put("ip", ctrlIp);
            isQuerySucc = this.getStorageProductInfo(tmpStorageDevNode, storageInfoMap);
            log.info("query enc StorageInfo by ip:{}, result: {}!", (Object)ctrlIp, (Object)isQuerySucc);
            if (!isQuerySucc) continue;
            break;
        }
        return isQuerySucc;
    }

    private void packageDevNodeInfo(DevNode devNode, DevNode tmpStorageDevNode) {
        devNode.setDeviceModel(tmpStorageDevNode.getDeviceModel());
        devNode.setProductModel(tmpStorageDevNode.getProductModel());
        devNode.setDeviceType(tmpStorageDevNode.getDeviceType());
        devNode.setProductVersion(tmpStorageDevNode.getProductVersion());
        devNode.setDeviceName(tmpStorageDevNode.getDeviceName());
    }

    @NotNull
    private Map<String, String> buildStorageMap(JSONObject storageObj) {
        HashMap<String, String> storageInfoMap = new HashMap<String, String>();
        storageInfoMap.put("ip", storageObj.getStringOrDefault("ip", ""));
        storageInfoMap.put("username", storageObj.getStringOrDefault("username", ""));
        storageInfoMap.put("password", AESEncrypt.encrypt((String)storageObj.getStringOrDefault("password", "")));
        storageInfoMap.put("computeStorageInfoChassisNum", String.valueOf(1));
        return storageInfoMap;
    }

    private void getExtendStorageInfo(DevNode devNode, JSONObject sysObj, List<Map<String, String>> storageNodesInfo, Map<String, List<String>> enclosureIpLists) throws ToolException {
        if (!sysObj.has("externalDoradoStorage") || sysObj.isNull("externalDoradoStorage")) {
            return;
        }
        JSONArray storageObjList = sysObj.getJSONArray("externalDoradoStorage");
        IntStream.range(0, storageObjList.length()).forEach(index -> this.setExtendStorageInfo(devNode, storageNodesInfo, storageObjList, index, enclosureIpLists));
    }

    private void setExtendStorageInfo(DevNode devNode, List<Map<String, String>> storageNodesInfo, JSONArray storageObjList, int index, Map<String, List<String>> enclosureIpLists) {
        HashMap<String, String> storageInfoMap = new HashMap<String, String>();
        DevNode tmpStorageDevNode = EntityUtils.cloneDevNode((DevNode)devNode);
        JSONObject storageObj = storageObjList.getJSONObject(index);
        tmpStorageDevNode.setIp(storageObj.getStringOrDefault("ip", ""));
        User user = new User();
        user.setUserName(storageObj.getStringOrDefault("username", ""));
        user.setPassword(storageObj.getStringOrDefault("password", ""));
        storageInfoMap.put("ip", storageObj.getStringOrDefault("ip", ""));
        storageInfoMap.put("username", storageObj.getStringOrDefault("username", ""));
        storageInfoMap.put("password", AESEncrypt.encrypt((String)storageObj.getStringOrDefault("password", "")));
        tmpStorageDevNode.setLoginUser(user);
        int chassisNum = index + 2;
        List<String> allCtrlIp = enclosureIpLists.get(String.valueOf(chassisNum));
        boolean isQuerySucc = this.isQueryProductSucc(tmpStorageDevNode, storageInfoMap, allCtrlIp);
        if (!isQuerySucc) {
            log.error("query extends storage info error! ip can't reach or login info is wrong.");
            return;
        }
        storageInfoMap.put("computeStorageInfoChassisNum", String.valueOf(chassisNum));
        log.info("query exted StorageInfo:{}", (Object)tmpStorageDevNode);
        storageNodesInfo.add(storageInfoMap);
    }

    public Map<String, List<String>> queryClusterProductInfo(DevNode devNode, FceRestConnection conn) throws ToolException {
        HashMap<String, List<String>> enclosureIpLists = new HashMap<String, List<String>>();
        int chassisTotal = this.queryClusterProductInfo(devNode, conn, conn.getQuerySystemInfoUrl(), enclosureIpLists);
        if (chassisTotal > 1) {
            for (int chassisNum = 2; chassisNum <= chassisTotal; ++chassisNum) {
                this.queryClusterProductInfo(devNode, conn, conn.getQueryExtendSystemInfoUrl(chassisNum), enclosureIpLists);
            }
        }
        return enclosureIpLists;
    }

    public int queryClusterProductInfo(DevNode devNode, FceRestConnection conn, String queryUrl, Map<String, List<String>> enclosureIpLists) throws ToolException {
        ResponseInfo clusterPdtInfoResp = conn.execGet(queryUrl);
        JSONObject jsonObj = new JSONObject(clusterPdtInfoResp.getContent());
        String errorCode = jsonObj.getStringOrDefault("code", "-1");
        String errorDes = jsonObj.getStringOrDefault("msg", "");
        if (!"0".equals(errorCode)) {
            log.error("Query fce nodes failed, error code:" + errorCode + ", error description:" + errorDes);
            throw new ToolException("error code:" + errorCode + ", error desc:" + errorDes);
        }
        JSONObject obj = jsonObj.getJSONObject("data");
        if (!obj.has("storageNodes")) {
            return 1;
        }
        int chassisTotal = obj.has("chassisTotal") ? obj.getInt("chassisTotal") : 1;
        int chassisNum = obj.has("chassisNum") ? obj.getInt("chassisNum") : 1;
        JSONArray storageNodes = obj.getJSONArray("storageNodes");
        this.getenclosureIpLists(enclosureIpLists, chassisNum, storageNodes);
        IntStream.range(0, storageNodes.length()).filter(i -> storageNodes.get(i) instanceof JSONObject).forEach(i -> this.assignClusterProductInfoToDevNode(devNode, storageNodes, i));
        log.info("queryClusterProductInfo : node info:{}, enclosureIpLists is:{}", (Object)devNode.toString(), enclosureIpLists);
        return chassisTotal;
    }

    private void getenclosureIpLists(Map<String, List<String>> enclosureIpLists, int chassisNum, JSONArray storageNodes) {
        List allCtrlIpList = IntStream.range(0, storageNodes.length()).mapToObj(i -> (JSONObject)storageNodes.get(i)).map(jsonObject -> jsonObject.getStringOrDefault("deviceIp", "")).filter(ctrlIp -> !StringUtils.isNULLStr((String)ctrlIp)).collect(Collectors.toList());
        enclosureIpLists.put(String.valueOf(chassisNum), allCtrlIpList);
    }

    private void assignClusterProductInfoToDevNode(DevNode devNode, JSONArray storageNodes, int i) {
        JSONObject storageNode = (JSONObject)storageNodes.get(i);
        log.info("queryClusterProductInfo : storageNodes info:{}", storageNodes.get(i));
        JSONArray extFeatures = storageNode.getJSONArray("extFeatures");
        int bound = extFeatures.length();
        IntStream.range(0, bound).filter(index -> extFeatures.get(index) instanceof JSONObject).mapToObj(index -> (JSONObject)extFeatures.get(index)).forEach(extFeaturesObject -> this.setComputeStorageInfo(devNode, (JSONObject)extFeaturesObject));
    }

    private void setComputeStorageInfo(DevNode devNode, JSONObject extFeaturesObject) {
        ComputeStorageDevNode csDevNode = devNode.getComputeStorageDevNode() == null ? new ComputeStorageDevNode() : devNode.getComputeStorageDevNode();
        String deviceId = extFeaturesObject.getStringOrDefault("deviceId", "");
        csDevNode.setComputeStorageFcvDeviceId(deviceId);
        devNode.setDeviceSerialNumber(deviceId);
        csDevNode.setOpenapiUser(devNode.getLoginUser());
        csDevNode.setFcvIp(devNode.getIp());
        devNode.setComputeStorageDevNode(csDevNode);
    }

    private void makeErrorTaskResult(DevNode devNode, TaskResult ret) {
        String errorDes;
        if (ret.getErrorId().equals(FCE_LOGIN_ROLE_NOT_OPENAPI)) {
            errorDes = ResourceUtil.getString((String)FCE_LOGIN_ROLE_NOT_OPENAPI);
            ret.setErrorLocaleDescription(errorDes);
            ret.setResult(TaskResult.Result.FAILED);
        }
        errorDes = ResourceUtil.getStringWithParams((String)DEVICE_CANNOT_CONNECT, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeQueryCluserInfoFailResult(DevNode devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)CLUSTER_INFO_QUERY_FAIL, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    public INodeSupport getNodeSupport() {
        return this.nodeSupport;
    }

    public void setNodeSupport(INodeSupport nodeSupport) {
        this.nodeSupport = nodeSupport;
    }
}

