/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.host;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.utils.StarterType;
import com.huawei.ism.tool.devicemanager.utils.WwnUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class LinuxHostServiceImpl
extends HostService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LinuxHostServiceImpl.class);
    private static final String LINUX_FC_COMMAND = "cat /sys/class/fc_host/host*/port*name";
    private static final String LINUX_FC_KEY_WORD = "";
    private static final String LINUX_FC_REG_EXP = "[0-9|a-f]{16}";
    private static final String LINUX_ISCSI_COMMAND = "cat /etc/iscsi/initiatorname.iscsi";
    private static final String LINUX_NVME_COMMAND = "cat /etc/nvme/hostnqn";
    private static final String LINUX_ISCSI_KEY_WORD = "InitiatorName";
    private static final String LINUX_ISCSI_REG_EXP = "=(iqn.\\d{4}-\\d{2}.*)";
    private static final String LINUX_NVME_NOT_FOUND = "No such file or directory";
    private static final String LINUX_IB_COMMAND = "ibstat";
    private static final String LINUX_IB_KEY_WORD = "Port GUID:";

    @Override
    public Launcher queryWwn(ICliConnection con, DevNode devNode) {
        HashMap<StarterType, List<String>> hashMap = new HashMap<StarterType, List<String>>();
        WwnUtil.buildWwnData(hashMap, StarterType.FC, LINUX_FC_COMMAND, LINUX_FC_KEY_WORD, LINUX_FC_REG_EXP);
        WwnUtil.buildWwnData(hashMap, StarterType.IB, LINUX_IB_COMMAND, LINUX_IB_KEY_WORD, LINUX_FC_REG_EXP);
        Launcher launcher = new Launcher();
        StringBuffer resultCollect = new StringBuffer();
        try {
            WwnUtil.getAluaWwn(con, hashMap, launcher, resultCollect);
            this.getLinuxIscsiWwn(con, launcher, resultCollect);
            this.getLinuxNVMeWwn(con, launcher, resultCollect);
        }
        catch (Exception e) {
            launcher.getOtherDataMap().put("queryWwnSuccess", false);
            LOGGER.error("Get aix wwn error:" + e);
        }
        WwnUtil.setResult2Launcher(launcher, resultCollect);
        return launcher;
    }

    private void getLinuxNVMeWwn(ICliConnection con, Launcher launcher, StringBuffer resultCollect) {
        String result = null;
        try {
            result = con.execCmd(LINUX_NVME_COMMAND);
            resultCollect.append(result + "\n");
            if (WwnUtil.checkResultFailed(result, StarterType.NVME)) {
                WwnUtil.setFailedInLauncher(launcher);
                return;
            }
        }
        catch (ToolException e) {
            LOGGER.error("send linux NVME command faild:cat /etc/iscsi/initiatorname.iscsi", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
            return;
        }
        result = Normalizer.normalize(result, Normalizer.Form.NFKC);
        if (result.contains(LINUX_NVME_NOT_FOUND)) {
            LOGGER.info("The host does not have nvme init");
            return;
        }
        String[] splitResult = result.split("\n");
        for (int i = 1; i < splitResult.length; ++i) {
            if (StringUtils.isNULLStr((String)splitResult[i])) continue;
            String wwn = splitResult[i].trim().toUpperCase(Locale.ENGLISH);
            launcher.getNVMEWwns().add(wwn);
            LOGGER.info("get linux NVME wwn sussess:{}", (Object)wwn);
        }
    }

    private void getLinuxIscsiWwn(ICliConnection con, Launcher launcher, StringBuffer resultCollect) {
        String result = null;
        String messageHeader = null;
        try {
            result = con.execCmd(LINUX_ISCSI_COMMAND);
            resultCollect.append(result + "\n");
            messageHeader = con.execCmd("\n");
            if (WwnUtil.checkResultFailed(result, StarterType.ISCSI)) {
                WwnUtil.setFailedInLauncher(launcher);
                return;
            }
        }
        catch (ToolException e) {
            LOGGER.error("send linux iscsi command faild:cat /etc/iscsi/initiatorname.iscsi", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
            return;
        }
        result = Normalizer.normalize(result, Normalizer.Form.NFKC);
        String[] splitResult = result.split("\n");
        String cmdHeader = messageHeader.split("\n")[0].trim();
        for (String iscsiResult : splitResult) {
            if (!iscsiResult.contains(LINUX_ISCSI_KEY_WORD)) continue;
            Pattern p = Pattern.compile(LINUX_ISCSI_REG_EXP, 2);
            Matcher m = p.matcher(iscsiResult);
            while (m.find()) {
                String wwn = m.group(1);
                if (wwn.contains(cmdHeader)) {
                    String temp = wwn.split(cmdHeader)[0];
                    wwn = temp.length() > 1 ? temp : wwn;
                }
                launcher.getiSCSIWwns().add(wwn);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("get linux iscsi wwn sussess:" + wwn);
            }
        }
    }
}

