/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.host;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.utils.WwnUtil;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ToolUtils;
import java.text.Normalizer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class WindowsHostServiceImpl
extends HostService {
    private static final String PORT_WWN = "PortWWN";
    private static final String ISCSI_NODE_NAME = "iSCSINodeName";
    private static final String MSFC_FIBRE_PORT_HBA_ATTRIBUTES = "MSFC_FibrePortHBAAttributes";
    private static final String I_SCSI = "iSCSI";
    private static final String FIBRE_CHANNEL = "Fibre Channel";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(WmicConnection.class);
    private static final String WIN_2008 = "2008";

    @Override
    public Launcher queryWwn(final ICliConnection con, final DevNode devNode) {
        final Launcher launcher = new Launcher();
        Callable<Launcher> task = new Callable<Launcher>(){

            @Override
            public Launcher call() throws Exception {
                if (ToolUtils.isPaconnected((DevNode)devNode)) {
                    return WindowsHostServiceImpl.this.queryWinWwn(con, devNode, launcher);
                }
                WwnUtil.setFailedInLauncher(launcher);
                return launcher;
            }
        };
        Future taskFuture = ThreadPoolManager.getInstance().submit((Callable)task);
        Launcher result = new Launcher();
        result.getOtherDataMap().put("taskFuture", taskFuture);
        LOGGER.info("windows Launcher:{}", (Object)JSON.toJSONString((Object)result));
        try {
            result = (Launcher)taskFuture.get();
            result.getOtherDataMap().put("taskFuture", taskFuture);
            LOGGER.info("windows Launcher:{}", (Object)JSON.toJSONString((Object)result));
            LOGGER.info("exec wwn over:{}", (Object)StringUtils.getCleanMessage((String)devNode.getIp()));
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("exec error", (Throwable)e);
            return result;
        }
        return result;
    }

    private Launcher queryWinWwn(ICliConnection con, DevNode devNode, Launcher launcher) {
        DeviceType dt = devNode.getDeviceType();
        if (dt == null) {
            LOGGER.error("device type is null");
            WwnUtil.setFailedInLauncher(launcher);
            return launcher;
        }
        StringBuffer cliBuilder = new StringBuffer();
        if (dt.toString().contains(WIN_2008)) {
            this.query2008WWN(con, launcher, cliBuilder);
        } else {
            this.query2012UpperWWN(con, launcher, cliBuilder);
        }
        WwnUtil.setResult2Launcher(launcher, cliBuilder);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("launcher :" + launcher + " devKey:" + devNode.getDevKey());
        }
        return launcher;
    }

    private void query2012UpperWWN(ICliConnection wCon, Launcher launcher, StringBuffer cliBuilder) {
        try {
            String cliResult = wCon.execCmdWithTimout("powershell Get-InitiatorPort", 240);
            LOGGER.info(String.format(Locale.ENGLISH, "cliResult :%s", cliResult));
            cliBuilder.append(cliResult + "\n");
            cliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
            this.checkCmdResult(cliResult);
            this.checkCmdNotSupport("Get-Initiatorport", cliResult);
            String[] lines = cliResult.split("\\n");
            List<String> fcList = launcher.getFcWwns();
            List<String> iscsiList = launcher.getiSCSIWwns();
            for (String line : lines) {
                String[] lineWord = line.split("\\s+");
                if (lineWord.length < 3) continue;
                if (line.contains(FIBRE_CHANNEL)) {
                    fcList.add(lineWord[2]);
                }
                if (!line.contains(I_SCSI)) continue;
                iscsiList.add(lineWord[1]);
            }
            WwnUtil.setSuccessInLauncher(launcher);
        }
        catch (RuntimeException e) {
            LOGGER.error("exec query wwn error.", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
        }
        catch (Exception e) {
            LOGGER.error("exec query wwn error.", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
        }
    }

    private void query2008WWN(ICliConnection con, Launcher launcher, StringBuffer cliBuilder) {
        try {
            List<String> fcList = launcher.getFcWwns();
            List<String> iscsiList = launcher.getiSCSIWwns();
            String cliResult = con.execCmdWithTimout("winrm e wmi/root/wmi/MSFC_FibrePortHBAAttributes", 120);
            cliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
            cliBuilder.append(cliResult + "\n");
            this.checkCmdResult(cliResult);
            this.checkCmdNotSupport("winrm", cliResult);
            LOGGER.info("query 2008 fc wwn success.");
            this.append2008FcWWN(cliResult, fcList);
            String cliIscsiResult = con.execCmdWithTimout("powershell Get-WmiObject -Namespace root\\wmi -Class MSiSCSIInitiator_MethodClass", 120);
            cliIscsiResult = Normalizer.normalize(cliIscsiResult, Normalizer.Form.NFKC);
            cliBuilder.append(cliIscsiResult + "\n");
            this.checkCmdResult(cliIscsiResult);
            this.checkCmdNotSupportIscsi(ISCSI_NODE_NAME, cliIscsiResult);
            LOGGER.info("query 2008 iscsi wwn success.");
            this.appendSinelg2008IscsiWwn(cliIscsiResult, iscsiList);
            WwnUtil.setSuccessInLauncher(launcher);
        }
        catch (RuntimeException e) {
            LOGGER.error("exec query wwn error.", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
        }
        catch (Exception e) {
            LOGGER.error("exec query wwn error.", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
        }
    }

    private void checkCmdResult(String cliResult) {
        if (ToolUtils.isCmdExecFailed((String)cliResult)) {
            throw new NullPointerException("cmd execute failed.");
        }
    }

    private void checkCmdNotSupport(String cmdPrefix, String cmdResult) {
        if (cmdResult.contains("'" + cmdPrefix + "'")) {
            throw new NullPointerException("cmd execute failed.");
        }
    }

    private void checkCmdNotSupportIscsi(String string, String cmdResult) {
        if (!cmdResult.contains(string)) {
            throw new NullPointerException("cmd execute failed.");
        }
    }

    private void append2008FcWWN(String cliResult, List<String> fcList) {
        String[] wwnsLine;
        for (String wwnLine : wwnsLine = cliResult.split(MSFC_FIBRE_PORT_HBA_ATTRIBUTES)) {
            this.appendSinelg2008FcWwn(fcList, wwnLine);
        }
    }

    public void appendSinelg2008FcWwn(List<String> fcList, String wwnLine) {
        String[] lines;
        for (String line : lines = wwnLine.split("\\n")) {
            if (!line.contains(PORT_WWN)) continue;
            String[] wwn = line.split("=");
            if (wwn.length <= 1) break;
            StringBuilder wwnInfo = this.getWwnInfo(wwn);
            fcList.add(wwnInfo.toString());
            break;
        }
    }

    public void appendSinelg2008IscsiWwn(String wwnLine, List<String> iscsiList) {
        String[] lines;
        for (String line : lines = wwnLine.split("\\n")) {
            if (!line.contains(ISCSI_NODE_NAME)) continue;
            String[] wwn = line.split(" : ");
            if (wwn.length <= 1) break;
            String wwnInfo = wwn[1].trim();
            iscsiList.add(wwnInfo);
            break;
        }
    }

    private StringBuilder getWwnInfo(String[] wwn) {
        String[] wwns = wwn[1].trim().split(",");
        StringBuilder wwnInfo = new StringBuilder();
        for (String str : wwns) {
            String hexStr = Integer.toHexString(Integer.parseInt(str.trim()));
            if (hexStr.length() == 1) {
                wwnInfo.append('0');
            }
            wwnInfo.append(hexStr);
        }
        return wwnInfo;
    }
}

