/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.pub;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevInfoXlsParser {
    private static final Logger log = LoggerFactory.getLogger(DevInfoXlsParser.class);
    private static final String AUTHENTIC = "Yes";
    private static final String SSH_FORWARD = "Ssh ForWard";
    private static final String SOCKS5_PROXY = "Socks5 Proxy";
    private static final int DEV_SHEET_INDEX = 0;
    private static final int SOCKS5_PROXY_SHEET_INDEX = 1;
    private static final int SSH_FORWARD_SHEET_INDEX = 2;
    private static final int ROWS_TWO = 2;
    private static final int ROWS_TH = 3;
    private static final int ROWS_FR = 4;
    private static final int ROWS_FF = 5;
    private static final int ROWS_SI = 6;
    private static final int ROWS_SE = 7;
    private static final int ROWS_EI = 8;
    private static final int ROWS_NI = 9;
    private static final int ROWS_TE = 10;
    private static final int ROWS_ELE = 11;
    private static final int ROWS_TWELVE = 12;
    private static final String DPA = "DPA";
    private static final String FUSION_CUBE = "FusionCube";
    private static final String A3000 = "A3000";
    private static final int DEVICE_MANAGER_USERNAME_INDEX = 13;
    private static final int DEVICE_MANAGER_PWD_INDEX = 14;
    private List<String> invalidIP = new ArrayList<String>();
    private Map<DevNode, String> deviceImportResult = null;
    private Map<ItDeviceType, List<String>> supportedTyes = null;
    private int supportDeviceInfoCounter = 0;
    public static final String HOST_NAME_EN = "host";
    public static final String HOST_NAME_CH = "\u4e3b\u673a";
    public static final String DATABASE_NAME_EN = "DB";
    public static final String DATABASE_NAME_CH = "\u6570\u636e\u5e93";
    public static final String SWITCH_NAME_EN = "Switch";
    public static final String SWITCH_NAME_CH = "\u4ea4\u6362\u673a";
    public static final String STORAGE_NAME_EN = "Storage";
    public static final String STORAGE_NAME_CH = "\u5b58\u50a8";
    public static final String COMPUTE_STORAGE_NAME_EN = "COMPUTE_STORAGE";
    public static final String COMPUTE_STORAGE_NAME_CH = "\u8ba1\u7b97\u578b\u5b58\u50a8";
    public static final String SCALE_OUT_NAME_CH = "\u5206\u5e03\u5f0f\u5b58\u50a8";
    public static final String SCALE_OUT_NAME_EN = "Scale-Out Storage";
    public static final String T3000 = "T3000";
    public static final String MULTI_PATH_ZH = "\u591a\u8def\u5f84";
    public static final String MULTIPATH_EN = "UltraPath";
    public static final String FUIONSTOR_EXP_NEW_NODE_ZH = "\u65b0\u6269\u8282\u70b9";
    public static final String FUIONSTOR_EXP_NEW_NODE_EN = "New_Nodes";
    public static final String TEMPLATE_FILE_PATH = "/config/templatefile/";
    public static final String NEW_TEMPLATE_FILE_NAME_ZH = "DeviceList_Template_New_zh.xls";
    public static final String NEW_TEMPLATE_FILE_NAME_EN = "DeviceList_Template_New_en.xls";

    public DevInfoXlsParser() {
        this.deviceImportResult = new HashMap<DevNode, String>();
    }

    public static InputStream getTemplateFile() {
        Locale locale = ApplicationContext.getInstance().getCurrentLanguage();
        String templateFileName = NEW_TEMPLATE_FILE_NAME_EN;
        if (Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            templateFileName = NEW_TEMPLATE_FILE_NAME_ZH;
        }
        return DevInfoXlsParser.class.getResourceAsStream(TEMPLATE_FILE_PATH + templateFileName);
    }

    public DevInfoXlsParser(Map<DevNode, String> deviceImportResult) {
        this.deviceImportResult = deviceImportResult;
    }

    public DevInfoXlsParser(Map<DevNode, String> deviceImportResult, Map<ItDeviceType, List<String>> supportedTyeMap) {
        this(deviceImportResult);
        this.supportedTyes = supportedTyeMap;
        this.supportDeviceInfoCounter = 0;
    }

    public Collection<DevNode> getFile(File selectfile) throws ToolException {
        List<DevNode> devs;
        try {
            devs = this.parseXls2DevNode(selectfile);
        }
        catch (ToolException e) {
            log.error("parseXls2Tasks error.");
            throw e;
        }
        return devs;
    }

    private List<DevNode> parseXls2DevNode(File xlsFile) throws ToolException {
        log.info("start resolve xls file  {} .", (Object)xlsFile.getName());
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        try (InputStream fis = Files.newInputStream(xlsFile.toPath(), new OpenOption[0]);
             HSSFWorkbook workbook = new HSSFWorkbook(fis);){
            HSSFSheet devInfoSheet = workbook.getSheetAt(0);
            int rows = devInfoSheet.getLastRowNum() + 1;
            for (int startLine = 1; startLine < rows; ++startLine) {
                DevNode devNode = this.parseLine((Sheet)devInfoSheet, startLine);
                devNodes.add(devNode);
            }
        }
        catch (Exception e) {
            log.error("parseXls2Tasks error.", (Throwable)e);
            throw new ToolException(null);
        }
        return devNodes;
    }

    private DevNode parseLine(Sheet devInfoSheet, int lineNum) {
        Row row = devInfoSheet.getRow(lineNum);
        short column = row.getLastCellNum();
        String devIp = POIUtils.getStringCellValue((Cell)row.getCell(2));
        if (!NetUtil.isValidIP((String)devIp)) {
            this.invalidIP.add(devIp);
        }
        DevNode node = new DevNode();
        node.setItDeviceType(this.fixHostNameZh2En(POIUtils.getStringCellValue((Cell)row.getCell(0))));
        DevInfoXlsParser.setItDeviceType(row, node);
        node.setIp(devIp);
        node.setPort(DevInfoXlsParser.getPort(row));
        this.setLoginUser(row, node);
        DevInfoXlsParser.setRootPwdInfo(row, column, node);
        node.setDbName(POIUtils.getStringCellValue((Cell)row.getCell(7)));
        node.setDeveloperPwd(POIUtils.getStringCellValue((Cell)row.getCell(8)));
        DevInfoXlsParser.setSudoMode(row, column, node.getLoginUser().getUserName(), node);
        node.setCertCheckSelectFlag(DevInfoXlsParser.isVerifyCertificate(row));
        return node;
    }

    private void setLoginUser(Row row, DevNode node) {
        if (!node.isFusionCube()) {
            node.setLoginUser(this.getLoginUserInfo(row));
            return;
        }
        node.setFusionCubeLoginUser(this.getLoginUserInfo(row));
        node.setFusionCubeSSHPort(node.getPort());
        node.setLoginUser(new User(POIUtils.getStringCellValue((Cell)row.getCell(13)), POIUtils.getStringCellValue((Cell)row.getCell(14))));
    }

    private static boolean isVerifyCertificate(Row row) {
        String isVerifyCertificateStr = POIUtils.getStringCellValue((Cell)row.getCell(6));
        return !StringUtils.isNULLStr((String)isVerifyCertificateStr) && isVerifyCertificateStr.equals(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.yes"));
    }

    private static int getPort(Row row) {
        return StringUtils.str2Int((String)(POIUtils.getStringCellValue((Cell)row.getCell(5)).equals("") ? "-1" : POIUtils.getStringCellValue((Cell)row.getCell(5))));
    }

    private static void setItDeviceType(Row row, DevNode node) {
        String itDeviceTypel2 = POIUtils.getStringCellValue((Cell)row.getCell(1));
        if (itDeviceTypel2.startsWith("Oracle")) {
            node.setDevTypeLevel2(DeviceType.valueOf((String)itDeviceTypel2.split("/")[0]));
            node.setUseJdbc(itDeviceTypel2.split("/")[1].equalsIgnoreCase("JDBC"));
        } else {
            node.setDevTypeLevel2(DeviceType.valueOf((String)itDeviceTypel2));
        }
    }

    private User getLoginUserInfo(Row row) {
        String username = POIUtils.getStringCellValue((Cell)row.getCell(3));
        String password = POIUtils.getStringCellValue((Cell)row.getCell(4));
        return new User(username, password);
    }

    private static void setRootPwdInfo(Row row, int column, DevNode node) {
        String pwd = "";
        if (column > 11) {
            pwd = POIUtils.getStringCellValue((Cell)row.getCell(11));
        }
        if (!StringUtils.isNULLStr((String)pwd)) {
            node.setAdminUser(new com.huawei.ism.tool.framework.pubservice.entity.User("root", Base64EncodeUtils.encode((String)pwd)));
            node.setRootUser(new User("root", Base64EncodeUtils.encode((String)pwd)));
        }
    }

    private static void setSudoMode(Row row, int column, String username, DevNode node) {
        boolean isSudo = false;
        if (column > 12) {
            isSudo = !"root".equals(username) && "yes".equalsIgnoreCase(POIUtils.getStringCellValue((Cell)row.getCell(12)));
        }
        node.setSudoGrab(isSudo);
    }

    private ItDeviceType fixHostNameZh2En(String hostName) {
        HashMap<String, ItDeviceType> itDeviceTypeMap = new HashMap<String, ItDeviceType>();
        this.initItDeviceType(DPA, DPA, ItDeviceType.DPA, itDeviceTypeMap);
        this.initItDeviceType(HOST_NAME_CH, HOST_NAME_EN, ItDeviceType.Host, itDeviceTypeMap);
        this.initItDeviceType(DATABASE_NAME_CH, DATABASE_NAME_EN, ItDeviceType.Database, itDeviceTypeMap);
        this.initItDeviceType(SWITCH_NAME_CH, SWITCH_NAME_EN, ItDeviceType.Switch, itDeviceTypeMap);
        this.initItDeviceType(STORAGE_NAME_CH, STORAGE_NAME_EN, ItDeviceType.Storage, itDeviceTypeMap);
        this.initItDeviceType(COMPUTE_STORAGE_NAME_CH, COMPUTE_STORAGE_NAME_EN, ItDeviceType.COMPUTE_STORAGE, itDeviceTypeMap);
        this.initItDeviceType(MULTI_PATH_ZH, MULTIPATH_EN, ItDeviceType.UltraPath, itDeviceTypeMap);
        this.initItDeviceType(FUIONSTOR_EXP_NEW_NODE_ZH, FUIONSTOR_EXP_NEW_NODE_EN, ItDeviceType.FUIONSTOR_EXP_NEW_NODE, itDeviceTypeMap);
        itDeviceTypeMap.put(T3000, ItDeviceType.T3000);
        this.initItDeviceType(SCALE_OUT_NAME_CH, SCALE_OUT_NAME_EN, ItDeviceType.DStorage, itDeviceTypeMap);
        itDeviceTypeMap.put(FUSION_CUBE.toUpperCase(Locale.ENGLISH), ItDeviceType.FUSIONCUBE);
        itDeviceTypeMap.put(FUSION_CUBE, ItDeviceType.FUSIONCUBE);
        itDeviceTypeMap.put(A3000, ItDeviceType.A3000);
        return itDeviceTypeMap.getOrDefault(hostName.toUpperCase(Locale.ENGLISH), null);
    }

    private void initItDeviceType(String chType, String enType, ItDeviceType targetType, Map<String, ItDeviceType> typeMap) {
        typeMap.put(chType, targetType);
        typeMap.put(enType, targetType);
        typeMap.put(enType.toLowerCase(Locale.ENGLISH), targetType);
        typeMap.put(enType.toUpperCase(Locale.ENGLISH), targetType);
    }

    public List<String> getInvalidIP() {
        return this.invalidIP;
    }

    public Collection<DevNode> parseFile(File selectfile) throws ToolException {
        List<DevNode> devs = null;
        try {
            devs = this.parseXlsDevNode(selectfile);
            if (null != this.supportedTyes) {
                this.checkNoSupportDev(devs);
            }
            this.checkDevInfo(devs);
            return devs;
        }
        catch (ToolException e) {
            log.error("parseXlsTasks error.");
            throw e;
        }
    }

    private void checkDevInfo(Collection<DevNode> devs) {
        devs.stream().filter(DevNode::isFusionCube).filter(devNode -> Objects.isNull(devNode.getRootUser())).forEach(devNode -> this.deviceImportResult.put((DevNode)devNode, ResourceUtil.getString((String)"devicemanager.layout.device.add.device.miss.root.cube")));
    }

    private void checkNoSupportDev(Collection<DevNode> devNodes) {
        for (DevNode device : devNodes) {
            boolean isSupport = false;
            for (Map.Entry<ItDeviceType, List<String>> entry : this.supportedTyes.entrySet()) {
                if (!entry.getKey().equals((Object)device.getItDeviceType()) || device.getDevTypeLevel2() != null && entry.getValue() != null && !entry.getValue().contains(device.getDevTypeLevel2().toString())) continue;
                isSupport = true;
                break;
            }
            if (!isSupport) {
                this.deviceImportResult.put(device, ResourceUtil.getStringWithParams((String)"devicemanger.import.devtype.not.support.tip", (Object[])new Object[]{device.getIp(), device.getItDeviceType(), device.getDevTypeLevel2()}));
                continue;
            }
            ++this.supportDeviceInfoCounter;
        }
    }

    private List<DevNode> parseXlsDevNode(File xlsFile) throws ToolException {
        log.info("start parse dev from {} .", (Object)xlsFile.getName());
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        ArrayList<String> socks5Names = new ArrayList<String>();
        ArrayList<String> sshNames = new ArrayList<String>();
        try (InputStream fis = Files.newInputStream(FilePathUtils.checkFile((File)xlsFile).toPath(), new OpenOption[0]);
             Workbook workbook = WorkbookFactory.create((InputStream)fis);){
            Sheet devInfoSheet = workbook.getSheetAt(0);
            Sheet socks5InfoSheet = workbook.getSheetAt(1);
            Sheet sshInfoSheet = workbook.getSheetAt(2);
            Map<String, Socks5Proxy> socks5Map = this.parseSocks5Line(socks5InfoSheet, socks5Names);
            SettingService.setSocks5MapCollocate(socks5Map);
            KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap = this.parseSshLine(sshInfoSheet, sshNames);
            SettingService.setSshMapCollocate(sshMap);
            if (this.judgeRepeatNames(socks5Names, sshNames)) {
                throw new ToolException(null);
            }
            int maxLineIndex = devInfoSheet.getLastRowNum() + 1;
            for (int startLine = 2; startLine < maxLineIndex; ++startLine) {
                DevNode devNode = this.parseLineToolkit(devInfoSheet, startLine, socks5Map, sshMap);
                if (devNode == null) continue;
                devNodes.add(devNode);
            }
        }
        catch (Exception e) {
            log.error("parseXls2Tasks error.", (Throwable)e);
            throw new ToolException(null);
        }
        return devNodes;
    }

    private DevNode parseLineToolkit(Sheet devInfoSheet, int lineNum, Map<String, Socks5Proxy> socks5Map, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap) {
        String jumpType = "";
        Row row = devInfoSheet.getRow(lineNum);
        if (null == row) {
            return null;
        }
        String ip = POIUtils.getStringCellValue((Cell)row.getCell(2));
        String subType = POIUtils.getStringCellValue((Cell)row.getCell(1));
        String devType = POIUtils.getStringCellValue((Cell)row.getCell(0));
        if (StringUtils.isNULLStr((String)devType) && StringUtils.isNULLStr((String)ip) && StringUtils.isNULLStr((String)subType)) {
            return null;
        }
        if (StringUtils.isNULLStr((String)ip)) {
            return this.parseLine(devInfoSheet, lineNum);
        }
        short column = row.getLastCellNum();
        if (column <= 10) {
            return this.parseLine(devInfoSheet, lineNum);
        }
        jumpType = POIUtils.getStringCellValue((Cell)row.getCell(9));
        if (null == jumpType || "".equals(jumpType) || "None".equals(jumpType)) {
            return this.parseLine(devInfoSheet, lineNum);
        }
        return this.bindJumpInfoAndBuildDevNode(socks5Map, sshMap, devInfoSheet, jumpType, POIUtils.getStringCellValue((Cell)row.getCell(10)), lineNum);
    }

    private DevNode bindJumpInfoAndBuildDevNode(Map<String, Socks5Proxy> socks5Map, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap, Sheet devInfoSheet, String jumpTerm, String jumpName, int lineNum) {
        DevNode node = null;
        if (SOCKS5_PROXY.equals(jumpTerm)) {
            node = this.parseLine(devInfoSheet, lineNum);
            if (socks5Map.containsKey(jumpName)) {
                node.setSocks5Proxy(socks5Map.get(jumpName));
            } else {
                this.deviceImportResult.put(node, ResourceUtil.getString((String)"toolbox.proy.errormsg"));
            }
            return node;
        }
        if (SSH_FORWARD.equals(jumpTerm)) {
            node = this.parseLine(devInfoSheet, lineNum);
            if (sshMap.containsKey((Object)jumpName)) {
                node.setSshName(jumpName);
                node.setSshForwardList((List)sshMap.get((Object)jumpName));
                return node;
            }
            this.deviceImportResult.put(node, ResourceUtil.getString((String)"toolbox.proy.errormsg"));
            return null;
        }
        return node;
    }

    private Map<String, Socks5Proxy> parseSocks5Line(Sheet socks5InfoSheet, List<String> socks5NameList) {
        HashMap<String, Socks5Proxy> socks5Map = new HashMap<String, Socks5Proxy>();
        int startLine = 2;
        int maxlineIndex = socks5InfoSheet.getLastRowNum() + 1;
        while (startLine < maxlineIndex) {
            Row row = socks5InfoSheet.getRow(startLine);
            String socks5IP = POIUtils.getStringCellValue((Cell)row.getCell(1));
            String socks5Name = POIUtils.getStringCellValue((Cell)row.getCell(0));
            String socks5Port = POIUtils.getStringCellValue((Cell)row.getCell(2));
            String socks5Authentic = POIUtils.getStringCellValue((Cell)row.getCell(3));
            String socks5UserName = POIUtils.getStringCellValue((Cell)row.getCell(4));
            String socks5UserPwd = POIUtils.getStringCellValue((Cell)row.getCell(5));
            if (!StringUtils.hasMatchStr((String)socks5Name, (String)"^[a-zA-Z_][0-9a-zA-Z_-]*")) {
                ++startLine;
                continue;
            }
            if (!StringUtils.isPort((int)StringUtils.str2Int((String)socks5Port))) {
                ++startLine;
                continue;
            }
            socks5NameList.add(socks5Name);
            Socks5Proxy socks5 = new Socks5Proxy();
            socks5.setName(socks5Name);
            socks5.setServerIp(socks5IP);
            socks5.setPort(socks5Port);
            if (AUTHENTIC.equals(socks5Authentic)) {
                socks5.setAuthentic(true);
                socks5.setUser(socks5UserName);
                socks5.setPass(socks5UserPwd);
            } else {
                socks5.setAuthentic(false);
            }
            socks5Map.put(socks5Name, socks5);
            ++startLine;
        }
        List<Socks5Proxy> socks5List = SettingService.getProxies();
        for (Socks5Proxy socks5Proxy : socks5List) {
            String name = socks5Proxy.getName();
            if (socks5Map.containsKey(name)) {
                Socks5Proxy socks5 = (Socks5Proxy)socks5Map.get(name);
                if (socks5.getServerIp().equals(socks5Proxy.getServerIp()) && socks5.getPort().equals(socks5Proxy.getPort())) continue;
                name = name + "_" + new Date().getTime();
            }
            socks5Map.put(name, socks5Proxy);
        }
        return socks5Map;
    }

    public KeyOrderedHashMap<String, List<MultiRouteNode>> parseSshLine(Sheet sshInfoSheet, List<String> sshNameList) {
        KeyOrderedHashMap sshMap = new KeyOrderedHashMap();
        int maxLineIndex = sshInfoSheet.getLastRowNum() + 1;
        List ranges = sshInfoSheet.getMergedRegions();
        int startLine = 1;
        while (startLine < maxLineIndex) {
            ArrayList<MultiRouteNode> listMu = new ArrayList<MultiRouteNode>();
            String name = POIUtils.getStringCellValue((Cell)sshInfoSheet.getRow(startLine).getCell(0)).trim();
            if (1 == startLine || StringUtils.isNULLStr((String)name)) {
                ++startLine;
                continue;
            }
            if (!StringUtils.hasMatchStr((String)name, (String)"^[a-zA-Z_][0-9a-zA-Z_-]*")) {
                ++startLine;
                continue;
            }
            sshNameList.add(name);
            startLine = this.getMergedCells(ranges, startLine, listMu, sshInfoSheet);
            if (!listMu.isEmpty()) {
                sshMap.put((Object)name, listMu);
                continue;
            }
            MultiRouteNode multiRouteNode = this.getNewMu(sshInfoSheet, startLine);
            listMu.add(multiRouteNode);
            sshMap.put((Object)name, listMu);
            ++startLine;
        }
        KeyOrderedHashMap<String, List<MultiRouteNode>> sshM = SettingService.getSshForwards();
        long i = new Date().getTime();
        for (String sshName : sshM.keySet()) {
            StringBuffer sb = new StringBuffer(sshName);
            if (sshMap.containsKey((Object)sshName)) {
                sb.append(95L + i++);
            }
            sshMap.put((Object)sb.toString(), sshM.get((Object)sshName));
        }
        return sshMap;
    }

    private int getMergedCells(List<CellRangeAddress> ranges, int startLine, List<MultiRouteNode> listMu, Sheet sshInfoSheet) {
        int startLineCopy = startLine;
        for (CellRangeAddress space : ranges) {
            int startUniteLine = space.getFirstRow();
            int endUniteLine = space.getLastRow();
            if (0 == endUniteLine || startLineCopy < startUniteLine || startLineCopy > endUniteLine) continue;
            while (startUniteLine <= endUniteLine) {
                MultiRouteNode multiRouteNode = this.getNewMu(sshInfoSheet, startLineCopy);
                listMu.add(multiRouteNode);
                startLineCopy = ++startUniteLine;
            }
        }
        return startLineCopy;
    }

    private MultiRouteNode getNewMu(Sheet sshInfoSheet, int line) {
        Row row = sshInfoSheet.getRow(line);
        String host = POIUtils.getStringCellValue((Cell)row.getCell(1));
        String uName = POIUtils.getStringCellValue((Cell)row.getCell(2));
        String pwd = POIUtils.getStringCellValue((Cell)row.getCell(3));
        int port = StringUtils.str2Int((String)POIUtils.getStringCellValue((Cell)row.getCell(4)));
        return new MultiRouteNode(host, port, uName, pwd);
    }

    private boolean judgeRepeatNames(List<String> socks5Names, List<String> sshNameList) {
        return sshNameList.stream().distinct().count() < (long)sshNameList.size() || socks5Names.stream().distinct().count() < (long)socks5Names.size();
    }

    public int getSupportDeviceInfoCounter() {
        return this.supportDeviceInfoCounter;
    }
}

