/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.context;

import com.huawei.ism.tool.devicemanager.ui.dialog.ScenePreparedMainJDialog;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.service.ISceneCfmCheckService;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DeviceSceneContext
extends AbstractContext {
    public static final String PACKAGE_DIR_STRING = new File(ApplicationContext.getInstance().getWorkPath()) + File.separator + "packages" + File.separator + "scene" + File.separator + "products";
    private static final DeviceSceneContext INSTANCE = new DeviceSceneContext();
    private boolean support = true;
    private List<String> unSupportDevs = new ArrayList<String>();
    private ScenePreparedMainJDialog scenePreparedMainJDialog;
    private String currentAddDevIp;
    private List<String> unSupportHighEndDevs = new ArrayList<String>();
    private String currentAddDevSN;
    private String currentAddDevType;
    private boolean highEndDeviceSupport = true;
    private JSONObject sceneJson;
    private List<String> toolList;
    private String toolScene;
    private DevNode curSvpNode;
    private boolean singleDev = false;
    private List<String> unSupportDomainUserDevs = new ArrayList<String>();
    private static Map<String, List<ISceneCfmCheckService>> confirmCheckSvice = new ConcurrentHashMap<String, List<ISceneCfmCheckService>>();

    private DeviceSceneContext() {
    }

    public static DeviceSceneContext getInstance() {
        return INSTANCE;
    }

    public String getCurrentAddDevIp() {
        return this.currentAddDevIp;
    }

    public void addSceneDevConfirmService(String subSCeneId, ISceneCfmCheckService checkService) {
        List<ISceneCfmCheckService> serviceList = confirmCheckSvice.get(subSCeneId);
        if (serviceList == null) {
            serviceList = new ArrayList<ISceneCfmCheckService>();
            confirmCheckSvice.put(subSCeneId, serviceList);
        }
        serviceList.add(checkService);
    }

    public List<ISceneCfmCheckService> getSceneCheckServices(String subSCeneId) {
        return confirmCheckSvice.get(subSCeneId);
    }

    public void clearCurrentDev() {
        this.currentAddDevIp = null;
        this.currentAddDevSN = null;
        this.currentAddDevType = null;
    }

    public void setCurrentAddDevIp(String currentAddDevIp) {
        this.currentAddDevIp = currentAddDevIp;
    }

    public String getCurrentAddDevSN() {
        return this.currentAddDevSN;
    }

    public void setCurrentAddDevSN(String currentAddDevSN) {
        this.currentAddDevSN = currentAddDevSN;
    }

    public String getCurrentAddDevType() {
        return this.currentAddDevType;
    }

    public void setCurrentAddDevType(String currentAddDevType) {
        this.currentAddDevType = currentAddDevType;
    }

    public ScenePreparedMainJDialog getScenePreparedMainJDialog() {
        return this.scenePreparedMainJDialog;
    }

    public void setScenePreparedMainJDialog(ScenePreparedMainJDialog scenePreparedMainJDialog) {
        this.scenePreparedMainJDialog = scenePreparedMainJDialog;
    }

    public boolean isSupport() {
        return this.support;
    }

    public void setSupport(boolean support) {
        this.support = support;
    }

    public List<String> getUnSupportDevs() {
        return this.unSupportDevs;
    }

    public void setUnSupportDevs(List<String> unSupportDevs) {
        this.unSupportDevs = unSupportDevs;
    }

    public void setHighEndDeviceSupport(boolean isSupport) {
        this.highEndDeviceSupport = isSupport;
    }

    public boolean isHighEndDeviceSupport() {
        return this.highEndDeviceSupport;
    }

    public List<String> getUnSupportHighEndDevs() {
        return this.unSupportHighEndDevs;
    }

    public void setUnSupportHighEndDevs(List<String> unSupportHighEndDevs) {
        this.unSupportHighEndDevs = unSupportHighEndDevs;
    }

    public boolean isSingleDev() {
        return this.singleDev;
    }

    public void setSingleDev(boolean singleDev) {
        this.singleDev = singleDev;
    }

    public String toString() {
        return "SceneContext [scenePreparedMainJDialog=" + this.scenePreparedMainJDialog + ", support=" + this.support + ", unSupportDevs=" + this.unSupportDevs + "]";
    }

    public boolean isCurrentNotSupport() {
        return this.unSupportDevs.contains(this.currentAddDevIp);
    }

    public boolean isCurrentHighEndDevNotSupport() {
        return this.unSupportHighEndDevs.contains(this.currentAddDevIp);
    }

    public JSONObject getSceneJson() {
        return this.sceneJson;
    }

    public void setSceneJson(JSONObject sceneJson) {
        this.sceneJson = sceneJson;
    }

    public List<String> getToolList() {
        return this.toolList;
    }

    public void setToolList(List<String> toolList) {
        this.toolList = toolList;
    }

    public boolean isCurrentSceneSupportsNas() {
        if (null == DeviceSceneContext.getInstance().getSceneJson()) {
            ToolLoggerFactory.getLogger(DeviceSceneContext.class).info("Can`t get current scene id...");
            return false;
        }
        String sceneId = this.getSceneJson().get("mainScene").toString();
        return sceneId.equals("Routine Maintain") || sceneId.equals("Opening Delivery") || DeviceAddUtil.isReplaceCertScene();
    }

    public boolean isCurrentSceneSupportsHyperMetro() {
        if (null == DeviceSceneContext.getInstance().getSceneJson()) {
            ToolLoggerFactory.getLogger(DeviceSceneContext.class).info("Can`t get current scene id...");
            return false;
        }
        String sceneId = this.getSceneJson().get("mainScene").toString();
        return sceneId.equals("Routine Maintain") || sceneId.equals("Expansion") || sceneId.equals("Upgrade") || sceneId.equals("Opening Delivery") || DeviceAddUtil.isReplaceCertScene();
    }

    public DevNode getCurSvpNode() {
        return this.curSvpNode;
    }

    public void setCurSvpNode(DevNode curSvpNode) {
        this.curSvpNode = curSvpNode;
    }

    public boolean isCurrentDomainUserDevNotSupport() {
        return this.unSupportDomainUserDevs.contains(this.currentAddDevIp);
    }

    public String getToolScene() {
        return this.toolScene;
    }

    public void setToolScene(String toolScene) {
        this.toolScene = toolScene;
    }

    public List<String> getUnSupportDomainUserDevs() {
        return this.unSupportDomainUserDevs;
    }
}

