/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.auth;

import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.auth.AuthStep;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.auth.FusionStorageRestfulService;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.ClusterEvalInfo;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.entity.enums.ClusterMode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONObject;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAuth
extends AuthStep {
    private static final Logger log = LoggerFactory.getLogger(RestAuth.class);

    @Override
    public void auth(ClusterEvalInfo evalInfo, ProgressDialog progress, TaskResult taskResult) {
        log.info("Start rest auth.");
        progress.setCustMizeMsg(ResourceUtil.getString((String)"rest.auth.processing"));
        try (FusionStorageRestfulService service = this.getFusionStorageRestfulService(evalInfo, taskResult);){
            if (service == null) {
                return;
            }
            this.queryFsmInfo(evalInfo, service);
            RestAuth.queryFsaInfo(progress, service);
        }
        catch (ToolException e) {
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
        }
        catch (Exception e) {
            log.error("close connection for :{} failed", (Object)evalInfo.getFloatIp(), (Object)e);
        }
    }

    private void queryFsmInfo(ClusterEvalInfo evalInfo, FusionStorageRestfulService service) throws ToolException {
        try {
            this.handleFSMInfo(evalInfo, service.fetchFSMNodeInfo());
        }
        catch (ToolException e) {
            log.error("Handle fsm info error.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Handle fsm info error.", (Throwable)e);
            throw new ToolException("fsm.node.info.fetch.failed");
        }
    }

    private static void queryFsaInfo(ProgressDialog progress, FusionStorageRestfulService service) throws ToolException {
        try {
            log.info("Start fetch cluster topo.");
            progress.setCustMizeMsg(ResourceUtil.getString((String)"fetch.fsa.node.topo"));
            service.fetchFSANodeTopography();
            progress.setCustMizeMsg(ResourceUtil.getString((String)"fetch.fsa.node.detail"));
            service.fetchFSANodeDetails();
        }
        catch (ToolException e) {
            log.error("Fetch cluster topo faild.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Fetch cluster topo faild.", (Throwable)e);
            throw new ToolException("fsa.node.topo.fetch.failed");
        }
    }

    private FusionStorageRestfulService getFusionStorageRestfulService(ClusterEvalInfo evalInfo, TaskResult taskResult) {
        try {
            return new FusionStorageRestfulService(evalInfo);
        }
        catch (Exception e) {
            log.error("Build rest connection faild.", (Throwable)e);
            taskResult.setResult(TaskResult.Result.FAILED);
            if (e instanceof ToolException && "No trusted certificate found".equals(((ToolException)((Object)e)).getErrorId())) {
                taskResult.setErrorId("No trusted certificate found");
            }
            taskResult.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"rest.connect.fail", (Object[])new Object[]{evalInfo.getRestPort()}));
            return null;
        }
    }

    public void handleFSMInfo(ClusterEvalInfo evalInfo, String response) throws ToolException {
        JSONObject obj = new JSONObject(response);
        String clusterMode = obj.getStringOrDefault("haModel", "");
        if (StringUtils.isNULLStr((String)clusterMode)) {
            throw new ToolException("fsm.node.info.fetch.failed");
        }
        ClusterMode mode = ClusterMode.valueOf((String)clusterMode.toUpperCase(Locale.ENGLISH));
        if (!mode.equals((Object)evalInfo.getModel())) {
            Object[] args = new Object[]{evalInfo.getModel(), mode};
            throw new ToolException("fsm.node.info.mode.mismatch", args);
        }
        this.handlePrimaryNodeInfo(evalInfo, obj);
        if (ClusterMode.DOUBLE.equals((Object)mode)) {
            this.handleStandbyNodeInfo(evalInfo, obj);
            if (!evalInfo.getPrimaryNode().getProductVersion().equals(evalInfo.getStandbyNode().getProductVersion())) {
                throw new ToolException("fsm.node.info.version.error");
            }
        }
    }

    private void handlePrimaryNodeInfo(ClusterEvalInfo evalInfo, JSONObject obj) {
        FsDevNode node = evalInfo.getPrimaryNode();
        node.setInnerIp(obj.getStringOrDefault("nodeIpPrimaryInner", ""));
        node.setDeviceName(obj.getStringOrDefault("nodeNamePrimary", ""));
        node.setProductVersion(obj.getStringOrDefault("nodeVersionPrimary", ""));
        String exterIp = obj.getStringOrDefault("nodeIpPrimaryExter", "");
        node.setMigrType("Manager");
        node.setIp(exterIp);
        String sn = node.getIp() + "Manager";
        node.setDeviceSerialNumber(sn);
    }

    private void handleStandbyNodeInfo(ClusterEvalInfo evalInfo, JSONObject obj) {
        FsDevNode node = evalInfo.getStandbyNode();
        if (!StringUtils.isNULLStr((String)node.getIp()) && !node.getIp().equals(obj.getStringOrDefault("nodeIpStandbyInner", ""))) {
            User standbyLoginUser = evalInfo.getPrimaryNode().getLoginUser();
            User standbyRootUser = evalInfo.getPrimaryNode().getRootUser();
            evalInfo.getPrimaryNode().setLoginUser(evalInfo.getStandbyNode().getLoginUser());
            evalInfo.getPrimaryNode().setRootUser(evalInfo.getStandbyNode().getRootUser());
            evalInfo.getStandbyNode().setLoginUser(standbyLoginUser);
            evalInfo.getStandbyNode().setRootUser(standbyRootUser);
        }
        node.setInnerIp(obj.getStringOrDefault("nodeIpStandbyInner", ""));
        node.setDeviceName(obj.getStringOrDefault("nodeNameStandby", ""));
        node.setProductVersion(obj.getStringOrDefault("nodeVersionStandby", ""));
        String exterIp = obj.getStringOrDefault("nodeIpStandbyExter", "");
        node.setIp(exterIp);
        node.setMigrType("Manager");
        String sn = node.getIp() + "Manager";
        node.setDeviceSerialNumber(sn);
    }
}

