/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.listener;

import com.huawei.ism.tool.devicemanager.observer.AuthTaskObserver;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.util.AuthResultShowUtil;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.util.InputLoginInfoUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchAuth
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchAuth.class);
    protected final Window parent;
    protected final IsmTable dataSource;
    protected final AuthTaskObserver observer;

    @Override
    public void actionPerformed(ActionEvent e) {
        List<DevNode> nodes = this.getSelectNodes();
        log.info("clict batch auth");
        if (CollectionUtils.isEmpty(nodes)) {
            log.warn("select node is empty, do not auth");
            DialogUtils.showErrorDialog((Window)this.parent, (String)ResourceUtil.getString((String)"select.nodes.empty"));
            return;
        }
        this.authNodes(nodes);
    }

    private List<DevNode> getSelectNodes() {
        return this.dataSource.getMarkedRows().stream().map(TableRow::getIdentifier).filter(DevNode.class::isInstance).map(DevNode.class::cast).collect(Collectors.toList());
    }

    private void authNodes(List<DevNode> nodes) {
        Optional<User> customInputInfo = this.getCustomInputInfo();
        if (!customInputInfo.isPresent()) {
            log.info("user click cancel, not input login info");
            return;
        }
        log.info("do batch auth");
        nodes.forEach(node -> {
            node.setLoginUser((User)customInputInfo.get());
            node.setPort(((User)customInputInfo.get()).getPort());
        });
        Future<TaskResult> taskResultFuture = this.asyncAuth(nodes);
        AuthResultShowUtil.showAuthResult(this.parent, taskResultFuture);
    }

    protected Optional<User> getCustomInputInfo() {
        return InputLoginInfoUtil.getCustomInputInfo(this.parent, null, this.getDefaultPort());
    }

    protected abstract Future<TaskResult> asyncAuth(List<DevNode> var1);

    protected int getDefaultPort() {
        return 22;
    }

    public AbstractBatchAuth(Window parent, IsmTable dataSource, AuthTaskObserver observer) {
        this.parent = parent;
        this.dataSource = dataSource;
        this.observer = observer;
    }
}

