/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.listener;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.service.CubeDeviceAddService;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.fusioncube.FusionCubeAddLayout;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.SecurityConfigUtil;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionCubeAddConfirmListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(FusionCubeAddConfirmListener.class);
    private final SceneDeviceAddDialog deviceAddDialog;
    private final FusionCubeAddLayout sourceLayout;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!SwingUtil.validateHintTextInput(this.sourceLayout.getCubePanel().getTextChecktInputs(), (Window)this.deviceAddDialog)) {
            return;
        }
        if (!SwingUtil.validateInput(this.sourceLayout.getStandbyTextInputs(), (Window)this.deviceAddDialog)) {
            return;
        }
        if (!SwingUtil.validatePwdInput(this.sourceLayout.getCubePanel().getPasswordCheckInputs(), (Window)this.deviceAddDialog)) {
            return;
        }
        FsDevNode fsDevNode = this.sourceLayout.createFusionCubeDev();
        fsDevNode.setOnlySecurityAlgorithm(SecurityConfigUtil.isOnlySecurityAlgorithm());
        CustMsgProgressDialog custMsgProgressDialog = new CustMsgProgressDialog((Window)this.deviceAddDialog);
        CubeDeviceAddService cubeDeviceAddService = new CubeDeviceAddService((DevNode)fsDevNode, custMsgProgressDialog);
        Future submit = AsyncExcutor.submit((Callable)cubeDeviceAddService);
        if (custMsgProgressDialog.isDisplayable()) {
            custMsgProgressDialog.setVisible(true);
        }
        this.parseResult(submit, (DevNode)fsDevNode);
    }

    private void parseResult(Future<TaskResult> submit, DevNode fusionCubeDev) {
        try {
            TaskResult result = submit.get();
            DeviceQueryErrorParser.parseErrorInfo(result);
            if (result.getResult() != TaskResult.Result.SUCCESS) {
                DialogUtils.showInfoDialog((JDialog)this.deviceAddDialog, (String)result.getErrorLocaleDescription());
                return;
            }
            this.deviceAddDialog.dispose();
            DefaultNodeProviderImpl.getInstance().addNode(fusionCubeDev);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("get login result for device :{} error", (Object)fusionCubeDev.getIp(), (Object)e);
        }
        catch (ToolException e) {
            log.error("add cube node error", (Throwable)e);
        }
    }

    public FusionCubeAddConfirmListener(SceneDeviceAddDialog deviceAddDialog, FusionCubeAddLayout sourceLayout) {
        this.deviceAddDialog = deviceAddDialog;
        this.sourceLayout = sourceLayout;
    }
}

