/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.auth;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.FsClusterNode;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.auth.AuthResult;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.context.AuthContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.enums.NodeAuthState;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsAuthService
extends Observable {
    private static final Logger log = LoggerFactory.getLogger(OsAuthService.class);
    private final List<FsClusterNode> clusterNodes;

    public OsAuthService(List<FsClusterNode> clusterNodes, Observer authObserver) {
        this.addObserver(authObserver);
        this.clusterNodes = clusterNodes;
    }

    public void doAuthAsync() {
        for (FsClusterNode clusterNode : this.clusterNodes) {
            AsyncExcutor.submit(() -> this.osAuth(clusterNode));
        }
    }

    private void notifyStatusChange(Object arg) {
        if (!(arg instanceof FsClusterNode)) {
            return;
        }
        this.setChanged();
        this.notifyObservers(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void osAuth(FsClusterNode clusterNode) {
        DevNode osNode = clusterNode.getOsNode();
        if (Objects.isNull(osNode)) {
            log.warn("fs node auth failed {}, os node is null", (Object)clusterNode.getManagementIp());
            return;
        }
        if (!AuthContext.getInstance().addAuthingNodes(clusterNode)) {
            return;
        }
        try {
            clusterNode.setNodeAuthState(AuthResult.builder().authState(NodeAuthState.AUTHING).build());
            this.notifyStatusChange((Object)clusterNode);
            SshConnectionManager.getSshConnection((DevNode)osNode);
            clusterNode.setNodeAuthState(AuthResult.builder().authState(NodeAuthState.SUCCESS).build());
            this.notifyStatusChange((Object)clusterNode);
        }
        catch (ToolException e) {
            log.error("Cluster node {} auth failed.", (Object)clusterNode.getManagementIp(), (Object)e);
            clusterNode.setNodeAuthState(AuthResult.builder().authState(NodeAuthState.FAIL).msg(e.getErrorLocaleDescription()).build());
        }
        catch (Exception e) {
            log.error("Cluster node {} auth failed.", (Object)clusterNode.getManagementIp(), (Object)e);
            clusterNode.setNodeAuthState(AuthResult.builder().authState(NodeAuthState.FAIL).msg(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceautherror", (Object[])new Object[]{clusterNode.getManagementIp()})).build());
        }
        finally {
            this.notifyStatusChange((Object)clusterNode);
            AuthContext.getInstance().authComplete(clusterNode);
            SshConnectionManager.releaseConnection((DevNode)osNode);
        }
    }
}

