/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceModifyDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceModifyFusionCubeDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.ModifyAiNodeDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.ScenePreparedMainJDialog;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.service.timingtask.ITimingTaskService;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;

public class ModifyOperateAction
extends ToolAction
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ScenePreparedMainJDialog dialog = null;
    private String deviceSn = null;

    public ModifyOperateAction(ScenePreparedMainJDialog dialog, String deviceSn) {
        this.dialog = dialog;
        this.deviceSn = deviceSn;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DevNode pubservicedevice = this.findDevToModify();
        com.huawei.ism.tool.obase.entity.DevNode device = EntityUtils.toOldDev((DevNode)pubservicedevice);
        com.huawei.ism.tool.obase.entity.DevNode devNode = DefaultNodeProviderImpl.getInstance().findDevNode(this.deviceSn);
        JDialog deviceModifyDialog = device.isFusionCube() ? new DeviceModifyFusionCubeDialog((Window)this.dialog, device) : (ItDeviceType.DME_NODE.equals((Object)device.getItDeviceType()) && devNode instanceof AiDevNode ? new ModifyAiNodeDialog((Window)this.dialog, (AiDevNode)devNode) : new DeviceModifyDialog((Window)this.dialog, device));
        deviceModifyDialog.setModal(true);
        if (!ApplicationContext.getInstance().isJunit()) {
            deviceModifyDialog.setVisible(true);
        }
        if (null == pubservicedevice) {
            throw new NullPointerException();
        }
        pubservicedevice.setDeveloperPwd(device.getDeveloperPwd());
    }

    private DevNode findDevToModify() {
        DevNode pubservicedevice = null;
        for (TableRow row : this.dialog.getMainLayout().getDeviceTable().getAllRows()) {
            DevNode dn = (DevNode)row.getUserObject();
            if (!this.deviceSn.equals(dn.getDeviceSerialNumber())) continue;
            pubservicedevice = dn;
            break;
        }
        return pubservicedevice;
    }

    public static boolean checkMarkedDevInTask(ScenePreparedMainJDialog dialog, String msg) {
        ITimingTaskService tService = (ITimingTaskService)PublicServiceManage.getInstance().getService(ITimingTaskService.class);
        if (null == tService) {
            return false;
        }
        List allMarketRows = dialog.getMainLayout().getDeviceTable().getMarkedRows();
        for (TableRow row : allMarketRows) {
            com.huawei.ism.tool.obase.entity.DevNode node;
            boolean containsTaskOfDev;
            Object obj = row.getIdentifier();
            if (!(obj instanceof com.huawei.ism.tool.obase.entity.DevNode) || !(containsTaskOfDev = tService.containsTaskOfDev((node = (com.huawei.ism.tool.obase.entity.DevNode)obj).getIp()))) continue;
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)dialog, (String)msg);
            if (0 == warningDialog.getValue()) {
                ITimingTaskService taskService = (ITimingTaskService)PublicServiceManage.getInstance().getService(ITimingTaskService.class);
                taskService.openTaskManageDialog();
            }
            return true;
        }
        return false;
    }
}

