/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.derives;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.derives.DeriveUtils;
import com.huawei.wsf.redos.regexp.RegexCharSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CharDerive
implements Derive {
    private final char[] chs;
    private int size = 0;

    public CharDerive(RegexCharSet characters, boolean including) {
        if (characters.isEmpty()) {
            this.chs = new char[0];
        } else if (including) {
            this.chs = new char[characters.size()];
            Iterator iterator = characters.iterator();
            while (iterator.hasNext()) {
                char ch = ((Character)iterator.next()).charValue();
                this.addDeriveIncluding(ch);
            }
        } else {
            this.chs = new char[128 - characters.size()];
            this.addDeriveIncluding(characters);
        }
    }

    private void addDeriveIncluding(RegexCharSet set) {
        for (char c = '!'; c < '\u0080'; c = (char)(c + '\u0001')) {
            if (set.contains(Character.valueOf(c))) continue;
            this.addDeriveIncluding(c);
        }
    }

    private void addDeriveIncluding(char ch) {
        if (this.size == this.chs.length) {
            return;
        }
        this.chs[this.size++] = ch;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return new CharDeriveIter(this.chs, this.size());
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return DeriveUtils.toNormalize(this);
    }

    private static class CharDeriveIter
    implements Iterator<String> {
        private final char[] chs;
        private final int size;
        private int index = 0;

        CharDeriveIter(char[] characters, int size) {
            this.chs = characters;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return String.valueOf(this.chs[this.index++]);
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

