/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.derives;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.derives.DeriveUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OrDerive
implements Derive {
    private final Derive da;
    private final Derive db;

    public OrDerive(Derive da, Derive db) {
        this.da = da;
        this.db = db;
    }

    @Override
    public boolean isEmpty() {
        return this.da.isEmpty() && this.db.isEmpty();
    }

    @Override
    public int size() {
        return Math.min(this.da.size() + this.db.size(), Integer.MAX_VALUE);
    }

    @Override
    public Iterator<String> iterator() {
        return new OrIter(this.da, this.db);
    }

    public String toString() {
        return DeriveUtils.toNormalize(this);
    }

    private static class OrIter
    implements Iterator<String> {
        private final Iterator<String> deriveA;
        private final Iterator<String> deriveB;

        OrIter(Derive sa, Derive sb) {
            this.deriveA = sa.iterator();
            this.deriveB = sb.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.deriveA.hasNext() || this.deriveB.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.deriveA.hasNext()) {
                return this.deriveA.next();
            }
            return this.deriveB.next();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

