/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.processor;

import com.huawei.wsf.redos.base.RegexModel;
import com.huawei.wsf.redos.processor.Processor;
import com.huawei.wsf.redos.processor.ProcessorGenerator;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.regexp.RegexElement;
import com.huawei.wsf.redos.regexp.RegexSeq;

public class RegexConvert {
    private final RegexModel regexModel;
    private RegExp rootNode;
    private RegExp curNode;

    public RegexConvert(String regex) {
        this(new RegexModel(regex));
    }

    public RegexConvert(RegexModel regex) {
        this.regexModel = regex;
        this.rootNode = RegexElement.EMPTY;
        this.curNode = RegexElement.EMPTY;
    }

    public RegExp getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(RegExp rootNode) {
        this.rootNode = rootNode;
    }

    public RegExp getCurNode() {
        return this.curNode;
    }

    public void setCurNode(RegExp curNode) {
        this.curNode = curNode;
    }

    public RegExp convert(int level) {
        StringBuilder tempStr = new StringBuilder();
        while (!this.regexModel.isEmpty()) {
            char currentChar = this.regexModel.getProcessStr().charAt(0);
            Processor processor = ProcessorGenerator.getProcessor(Character.valueOf(currentChar));
            processor.handle(this, this.regexModel, tempStr, Character.valueOf(currentChar), level);
            if (currentChar != ')') continue;
            break;
        }
        RegexElement regExp = RegexElement.clone(tempStr.toString());
        this.rootNode = RegexSeq.clone(this.rootNode, this.curNode).toNormalize();
        this.curNode = regExp;
        tempStr.setLength(0);
        this.rootNode = RegexSeq.clone(this.rootNode, this.curNode).toNormalize();
        this.curNode = RegexElement.EMPTY;
        return this.rootNode;
    }
}

