/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.processor;

import com.huawei.wsf.redos.base.RegexModel;
import com.huawei.wsf.redos.processor.Processor;
import com.huawei.wsf.redos.processor.RegexConvert;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.regexp.RegexElement;
import com.huawei.wsf.redos.regexp.RegexIterRepeat;
import com.huawei.wsf.redos.regexp.RegexSeq;

public class RepeatProcessor
extends Processor {
    @Override
    public void handle(RegexConvert processor, RegexModel regexModel, StringBuilder tempStr, Character ch, int level) {
        this.repetition(tempStr, regexModel, processor);
    }

    private void repetition(StringBuilder tempStr, RegexModel regexModel, RegexConvert processor) {
        RegExp rootCopy = processor.getRootNode();
        RegExp currentCopy = processor.getCurNode();
        if (tempStr.length() == 0) {
            RegExp operand = currentCopy;
            if (!operand.isEmpty()) {
                currentCopy = this.convertRepetition(regexModel, operand);
            } else {
                operand = rootCopy;
                rootCopy = this.convertRepetition(regexModel, operand);
                currentCopy = RegexElement.EMPTY;
            }
        } else {
            RegExp operand = this.getLastCharacterAsExpression(tempStr, rootCopy, currentCopy);
            RegExp repetition = this.convertRepetition(regexModel, operand);
            rootCopy = RegexSeq.clone(rootCopy, currentCopy).toNormalize();
            currentCopy = repetition;
        }
        processor.setCurNode(currentCopy);
        processor.setRootNode(rootCopy);
    }

    private RegExp getLastCharacterAsExpression(StringBuilder sb, RegExp root, RegExp current) {
        int mostIndex = sb.length() - 1;
        char ch = sb.charAt(mostIndex);
        sb.setLength(mostIndex);
        RegexElement regExp = RegexElement.clone(String.valueOf(ch));
        RegexSeq.clone(root, current).toNormalize();
        sb.setLength(0);
        return regExp;
    }

    public RegExp convertRepetition(RegexModel regex, RegExp expression) {
        RegExp repetition;
        char ch = RepeatProcessor.deleteChar(regex);
        switch (ch) {
            case '+': {
                repetition = RegexIterRepeat.clone(expression, 1, Integer.MAX_VALUE);
                break;
            }
            case '*': {
                repetition = RegexIterRepeat.clone(expression, 0, Integer.MAX_VALUE);
                break;
            }
            case '{': {
                repetition = this.repetitionInBraces(expression, regex);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown repetition " + ch);
            }
        }
        if (!regex.isEmpty() && regex.getProcessStr().charAt(0) == '?') {
            RepeatProcessor.deleteToken(regex, "?");
        }
        return repetition;
    }

    private RegExp repetitionInBraces(RegExp operand, RegexModel regex) {
        if (regex.getProcessStr().length() < 2) {
            regex.error("Premature end of repetition '" + RepeatProcessor.deleteAll(regex) + "'");
        }
        this.deleteWhiteSpace(regex);
        int from = this.parseInteger(regex);
        RepeatProcessor.checkPositiveInteger(regex, from);
        this.deleteWhiteSpace(regex);
        int to = from;
        if (regex.getProcessStr().charAt(0) == ',') {
            RepeatProcessor.deleteToken(regex, ",");
            this.deleteWhiteSpace(regex);
            to = this.parseInteger(regex);
        }
        this.consumeClosingBrace(regex);
        if (to > 0) {
            return RegexIterRepeat.clone(operand, from, to);
        }
        return RegexIterRepeat.clone(operand, from, Integer.MAX_VALUE);
    }

    private static void checkPositiveInteger(RegexModel regex, int from) {
        if (from == -1) {
            regex.error("Error in repetition: Number expected");
        }
    }

    private void consumeClosingBrace(RegexModel regex) {
        this.deleteWhiteSpace(regex);
        if (regex.getProcessStr().charAt(0) != '}') {
            regex.error("Error in repetition: Missing }");
        }
        RepeatProcessor.deleteToken(regex, "}");
    }

    private int parseInteger(RegexModel regex) {
        StringBuilder number = new StringBuilder();
        while (!regex.isEmpty() && ",} ".indexOf(regex.getProcessStr().charAt(0)) == -1) {
            char ch = RepeatProcessor.deleteChar(regex);
            if (ch >= '0' && ch <= '9') {
                number.append(ch);
                continue;
            }
            regex.error("Error in repetition: Number expected but got " + ch);
        }
        if (number.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(number.toString());
        }
        catch (NumberFormatException e) {
            regex.error("Error in repetition: Invalid number", e);
            return -1;
        }
    }

    public void deleteWhiteSpace(RegexModel regex) {
        while (!regex.getProcessStr().isEmpty() && regex.getProcessStr().charAt(0) == ' ') {
            RepeatProcessor.deleteToken(regex, " ");
        }
    }
}

