/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.regexp;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.regexp.RegexCharSet;
import com.huawei.wsf.redos.regexp.RegexElement;
import com.huawei.wsf.redos.regexp.RegexOr;
import com.huawei.wsf.redos.strategy.Strategy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class RegexCharClass
implements RegExp {
    private final RegexCharSet charSet;
    private final boolean including;

    public RegexCharClass(RegexCharSet charSet, boolean including) {
        this.charSet = charSet;
        this.including = including;
    }

    @Override
    public RegExp cross(RegExp another) {
        RegExp exp = RegexElement.EMPTY;
        if (!this.including) {
            boolean find = false;
            char temp = '\u0000';
            Iterator iterator = this.charSet.iterator();
            while (iterator.hasNext()) {
                char ch = ((Character)iterator.next()).charValue();
                RegExp.Match match = another.matchAt(0, ch);
                if (!RegExp.Match.MATCH.equals((Object)match)) continue;
                find = true;
                temp = ch;
                break;
            }
            if (!find) {
                exp = RegexOr.clone(RegexElement.clone(String.valueOf(temp)), exp);
            }
        } else {
            Iterator iterator = this.charSet.iterator();
            while (iterator.hasNext()) {
                char ch = ((Character)iterator.next()).charValue();
                RegExp.Match match = another.matchAt(0, ch);
                if (RegExp.Match.MATCH.equals((Object)match)) {
                    exp = RegexOr.clone(RegexElement.clone(String.valueOf(ch)), exp);
                    continue;
                }
                if (!match.equals((Object)RegExp.Match.OUT_OF_RANGE)) continue;
                return RegexElement.EMPTY;
            }
        }
        return exp.toNormalize();
    }

    @Override
    public boolean isEmpty() {
        return this.including && this.charSet.isEmpty();
    }

    @Override
    public RegExp.Match matchAt(int index, char ch) {
        if (index < Collections.max(this.counts())) {
            return this.including == this.charSet.contains(Character.valueOf(ch)) ? RegExp.Match.MATCH : RegExp.Match.NO_MATCH;
        }
        return RegExp.Match.OUT_OF_RANGE;
    }

    @Override
    public Set<Integer> counts() {
        return Collections.singleton(1);
    }

    @Override
    public RegExp toNormalize() {
        if (this.isEmpty()) {
            return RegexElement.EMPTY;
        }
        if (this.charSet.size() == 1 && this.including) {
            return RegexElement.clone(String.valueOf(this.charSet.iterator().next()));
        }
        return this;
    }

    @Override
    public Derive derive(Strategy strategy) {
        return strategy.charClass(this.charSet, this.including);
    }

    public boolean equals(Object other) {
        Object obj = other;
        if (obj instanceof RegExp) {
            obj = ((RegExp)obj).toNormalize();
        }
        if (obj instanceof RegexCharClass) {
            RegexCharClass character = (RegexCharClass)obj;
            return this.including == character.including && this.charSet.equals(character.charSet);
        }
        RegExp exp = this.toNormalize();
        if (exp instanceof RegexCharClass) {
            return false;
        }
        return exp.equals(obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (!this.including) {
            sb.append("^");
        }
        Iterator iterator = this.charSet.iterator();
        while (iterator.hasNext()) {
            char ch = ((Character)iterator.next()).charValue();
            sb.append(ch);
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        RegExp exp = this.toNormalize();
        if (exp instanceof RegexCharClass) {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.charSet.hashCode();
            hashCode = 31 * hashCode + (this.including ? 1 : 0);
            return hashCode;
        }
        return exp.hashCode();
    }

    public RegexCharSet toSet() {
        if (this.including) {
            return this.charSet;
        }
        return this.charSet.reversed();
    }
}

