/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.flow;

import com.huawei.ism.tool.base.flow.Branch;
import com.huawei.ism.tool.base.flow.Flow;
import com.huawei.ism.tool.base.flow.FlowException;
import com.huawei.ism.tool.base.flow.ICondition;
import com.huawei.ism.tool.base.flow.IFlow;
import com.huawei.ism.tool.base.flow.IFlowListener;
import com.huawei.ism.tool.base.flow.IStepContainer;
import com.huawei.ism.tool.base.flow.Step;
import com.huawei.ism.tool.base.flow.ui.IFlowUI;
import com.huawei.ism.tool.base.flow.ui.Title;
import com.huawei.ism.tool.base.osplatform.OsEnumn;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlowFactory {
    private static final long serialVersionUID = -1227431671907482007L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FlowFactory.class);
    private Map<String, Class<?>> stepMap = new HashMap();
    private Map<String, Class<?>> branchMap = new HashMap();
    private Map<String, Class<?>> conditionMap = new HashMap();
    private Map<String, Class<?>> listenerMap = new HashMap();
    private Map<Class<?>, Object> instanceMap = new HashMap();
    private Map<String, String> windowSizeMap = new HashMap<String, String>();
    private Map<String, Title> titleMap = new HashMap<String, Title>();
    private ClassLoader clsLoader = null;
    private Locale loc = null;
    private InputStream defStream = null;
    private Document defDoc = null;
    private InputStream flowStream = null;
    private Document flowDoc = null;

    public FlowFactory(InputStream defStream, InputStream flowStream, ClassLoader clsLoader, Locale loc) {
        this.flowStream = flowStream;
        this.defStream = defStream;
        this.clsLoader = clsLoader;
        this.loc = loc;
    }

    public FlowFactory(String defXmlPath, String flowXmlPath, ClassLoader clsLoader, Locale loc) {
        this(clsLoader.getResourceAsStream(defXmlPath), clsLoader.getResourceAsStream(flowXmlPath), clsLoader, loc);
    }

    public Title getFlowTitle() {
        try {
            Document doc = this.getFlowDoc(this.flowStream);
            if (null == doc) {
                return null;
            }
            HashMap<String, Title> map = new HashMap<String, Title>();
            Element root = doc.getDocumentElement();
            Element res = XmlUtils.getChild(root, "resource");
            this.buildTitleMap(res, map);
            Element flowEm = XmlUtils.getChild(root, "flow");
            return (Title)map.get(XmlUtils.getAttribute(flowEm, "title"));
        }
        catch (FlowException e) {
            LOGGER.error("Get flow title error.", (Throwable)e);
            return null;
        }
    }

    public IFlow createFlow(IFlowUI flowUI) throws FlowException {
        Document document = this.getDefDoc(this.defStream);
        if (null == document) {
            throw new FlowException("Read define xml error.");
        }
        this.parseDefToMaps(document);
        Document doc = this.getFlowDoc(this.flowStream);
        if (null != doc) {
            Flow flow = this.parseFlow(doc);
            flow.setFlowUI(flowUI);
            return flow;
        }
        throw new FlowException("Read flow xml error.");
    }

    private Document getDefDoc(InputStream inStream) throws FlowException {
        if (null == this.defDoc) {
            this.defDoc = this.getDoc(inStream);
        }
        return this.defDoc;
    }

    private Document getFlowDoc(InputStream inStream) throws FlowException {
        if (null == this.flowDoc) {
            this.flowDoc = this.getDoc(inStream);
        }
        return this.flowDoc;
    }

    private void parseDefToMaps(Document doc) throws FlowException {
        Element root = doc.getDocumentElement();
        try {
            this.buildClazzMap(root, "step", this.stepMap);
            this.buildClazzMap(root, "branch", this.branchMap);
            this.buildClazzMap(root, "condition", this.conditionMap);
            this.buildClazzMap(root, "listener", this.listenerMap);
            this.buildDefaultMap(root, "window", this.windowSizeMap);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Parse define xml error.", (Throwable)e);
            throw new FlowException("Parse define xml error.", e);
        }
    }

    private void buildDefaultMap(Element root, String tag, Map<String, String> valueMap) {
        List<Element> elements;
        Collection<Element> windowEle = XmlUtils.getChildren(root, tag);
        boolean hasOsConfig = windowEle.stream().anyMatch(ele -> !StringUtils.isNULLStr(XmlUtils.getAttribute(ele, "os")));
        if (hasOsConfig && !CollectionUtils.isEmpty(elements = windowEle.stream().filter(ele -> !StringUtils.isNULLStr(XmlUtils.getAttribute(ele, "os"))).filter(ele -> OsEnumn.of(XmlUtils.getAttribute(ele, "os")).equals((Object)OsEnumn.getNowRunningOs())).collect(Collectors.toList()))) {
            elements.forEach(ele -> {
                valueMap.put("width", ele.getAttribute("width"));
                valueMap.put("height", ele.getAttribute("height"));
            });
            return;
        }
        for (Element window : XmlUtils.getChildren(root, tag)) {
            valueMap.put("width", window.getAttribute("width"));
            valueMap.put("height", window.getAttribute("height"));
        }
    }

    private Flow parseFlow(Document doc) throws FlowException {
        Element root = doc.getDocumentElement();
        Element res = XmlUtils.getChild(root, "resource");
        this.buildTitleMap(res, this.titleMap);
        Element flowEm = XmlUtils.getChild(root, "flow");
        Title title = this.titleMap.get(XmlUtils.getAttribute(flowEm, "title"));
        if (null == title) {
            LOGGER.error("No attribute title in tag " + flowEm.getTagName());
            throw new FlowException("No attribute title in tag " + flowEm.getTagName());
        }
        Flow flow = new Flow(title);
        flow.setHelp(XmlUtils.getAttribute(flowEm, "help"));
        this.buildFlowSteps(flow, flowEm);
        this.buildFlowListeners(flow, flowEm);
        return flow;
    }

    private void buildFlowListeners(Flow flow, Element flowEm) throws FlowException {
        String listeners = XmlUtils.getAttribute(flowEm, "listeners");
        if (StringUtils.isNULLStr(listeners)) {
            return;
        }
        for (String name : listeners.split(",")) {
            IFlowListener listener = (IFlowListener)this.getClazzInstance(this.listenerMap, name, true);
            flow.addListener(listener);
        }
    }

    private void buildFlowSteps(Flow flow, Element flowEm) throws FlowException {
        StepContainer stepContainer = new StepContainer(flow);
        int i = 0;
        for (Element em : XmlUtils.getChildren(flowEm)) {
            int stage = i++;
            this.addStage(em, flow, stage);
            this.addStep(em, stepContainer, stage);
        }
    }

    private void addStage(Element em, Flow flow, int stageIndex) throws FlowException {
        Title title = this.titleMap.get(XmlUtils.getAttribute(em, "title"));
        if (null == title) {
            LOGGER.error("No attribute title in tag " + em.getTagName());
            throw new FlowException("No attribute title in tag " + em.getTagName());
        }
        flow.addStage(stageIndex, title);
    }

    private void addStep(Element stepEm, IStepContainer container, int stageIndex) throws FlowException {
        Step step = null;
        String tag = stepEm.getTagName();
        String name = XmlUtils.getAttribute(stepEm, "name");
        if ("step".equals(tag)) {
            step = (Step)this.getClazzInstance(this.stepMap, name);
            this.buildStep(stepEm, step, stageIndex);
            step.setLoc(this.loc);
            container.addStep(step);
        } else if ("branch".equals(tag)) {
            Branch branch = (Branch)this.getClazzInstance(this.branchMap, name);
            this.addSteps(stepEm, this.toStepContainer(branch), stageIndex);
            this.buildStep(stepEm, branch, stageIndex);
            branch.setLoc(this.loc);
            container.addStep(branch);
        } else if ("sub-flow".equals(tag)) {
            this.addSteps(stepEm, container, stageIndex);
        } else {
            LOGGER.error("Parse flow error, wrong tag:" + tag);
            throw new FlowException("Parse flow error, wrong tag:" + tag);
        }
    }

    private void addSteps(Element parentEm, IStepContainer container, int stageIndex) throws FlowException {
        for (Element em : XmlUtils.getChildren(parentEm)) {
            this.addStep(em, container, stageIndex);
        }
    }

    private void buildTitleMap(Element resEm, Map<String, Title> map) throws FlowException {
        String zh = Locale.CHINESE.getLanguage();
        String en = Locale.ENGLISH.getLanguage();
        for (Element step : XmlUtils.getChildren(resEm, "title")) {
            String id = step.getAttribute("id");
            Title t = new Title();
            t.addName(zh, XmlUtils.getTextContentOfChild(step, "nameZh"));
            t.addName(en, XmlUtils.getTextContentOfChild(step, "nameEn"));
            t.addDesc(zh, XmlUtils.getTextContentOfChild(step, "descZh"));
            t.addDesc(en, XmlUtils.getTextContentOfChild(step, "descEn"));
            try {
                t.addLink(zh, XmlUtils.getTextContentOfChild(step, "linkZh"));
                t.addLink(en, XmlUtils.getTextContentOfChild(step, "linkEn"));
            }
            catch (Exception e) {
                LOGGER.error("XmlUtils.getTextContentOfChild", (Throwable)e);
            }
            map.put(id, t);
        }
    }

    private void buildClazzMap(Element root, String tag, Map<String, Class<?>> clazzMap) throws ClassNotFoundException {
        for (Element step : XmlUtils.getChildren(root, tag)) {
            String name = step.getAttribute("name");
            Class<?> implClazz = this.clsLoader.loadClass(step.getAttribute("implClazz"));
            clazzMap.put(name, implClazz);
        }
    }

    private void buildStep(Element stepEm, Step step, int stageIndex) throws FlowException {
        String id;
        String isAuto = XmlUtils.getAttribute(stepEm, "isAuto");
        step.setAuto(Boolean.parseBoolean(isAuto));
        String flag = XmlUtils.getAttribute(stepEm, "flag");
        step.setSelectFlag(flag);
        String cond = XmlUtils.getAttribute(stepEm, "condition");
        if (!StringUtils.isNULLStr(cond)) {
            step.setCondition((ICondition)this.getClazzInstance(this.conditionMap, cond));
        }
        if (!StringUtils.isNULLStr(id = XmlUtils.getAttribute(stepEm, "id"))) {
            step.setId(id);
        }
        step.setStageIndex(stageIndex);
    }

    private Object getClazzInstance(Map<String, Class<?>> clazzMap, String key) throws FlowException {
        return this.getClazzInstance(clazzMap, key, false);
    }

    private Object getClazzInstance(Map<String, Class<?>> clazzMap, String key, boolean useExistInst) throws FlowException {
        Class<?> clazz = clazzMap.get(key);
        if (null == clazz) {
            LOGGER.error("No define for " + key);
            throw new FlowException("No define for " + key);
        }
        try {
            Object instance = this.instanceMap.get(clazz);
            if (useExistInst && null != instance) {
                return instance;
            }
            instance = clazz.newInstance();
            this.instanceMap.put(clazz, instance);
            return instance;
        }
        catch (InstantiationException e) {
            LOGGER.error("Instantiate class " + clazz + " err", (Throwable)e);
            throw new FlowException("Instantiate class " + clazz + " err", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Constructor of class " + clazz + " access error", (Throwable)e);
            throw new FlowException("Constructor of class " + clazz + " access error", e);
        }
    }

    private Document getDoc(InputStream stream) throws FlowException {
        if (null == stream) {
            throw new FlowException("Flow/Define xml InputStream is null.");
        }
        Document doc = null;
        try {
            doc = XmlUtils.parseDocument(stream);
        }
        finally {
            StreamUtils.closeStream(null, stream);
        }
        return doc;
    }

    private IStepContainer toStepContainer(Branch branch) {
        return new AdaptorStepContainer(branch);
    }

    public Map<String, String> getWindowSizeMap() {
        return this.windowSizeMap;
    }

    static class AdaptorStepContainer
    implements IStepContainer {
        private Branch branch = null;

        public AdaptorStepContainer(Branch branch) {
            this.branch = branch;
        }

        @Override
        public void addStep(Step step) throws FlowException {
            this.branch.addOptionalStep(step.getSelectFlag(), step);
        }
    }

    static class StepContainer
    implements IStepContainer {
        Flow flow;

        public StepContainer(Flow flow) {
            this.flow = flow;
        }

        @Override
        public void addStep(Step step) throws FlowException {
            this.flow.addStep(step);
        }
    }
}

