/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.ui.ToolBorderUtils;
import com.huawei.ism.tool.base.ui.UiConstants;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.context.ILanguageListener;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorLookAndFeel;
import java.awt.Color;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelInstaller {
    public static void installToolCustomUI() {
        LookAndFeelInstaller.installToolCustomUI((LookAndFeel)new ArmorLookAndFeel());
    }

    public static void installToolCustomUI(LookAndFeel theme) {
        try {
            System.setProperty("VENDER", ApplicationContext.getInstance().getVender());
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            IsmPlafUtils.setLocale((Locale)Locale.getDefault());
            ResourceManager.init();
            UIManager.setLookAndFeel(theme);
            LanguageManager.getInstance().addListener(new ILanguageListener(){

                @Override
                public void fireLanguageChanged(Locale language) {
                    ResourceManager.setLocale((Locale)language);
                    IsmPlafUtils.setLocale((Locale)language);
                }
            });
        }
        catch (UnsupportedLookAndFeelException e) {
            ToolLoggerFactory.getLogger(LookAndFeelInstaller.class).error("Install ISM look&feel failed.", (Throwable)e);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(LookAndFeelInstaller.class).error("Install ISM look&feel failed.");
        }
        UIDefaults defaultUI = UIManager.getDefaults();
        defaultUI.put("oem.color", new Color(0x990000));
        defaultUI.put("SplitPaneDivider.border", ToolBorderUtils.getSplitPaneDividerBorder());
        defaultUI.put("IsmButton.height", (Object)25);
        defaultUI.put("Panel.background", UiConstants.PANEL_COLOR);
        defaultUI.put("ToolButton.disabledFillBackground", new Color(0xF3F3F3));
        if (!"true".equalsIgnoreCase((String)defaultUI.get("buttonUiInited"))) {
            defaultUI.put("ButtonUI", "com.huawei.ism.tool.base.ui.surface.NewToolButtonUI");
        }
        LookAndFeelInstaller.checkDefultUi(defaultUI);
        LookAndFeelInstaller.checkResourceImage(defaultUI);
    }

    static void checkDefultUi(UIDefaults defaultUI) {
        defaultUI.put("HeaderLogoPanelUI", "com.huawei.ism.tool.toolbox.ui.surface.HeaderLogoPanelUI");
        defaultUI.put("WizardHeadPanelUI", "com.huawei.ism.tool.base.ui.surface.NewWizardHeadPanelUI");
        defaultUI.put("WizardGuidePanelUI", "com.huawei.ism.tool.base.ui.surface.NewWizardGuidePanelUI");
        defaultUI.put("FuncItemUI", "com.huawei.ism.tool.base.ui.surface.NewFuncItemUI");
        defaultUI.put("HilightUI", "com.huawei.ism.tool.taskmanagerui.ui.component.HilightUI");
        defaultUI.put("ToolTabbedPaneUI", "com.huawei.ism.tool.toolbox.ui.surface.ToolTabbedPaneUI");
        defaultUI.put("ToolStatusBarUI", "com.huawei.ism.tool.toolbox.ui.surface.ToolStatusBarUI");
        defaultUI.put("TaskBarUI", "com.huawei.ism.tool.toolbox.ui.surface.TaskBarUI");
        defaultUI.put("HeadRightPanelUI", "com.huawei.ism.tool.toolbox.ui.surface.HeadRightPanelUI");
        defaultUI.put("ToolRightPanelUI", "com.huawei.ism.tool.base.ui.surface.NewToolRightPanelUI");
        defaultUI.put("WizardImagePanelUI", "com.huawei.ism.tool.base.ui.surface.WizardImagePanelUI");
        defaultUI.put("ToolTipUI", "com.huawei.ism.ui.swing.plaf.IsmToolTipUI");
        defaultUI.put("NewWizardStepGroupUI", "com.huawei.ism.tool.base.ui.component.wizard.WizardStepGroupUI");
        defaultUI.put("NewWizardStepItemUI", "com.huawei.ism.tool.base.ui.component.wizard.WizardStepItemUI");
        defaultUI.put("NewWizardNumberPanelUI", "com.huawei.ism.tool.base.ui.component.wizard.WizardNumberPanelUI");
    }

    static void checkResourceImage(UIDefaults defaultUI) {
        defaultUI.put("TitleBar.dialog_help_normal", ResourceUtil.getImage("help_normal.png"));
        defaultUI.put("TitleBar.dialog_help_rollover", ResourceUtil.getOEMImage("help_hover.png"));
        defaultUI.put("TitleBar.dialog_help_selected", ResourceUtil.getImage("help_select.png"));
        defaultUI.put("TitleBar.titleBar_maxsize_normal", ResourceUtil.getImage("titleBar_maxsize_normal.png"));
        defaultUI.put("TitleBar.titleBar_maxsize_rollover", ResourceUtil.getImage("titleBar_maxsize_rollover.png"));
        defaultUI.put("TitleBar.titleBar_maxsize_selected", ResourceUtil.getImage("titleBar_maxsize_selected.png"));
        defaultUI.put("TitleBar.titleBar_maxsizeback_normal", ResourceUtil.getImage("titleBar_maxsizeback_normal.png"));
        defaultUI.put("TitleBar.titleBar_maxsizeback_rollover", ResourceUtil.getImage("titleBar_maxsizeback_rollover.png"));
        defaultUI.put("TitleBar.titleBar_maxsizeback_selected", ResourceUtil.getImage("titleBar_maxsizeback_selected.png"));
        defaultUI.put("TitleBar.titleBar_minimize_normal", ResourceUtil.getImage("titleBar_minimize_normal.png"));
        defaultUI.put("TitleBar.titleBar_minimize_rollover", ResourceUtil.getImage("titleBar_minimize_rollover.png"));
        defaultUI.put("TitleBar.titleBar_minimize_selected", ResourceUtil.getImage("titleBar_minimize_selected.png"));
        defaultUI.put("TitleBar.dialog_about_taskbar_normal", ResourceUtil.getImage("about_taskbar_normal.png"));
        defaultUI.put("TitleBar.dialog_about_taskbar_rollover", ResourceUtil.getImage("about_taskbar_rollover.png"));
        defaultUI.put("TitleBar.dialog_about_taskbar_selected", ResourceUtil.getImage("about_taskbar_selected.png"));
        defaultUI.put("TitleBar.dialog_setting_taskbar_normal", ResourceUtil.getImage("setting_taskbar_normal.png"));
        defaultUI.put("TitleBar.dialog_setting_taskbar_rollover", ResourceUtil.getImage("setting_taskbar_rollover.png"));
        defaultUI.put("TitleBar.dialog_setting_taskbar_selected", ResourceUtil.getImage("setting_taskbar_selected.png"));
        UIManager.getDefaults().getUI(new JToolTip());
    }
}

