/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.action.ToolAction;
import com.huawei.ism.tool.base.ui.surface.IHighLightComponent;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class FuncItem
extends JPanel
implements IHighLightComponent {
    private static final long serialVersionUID = 4411480045910260075L;
    private ToolAction action = null;
    private Icon icon;
    private String funcName;
    private String desc;
    private boolean highLight = false;
    private JLabel nameLabel = new JLabel("");
    private JTextArea descLabel = UCD.createTextArea((String)"");

    public FuncItem(Icon icon, String funcName, String desc) {
        this(icon, funcName, desc, LanguageManager.getInstance().getCurrentLanguage());
    }

    public FuncItem(Icon icon, String funcName, String desc, Locale locale) {
        this.icon = icon;
        this.desc = desc;
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(this.icon);
        this.nameLabel.setText(funcName);
        this.descLabel.setText(this.desc);
        UiMethod.setFont(this.nameLabel, new Font("Arail", 1, 20), new Font("\u5b8b\u4f53", 1, 20), locale);
        this.addListsners();
        this.initLayout(iconLabel, this.nameLabel, this.descLabel);
        this.setOpaque(false);
    }

    public FuncItem(Icon icon, String funcName, String desc, ToolAction action) {
        this(icon, funcName, desc, LanguageManager.getInstance().getCurrentLanguage());
        this.action = action;
        this.icon = icon;
        this.funcName = funcName;
        this.desc = desc;
    }

    public FuncItem(Icon icon, String funcName, String desc, ToolAction action, Locale locale) {
        this(icon, funcName, desc, locale);
        this.action = action;
    }

    private void addListsners() {
        FuncItemMouseAdapter mouseAdter = new FuncItemMouseAdapter(this);
        this.addMouseListener(mouseAdter);
        this.descLabel.addMouseListener(mouseAdter);
        this.nameLabel.addMouseListener(mouseAdter);
    }

    @Override
    public String getUIClassID() {
        return "FuncItemUI";
    }

    protected void initLayout(JLabel iconLabel, JLabel nameLabel0, JTextArea descLabel0) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gContents = new GridBagConstraints();
        gContents.anchor = 17;
        gContents.insets = new Insets(0, 6, 0, 0);
        gContents.gridx = 0;
        gContents.gridy = 0;
        gContents.weightx = 0.0;
        gContents.gridheight = 2;
        this.add((Component)iconLabel, gContents);
        gContents.gridx = 1;
        gContents.weightx = 1.0;
        gContents.gridheight = 1;
        gContents.fill = 1;
        this.add((Component)nameLabel0, gContents);
        gContents.gridy = 1;
        this.add((Component)descLabel0, gContents);
    }

    public boolean isHighLight() {
        return this.highLight;
    }

    public void setHighLight(boolean highLight) {
        this.highLight = highLight;
    }

    @Override
    public String toString() {
        return this.funcName;
    }

    public void doClick() {
        if (null != this.action) {
            this.action.actionPerformed(null);
        }
    }

    private static class FuncItemMouseAdapter
    extends MouseAdapter {
        private FuncItem item = null;

        public FuncItemMouseAdapter(FuncItem item) {
            this.item = item;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (null != this.item.action) {
                this.item.action.actionPerformed(null);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.item.setCursor(new Cursor(12));
            this.item.setHighLight(true);
            this.item.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.item.setHighLight(false);
            this.item.repaint();
        }
    }
}

