/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.filechooser;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Normalizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import sun.swing.FilePane;

public final class FileChooserWrapper {
    private static final long serialVersionUID = -2439488771343897125L;
    private JTextField fileNameText;
    private JFileChooser chooser;

    private FileChooserWrapper() {
    }

    public static void wrapper(JFileChooser fileChooser) {
        FileChooserWrapper fileChooserWrapper = new FileChooserWrapper();
        fileChooserWrapper.setChooser(fileChooser);
        fileChooserWrapper.getTextField(fileChooser.getComponents());
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }

    public void setChooser(JFileChooser fileChooser) {
        this.chooser = fileChooser;
    }

    public static void setDefaultFileName(String name, JFileChooser fileChooser, boolean isWindowsOS) {
        FileChooserWrapper chooserWrapper = new FileChooserWrapper();
        chooserWrapper.setChooser(fileChooser);
        chooserWrapper.getTextField(fileChooser.getComponents());
        chooserWrapper.changeDoclistener(isWindowsOS);
        chooserWrapper.fileNameText.setText(name);
    }

    private void changeDoclistener(boolean isWindowsOS) {
        AbstractDocument abstracDoc = (AbstractDocument)this.fileNameText.getDocument();
        DocumentListener docListener = ((DocumentListener[])abstracDoc.getListeners(DocumentListener.class))[0];
        this.fileNameText.setDocument(new FileNameDocument(isWindowsOS, this.fileNameText));
        this.fileNameText.getDocument().addDocumentListener(docListener);
    }

    private void getTextField(Component[] allComponents) {
        block0: for (Component comp : allComponents) {
            Component[] subComps;
            if (!(comp instanceof JPanel)) continue;
            for (Component c : subComps = ((JComponent)comp).getComponents()) {
                AbstractButton btn;
                if (c instanceof JTextField) {
                    this.fileNameText = (JTextField)c;
                    this.fileNameText.setName("IsmFileChooser_FileName_Txt");
                    continue block0;
                }
                if (c instanceof JButton) {
                    btn = (JButton)c;
                    this.setBtnSize((JButton)btn);
                    continue;
                }
                if (c instanceof JToggleButton) {
                    if (this.chooser == null) continue;
                    btn = (JToggleButton)c;
                    this.updateListnerViewListner((JToggleButton)btn);
                    continue;
                }
                this.getTextField(subComps);
            }
        }
    }

    public void updateListnerViewListner(JToggleButton btn) {
        if (ResourceUtil.getString("filechooser.prompt.file.listview.tip").equalsIgnoreCase(btn.getToolTipText())) {
            final ActionListener[] listners = btn.getActionListeners();
            btn.removeActionListener(listners[0]);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    listners[0].actionPerformed(actionEvent);
                    FileChooserWrapper.this.handleTableHeader(FileChooserWrapper.this.chooser);
                }
            });
        }
    }

    public void handleTableHeader(JFileChooser chooserName) {
        Component[] allComponents;
        if (chooserName == null) {
            return;
        }
        for (Component component : allComponents = chooserName.getComponents()) {
            JTableHeader tableHeader;
            if (!(component instanceof FilePane) || (tableHeader = FileChooserWrapper.findTableheader(((FilePane)component).getComponents())) == null) continue;
            TableColumnModel tcm = tableHeader.getColumnModel();
            tcm.getColumn(0).setHeaderValue(ResourceUtil.getString("filechooser.prompt.file.name"));
            tcm.getColumn(1).setHeaderValue(ResourceUtil.getString("filechooser.prompt.file.size"));
            tcm.getColumn(2).setHeaderValue(ResourceUtil.getString("filechooser.prompt.file.type"));
            tcm.getColumn(3).setHeaderValue(ResourceUtil.getString("filechooser.prompt.file.date.modified"));
        }
    }

    private static JTableHeader findTableheader(Component[] comps) {
        for (Component cp : comps) {
            JTableHeader result;
            if (cp instanceof JTableHeader) {
                return (JTableHeader)cp;
            }
            if (cp instanceof JPanel) {
                return FileChooserWrapper.findTableheader(((JPanel)cp).getComponents());
            }
            if (cp instanceof JScrollPane) {
                Component[] compss = ((JScrollPane)cp).getComponents();
                return FileChooserWrapper.findTableheader(compss);
            }
            if (!(cp instanceof JViewport) || (result = FileChooserWrapper.findTableheader(((JViewport)cp).getComponents())) == null) continue;
            return result;
        }
        return null;
    }

    private void setBtnSize(JButton btn) {
        if (StringUtils.isNULLStr(btn.getText())) {
            btn.setPreferredSize(new Dimension(24, 16));
        }
    }

    private static class FileNameDocument
    extends PlainDocument {
        private static final long serialVersionUID = -2439488771343897708L;
        private String fileNameRegex = null;
        private JTextField fileNameField = null;

        public FileNameDocument(boolean isWindowsOS, JTextField fileNameField) {
            this.fileNameRegex = isWindowsOS ? "[^|/*?<>\\\"]+" : "[^|*?<>\\\"]+";
            this.fileNameField = fileNameField;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet attributeSet) throws BadLocationException {
            if (!this.checkStr(str)) {
                return;
            }
            String fileNameFieldText = this.fileNameField.getText();
            String s2Value = null;
            s2Value = 0 == offs ? str + fileNameFieldText : (fileNameFieldText.length() == offs ? fileNameFieldText + str : fileNameFieldText.substring(0, offs) + str + fileNameFieldText.substring(offs));
            if ((s2Value = Normalizer.normalize(s2Value, Normalizer.Form.NFKC)).startsWith(".") || s2Value.contains("..")) {
                return;
            }
            super.insertString(offs, str, attributeSet);
        }

        private boolean checkStr(String str) {
            return Normalizer.normalize(str, Normalizer.Form.NFKC).matches(this.fileNameRegex);
        }
    }
}

