/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.huawei.us.common.file.UsFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsFileEasyExcel {
    private static final Logger logger = LoggerFactory.getLogger(UsFileEasyExcel.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readExcel(File file) {
        ExcelReader excelReader = null;
        try {
            excelReader = EasyExcel.read((String)file.getCanonicalPath(), (ReadListener)new NoModelDataListener()).build();
            excelReader.readAll();
        }
        catch (ExcelAnalysisException | IOException e) {
            if ("illegal text found...".equals(e.getMessage())) {
                logger.error("illegal file found...({})", (Object)file.getName());
                String string = "4";
                return string;
            }
            logger.error("easyExcel read file error: {}", (Object)e.getMessage());
        }
        finally {
            if (null != excelReader) {
                excelReader.finish();
            }
        }
        return "0";
    }

    public static class NoModelDataListener
    extends AnalysisEventListener<Map<Integer, String>> {
        public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext analysisContext) {
            ReadRowHolder readRowHolder = analysisContext.readRowHolder();
            Map cellDataMap = readRowHolder.getCellMap();
            this.checkCsvInsert(headMap, cellDataMap);
        }

        public void invoke(Map<Integer, String> data, AnalysisContext analysisContext) {
            ReadRowHolder readRowHolder = analysisContext.readRowHolder();
            Map cellDataMap = readRowHolder.getCellMap();
            this.checkCsvInsert(data, cellDataMap);
        }

        public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        }

        public void onException(Exception exception, AnalysisContext context) throws Exception {
            if ("illegal text found...".equals(exception.getMessage())) {
                throw exception;
            }
        }

        private void checkCsvInsert(Map<Integer, String> data, Map<Integer, Cell> cellDataMap) {
            for (Integer integer : cellDataMap.keySet()) {
                CellData cellData = (CellData)cellDataMap.get(integer);
                CellDataTypeEnum cellType = cellData.getType();
                String value = data.get(integer);
                if (CellDataTypeEnum.STRING.equals((Object)cellType) && cellData.getFormulaData() == null) continue;
                this.checkValue(value);
            }
        }

        private void checkValue(String value) {
            if (StringUtils.isNotEmpty((CharSequence)value) && ("#REF!".equals(value) || !UsFileUtils.validateExcelCellString(value))) {
                throw new ExcelAnalysisException("illegal text found...");
            }
        }
    }
}

