/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.huawei.us.common.file.UsFileUtils;
import com.huawei.us.common.file.bom.ByteOrderMark;
import com.huawei.us.common.file.csv.CsvFileCharset;
import com.huawei.us.common.resource.SystemConfigUtil;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180ParserBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsFileForCsv {
    private static final Logger logger = LoggerFactory.getLogger(UsFileForCsv.class);

    public static String checkCsvFile(File file) {
        Charset bomCharset = ByteOrderMark.getBOMCharset(file);
        if (bomCharset != null) {
            return UsFileForCsv.checkCsvFile(file, bomCharset);
        }
        for (Charset charset : CsvFileCharset.CHARSETS) {
            String result = UsFileForCsv.checkCsvFile(file, charset);
            if ("0".equals(result)) continue;
            return result;
        }
        return "0";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkCsvFile(File file, Charset charset) {
        String escapeChar = SystemConfigUtil.getStringValueByName((String)"csv.file.escape.char", (String)"");
        Object parser = StringUtils.isEmpty((CharSequence)escapeChar) ? new RFC4180ParserBuilder().build() : new CSVParserBuilder().withEscapeChar(escapeChar.charAt(0)).build();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try (FileInputStream fs = new FileInputStream(file);
             InputStreamReader is = new InputStreamReader((InputStream)fs, charset);
             CSVReader reader = new CSVReaderBuilder((Reader)is).withCSVParser((ICSVParser)parser).build();){
            Iterator iterator = reader.iterator();
            block38: while (true) {
                String[] line;
                if ((line = (String[])iterator.next()) == null) return "0";
                String[] stringArray = line;
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block38;
                    String str = stringArray[n2];
                    if (!UsFileUtils.validateExcelCellString(str)) {
                        logger.error("[US-FILE] illegal file found...({})", (Object)file.getName());
                        String string = "4";
                        return string;
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (Throwable e) {
            logger.error("[US-FILE] Parse csv file error: {}", (Object)e.getMessage());
            return "9";
        }
    }
}

