/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.huawei.us.common.file.UsFileUtils;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.xmlbeans.impl.values.XmlValueDisconnectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UsFileForExcel {
    private static final Logger logger = LoggerFactory.getLogger(UsFileForExcel.class);

    UsFileForExcel() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String checkExcelFile(File file) {
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try (FileInputStream fs = new FileInputStream(file);
             Workbook wb = WorkbookFactory.create((InputStream)fs);){
            DataFormatter formatter = new DataFormatter();
            int i = 0;
            while (i < wb.getNumberOfSheets()) {
                String checkResult = UsFileForExcel.checkWorkbook(wb, formatter, i);
                if (!"0".equals(checkResult)) {
                    logger.error("illegal file found...({})", (Object)file.getName());
                    String string = checkResult;
                    return string;
                }
                ++i;
            }
            return "0";
        }
        catch (NoClassDefFoundError e) {
            logger.error("office file found! you need import poi anf poi-ooxml pls!", (Throwable)e);
            return "9";
        }
        catch (Throwable e) {
            logger.error("File parsing failed!", e);
            return "9";
        }
    }

    private static String checkWorkbook(Workbook wb, DataFormatter formatter, int index) {
        Sheet sheet = wb.getSheetAt(index);
        for (int r = 0; r <= sheet.getLastRowNum(); ++r) {
            String checkResult;
            Row row = sheet.getRow(r);
            if (row == null || "0".equals(checkResult = UsFileForExcel.checkWorkbook(row, formatter))) continue;
            logger.error("illegal sheet found...({})", (Object)(index + 1));
            return checkResult;
        }
        return "0";
    }

    private static String checkWorkbook(Row row, DataFormatter formatter) {
        for (int c = 0; c < row.getLastCellNum(); ++c) {
            String cellValue;
            Cell cell = row.getCell(c);
            if (cell == null) continue;
            CellType cellType = cell.getCellType();
            CellStyle cellStyle = cell.getCellStyle();
            if (CellType.STRING.equals((Object)cellType) && ("off".equalsIgnoreCase(SystemConfigUtil.getStringValueByName((String)"is.check.excel.string.value", (String)"off")) || cellStyle != null && (cellStyle.getQuotePrefixed() || 49 == cellStyle.getDataFormat()))) continue;
            try {
                cellValue = formatter.formatCellValue(cell);
            }
            catch (XmlValueDisconnectedException e) {
                cellValue = String.valueOf(cell.getNumericCellValue());
            }
            if (CellType.FORMULA.equals((Object)cellType)) {
                try {
                    cell.setCellType(CellType.STRING);
                    cellValue = cell.getStringCellValue();
                }
                catch (XmlValueDisconnectedException e) {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                }
                if ("#REF!".equals(cellValue)) {
                    logger.error("illegal text found...({},{})", (Object)row.getRowNum(), (Object)c);
                    return "4";
                }
            }
            if (UsFileUtils.validateExcelCellString(cellValue)) continue;
            logger.error("illegal text found...({},{})", (Object)row.getRowNum(), (Object)c);
            return "4";
        }
        return "0";
    }
}

