/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.huawei.us.common.resource.SystemConfigUtil;
import com.huawei.us.common.string.UsStringUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URI;
import java.security.SecureRandom;
import java.text.Normalizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsFileLiteUtils {
    private static final Logger logger = LoggerFactory.getLogger(UsFileLiteUtils.class);
    private static final String[] CROSS_DIRECTORY_ATTACK = new String[]{"/../", "\\..\\"};
    private static final String[] CROSS_DIRECTORY_ATTACK_START = new String[]{"~/", "../", "..\\"};
    private static final String[] CROSS_DIRECTORY_ATTACK_END = new String[]{"/..", "\\.."};

    public static File getFile(String pathname) {
        if (UsFileLiteUtils.isSecurityFileName(pathname)) {
            return new File(pathname);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static File getFile(String parent, String child) {
        String resolvedChild = new File(parent, child).getPath();
        if (UsFileLiteUtils.isSecurityFileName(resolvedChild, parent)) {
            return new File(parent, child);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static File getFile(File parent, String child) {
        try {
            String resolvedChild = new File(parent.getCanonicalPath(), child).getPath();
            if (UsFileLiteUtils.isSecurityFileName(resolvedChild, parent.getPath())) {
                return new File(parent, child);
            }
        }
        catch (IOException e) {
            logger.error("getCanonicalPath failed!", (Throwable)e);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static File getFile(URI uri) {
        if (UsFileLiteUtils.isSecurityFileName(uri.getPath())) {
            return new File(uri);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static File getFile(String ... names) {
        if (names == null) {
            throw new NullPointerException("names must not be null");
        }
        File file = null;
        for (String name : names) {
            file = file == null ? UsFileLiteUtils.getFile(name) : UsFileLiteUtils.getFile(file, name);
        }
        return file;
    }

    public static FileInputStream getFileInputStream(String name) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(name)) {
            return new FileInputStream(name);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new FileInputStream(file);
        }
        throw new IllegalArgumentException("invalid character in path");
    }

    public static FileInputStream getFileInputStream(FileDescriptor fdObj) {
        return new FileInputStream(fdObj);
    }

    public static FileOutputStream getFileOutputStream(String name) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(name)) {
            return new FileOutputStream(name);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileOutputStream getFileOutputStream(String name, boolean append) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(name)) {
            return new FileOutputStream(name, append);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileOutputStream getFileOutputStream(File file) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new FileOutputStream(file);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileOutputStream getFileOutputStream(File file, boolean append) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new FileOutputStream(file, append);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileOutputStream getFileOutputStream(FileDescriptor fdObj) {
        return new FileOutputStream(fdObj);
    }

    public static FileReader getFileReader(String name) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(name)) {
            return new FileReader(name);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileReader getFileReader(File file) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new FileReader(file);
        }
        throw new IllegalArgumentException("invalid character in path");
    }

    public static FileReader getFileReader(FileDescriptor fdObj) {
        return new FileReader(fdObj);
    }

    public static FileWriter getFileWriter(String name) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(name)) {
            return new FileWriter(name);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileWriter getFileWriter(String name, boolean append) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(name)) {
            return new FileWriter(name, append);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileWriter getFileWriter(File file) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new FileWriter(file);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileWriter getFileWriter(File file, boolean append) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new FileWriter(file, append);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FileWriter getFileWriter(FileDescriptor fdObj) {
        return new FileWriter(fdObj);
    }

    public static PrintWriter getPrintWriter(File file) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new PrintWriter(file);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static PrintWriter getPrintWriter(File file, String csn) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new PrintWriter(file, csn);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static PrintWriter getPrintWriter(String fileName) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(fileName)) {
            return new PrintWriter(fileName);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static PrintWriter getPrintWriter(String fileName, String csn) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(fileName)) {
            return new PrintWriter(fileName, csn);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static PrintWriter getPrintWriter(Writer out) {
        return new PrintWriter(out);
    }

    public static PrintWriter getPrintWriter(Writer out, boolean autoFlush) {
        return new PrintWriter(out, autoFlush);
    }

    public static PrintWriter getPrintWriter(OutputStream out) {
        return new PrintWriter(out);
    }

    public static PrintWriter getPrintWriter(OutputStream out, boolean autoFlush) {
        return new PrintWriter(out, autoFlush);
    }

    public static PrintStream getPrintStream(File file) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new PrintStream(file);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static PrintStream getPrintStream(File file, String csn) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new PrintStream(file, csn);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static PrintStream getPrintStream(String fileName) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(fileName)) {
            return new PrintStream(fileName);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static PrintStream getPrintStream(String fileName, String csn) throws IOException {
        if (UsFileLiteUtils.isSecurityFileName(fileName)) {
            return new PrintStream(fileName, csn);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static PrintStream getPrintStream(OutputStream out) {
        return new PrintStream(out);
    }

    public static PrintStream getPrintStream(OutputStream out, boolean autoFlush) {
        return new PrintStream(out, autoFlush);
    }

    public static PrintStream getPrintStream(OutputStream out, boolean autoFlush, String encoding) throws IOException {
        return new PrintStream(out, autoFlush, encoding);
    }

    public static RandomAccessFile getRandomAccessFile(String fileName, String mode) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(fileName)) {
            return new RandomAccessFile(fileName, mode);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static RandomAccessFile getRandomAccessFile(File file, String mode) throws FileNotFoundException {
        if (UsFileLiteUtils.isSecurityFileName(file.getPath())) {
            return new RandomAccessFile(file, mode);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static FilePermission getFilePermission(String fileName, String actions) {
        if (UsFileLiteUtils.isSecurityFileName(fileName)) {
            return new FilePermission(fileName, actions);
        }
        throw new IllegalArgumentException("invalid character in pathname");
    }

    public static boolean isSecurityFileName(String fileName, String tempDir) {
        fileName = UsFileLiteUtils.normalizeString(fileName);
        tempDir = UsFileLiteUtils.normalizeString(tempDir);
        if (StringUtils.isNotEmpty((CharSequence)fileName) && fileName.startsWith(" ")) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)tempDir) && tempDir.startsWith(" ")) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)tempDir)) {
            try {
                File file = new File(fileName);
                File tf = new File(tempDir);
                return file.getCanonicalPath().startsWith(tf.getCanonicalPath()) && UsFileLiteUtils.isSecurityFileName(tempDir);
            }
            catch (IOException e) {
                logger.error("checkFile failed: isSecurityFileName", (Throwable)e);
                return false;
            }
        }
        return UsFileLiteUtils.isSecurityFileName(fileName);
    }

    public static boolean isSecurityFileName(String fileName) {
        if (StringUtils.isEmpty((CharSequence)(fileName = UsFileLiteUtils.normalizeString(fileName)))) {
            return true;
        }
        if (!UsFileLiteUtils.checkPath(fileName)) {
            return false;
        }
        if (UsFileLiteUtils.isCrossDirAttack(fileName)) {
            logger.error("fileName or filePath isCrossDirAttack failed!");
            return false;
        }
        return true;
    }

    public static boolean isNoAttackFileName(String fileName) {
        if (StringUtils.isEmpty((CharSequence)(fileName = UsFileLiteUtils.normalizeString(fileName)))) {
            return true;
        }
        return !UsFileLiteUtils.isCrossDirAttack(fileName);
    }

    private static boolean isCrossDirAttack(String fileName) {
        String crossDirAttackCharacter = SystemConfigUtil.getStringValueByName((String)"cross.directory.attack.character", (String)"~/;\\../;/..\\;.'';''.");
        if (StringUtils.isNotEmpty((CharSequence)crossDirAttackCharacter)) {
            String[] crossDirAttackCharacters;
            String[] stringArray = crossDirAttackCharacters = crossDirAttackCharacter.split(";");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String aCheckStr = stringArray[i];
                if (!StringUtils.contains((CharSequence)fileName, (CharSequence)aCheckStr)) continue;
                return true;
            }
        }
        for (String aCheckStr : CROSS_DIRECTORY_ATTACK) {
            if (!StringUtils.contains((CharSequence)fileName, (CharSequence)aCheckStr)) continue;
            return true;
        }
        for (String aCheckStr : CROSS_DIRECTORY_ATTACK_START) {
            if (!fileName.startsWith(aCheckStr)) continue;
            return true;
        }
        for (String aCheckStr : CROSS_DIRECTORY_ATTACK_END) {
            if (!fileName.endsWith(aCheckStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPath(String fileName) {
        String whiteList;
        String blackList = SystemConfigUtil.getStringValueByName((String)"file.path.check.black.list", (String)"");
        if (StringUtils.isNotEmpty((CharSequence)blackList)) {
            String[] urlList;
            for (String s : urlList = UsStringUtils.strToArray((String)blackList)) {
                if (!UsFileLiteUtils.isChildPath(s, fileName)) continue;
                logger.error("fileName or filePath is in the file.path.check.black.list!");
                return false;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(whiteList = SystemConfigUtil.getStringValueByName((String)"file.path.check.white.list", (String)"")))) {
            String[] urlList;
            for (String s : urlList = UsStringUtils.strToArray((String)whiteList)) {
                if (!UsFileLiteUtils.isChildPath(s, fileName)) continue;
                return true;
            }
            logger.error("fileName or filePath is not in the file.path.check.white.list!");
            return false;
        }
        return true;
    }

    public static boolean isChildPath(String dir, String fileName) {
        String sep = File.separator;
        if (StringUtils.isNotEmpty((CharSequence)dir) && !dir.endsWith(sep)) {
            dir = dir + sep;
        }
        return fileName.startsWith(dir);
    }

    public static boolean secureDelete(String fileName) {
        return UsFileLiteUtils.secureDelete(UsFileLiteUtils.getFile(fileName));
    }

    public static boolean secureDelete(File file) {
        if (file.exists()) {
            long i;
            byte[] temp2;
            Throwable throwable;
            FileOutputStream out;
            long fileLength = file.length();
            long count = fileLength / 1024L;
            try {
                out = new FileOutputStream(file);
                throwable = null;
                try {
                    temp2 = UsFileLiteUtils.getByte((byte)0);
                    for (i = 0L; i <= count; ++i) {
                        ((OutputStream)out).write(temp2, 0, temp2.length);
                    }
                }
                catch (Throwable temp2) {
                    throwable = temp2;
                    throw temp2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable temp2) {
                                throwable.addSuppressed(temp2);
                            }
                        } else {
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error("delete file failed!", (Throwable)e);
            }
            try {
                out = new FileOutputStream(file);
                throwable = null;
                try {
                    temp2 = UsFileLiteUtils.getByte((byte)1);
                    for (i = 0L; i <= count; ++i) {
                        ((OutputStream)out).write(temp2, 0, temp2.length);
                    }
                }
                catch (Throwable temp3) {
                    throwable = temp3;
                    throw temp3;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable temp3) {
                                throwable.addSuppressed(temp3);
                            }
                        } else {
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error("delete file failed!", (Throwable)e);
            }
            try {
                out = new FileOutputStream(file);
                throwable = null;
                try {
                    temp2 = UsFileLiteUtils.getByte((byte)3);
                    for (i = 0L; i <= count; ++i) {
                        ((OutputStream)out).write(temp2, 0, temp2.length);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error("delete file failed!", (Throwable)e);
            }
            return file.delete();
        }
        return false;
    }

    private static byte[] getByte(byte value) {
        byte[] temp = new byte[1024];
        if (3 == value) {
            SecureRandom secureRandom = new SecureRandom();
            for (int i = 0; i < 1024; ++i) {
                temp[i] = (byte)secureRandom.nextInt();
            }
            return temp;
        }
        for (int i = 0; i < 1024; ++i) {
            temp[i] = value;
        }
        return temp;
    }

    public static String normalizeString(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Normalizer.normalize(str, Normalizer.Form.NFC);
        }
        return str;
    }
}

