/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.alibaba.excel.analysis.v07.handlers.sax.SharedStringsTableHandler;
import com.alibaba.excel.cache.ReadCache;
import com.alibaba.excel.cache.selector.SimpleReadCacheSelector;
import com.huawei.us.common.file.api.OverrideProps;
import com.huawei.us.common.file.excel.XlsxSheetHandler;
import com.huawei.us.common.file.exception.CsvInjectionException;
import com.huawei.us.common.file.exception.ExcelParseException;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalLink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.ExternalLinkDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class UsFileSaxParser {
    private static final Logger logger = LoggerFactory.getLogger(UsFileSaxParser.class);
    private static final String SAX_PARSER_FACTORY = SystemConfigUtil.getStringValueByName((String)"sax.parser.factory", (String)"");
    private static final PackagePartName SHARED_STRINGS_PART_NAME;

    public static String checkXlsxFile(File file) {
        return UsFileSaxParser.checkXlsxFile(file, OverrideProps.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String checkXlsxFile(File file, OverrideProps props) {
        ReadCache readCache = null;
        try (OPCPackage pkg = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            UsFileSaxParser.checkDdeLink(pkg);
            readCache = UsFileSaxParser.getReadCache(pkg);
            XSSFReader reader = new XSSFReader(pkg);
            StylesTable stylesTable = reader.getStylesTable();
            Iterator sheets = reader.getSheetsData();
            while (sheets.hasNext()) {
                InputStream sheet = (InputStream)sheets.next();
                UsFileSaxParser.parseXmlSource(sheet, new XlsxSheetHandler(readCache, stylesTable, props));
            }
        }
        catch (CsvInjectionException e) {
            String string = "4";
            return string;
        }
        catch (Throwable e) {
            logger.error("[US-FILE] Parse file failed: ", e);
        }
        finally {
            if (readCache != null) {
                try {
                    readCache.destroy();
                }
                catch (Throwable e) {
                    logger.error("Can not close IO.", e);
                }
            }
        }
        return "0";
    }

    private static ReadCache getReadCache(OPCPackage pkg) throws IOException, ParserConfigurationException, SAXException {
        PackagePart sharedStringsTablePackagePart = pkg.getPart(SHARED_STRINGS_PART_NAME);
        if (sharedStringsTablePackagePart != null) {
            ReadCache readCache = new SimpleReadCacheSelector().readCache(sharedStringsTablePackagePart);
            readCache.init(null);
            SharedStringsTableHandler handler = new SharedStringsTableHandler(readCache);
            UsFileSaxParser.parseXmlSource(sharedStringsTablePackagePart.getInputStream(), (ContentHandler)handler);
            readCache.putFinished();
            return readCache;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseXmlSource(InputStream inputStream, ContentHandler handler) throws IOException, SAXException, ParserConfigurationException {
        try {
            InputSource inputSource = new InputSource(inputStream);
            SAXParserFactory saxFactory = StringUtils.isNotEmpty((CharSequence)SAX_PARSER_FACTORY) ? SAXParserFactory.newInstance(SAX_PARSER_FACTORY, null) : SAXParserFactory.newInstance();
            try {
                saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException e) {
                logger.error("[US-FILE] Failed to set Feature: ", (Throwable)e);
            }
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(inputSource);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new ExcelParseException("Can not close 'inputStream'!", e);
                }
            }
        }
    }

    private static void checkDdeLink(OPCPackage pkg) throws XmlException, IOException {
        ArrayList packageParts = pkg.getPartsByContentType(XSSFRelation.EXTERNAL_LINKS.getContentType());
        for (PackagePart packagePart : packageParts) {
            InputStream in = packagePart.getInputStream();
            Throwable throwable = null;
            try {
                ExternalLinkDocument doc = (ExternalLinkDocument)ExternalLinkDocument.Factory.parse(in, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                CTExternalLink link = doc.getExternalLink();
                if (link == null || !link.isSetDdeLink()) continue;
                logger.error("[US-FILE] DDE link find in xlsx file.");
                throw new CsvInjectionException("dde link find in xlsx file.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    static {
        try {
            SHARED_STRINGS_PART_NAME = PackagingURIHelper.createPartName((String)"/xl/sharedStrings.xml");
        }
        catch (InvalidFormatException e) {
            logger.error("Initialize the XlsxSaxParser failure", (Throwable)e);
            throw new ExcelParseException("Initialize the XlsxParser failure", e);
        }
    }
}

