/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.huawei.us.common.file.api.OverrideProps;
import com.huawei.us.common.file.excel.XlsxValidator;
import com.huawei.us.common.file.exception.CsvInjectionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UsFileSaxXlsParser
implements HSSFListener {
    private static final Logger logger = LoggerFactory.getLogger(UsFileSaxXlsParser.class);
    private static final short textFormatIndex = 49;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord = null;
    private final List<ExtendedFormatRecord> xfRecords = new ArrayList<ExtendedFormatRecord>();
    private OverrideProps props;

    UsFileSaxXlsParser() {
    }

    void check(File file, OverrideProps props) throws IOException {
        this.props = props;
        try (POIFSFileSystem fs = new POIFSFileSystem(file);){
            MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
            FormatTrackingHSSFListener formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
            this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)formatListener);
            HSSFEventFactory factory = new HSSFEventFactory();
            HSSFRequest request = new HSSFRequest();
            request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
            factory.processWorkbookEvents(request, fs);
        }
    }

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 2057: {
                this.setStubWorkbook(record);
                break;
            }
            case 224: {
                this.xfRecords.add((ExtendedFormatRecord)record);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 6: {
                this.checkFormulaRecord(record);
                break;
            }
            case 253: {
                this.checkSSTRecord(record);
                break;
            }
        }
    }

    private void setStubWorkbook(Record record) {
        BOFRecord br = (BOFRecord)record;
        if (br.getType() == 16 && this.workbookBuildingListener != null && this.stubWorkbook == null) {
            this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
        }
    }

    private void checkSSTRecord(Record record) {
        String stringValue;
        if (!this.props.isCheckExcelStringValue()) {
            return;
        }
        LabelSSTRecord strRecord = (LabelSSTRecord)record;
        ExtendedFormatRecord xfRecord = this.xfRecords.get(strRecord.getXFIndex());
        if (xfRecord != null && (49 == xfRecord.getFormatIndex() || xfRecord.get123Prefix())) {
            return;
        }
        if (this.sstRecord != null && !XlsxValidator.validateStringValue(stringValue = this.sstRecord.getString(strRecord.getSSTIndex()).toString())) {
            logger.error("illegal text found.");
            throw new CsvInjectionException("illegal text found.");
        }
    }

    private void checkFormulaRecord(Record record) {
        FormulaRecord formula = (FormulaRecord)record;
        String formulaValue = null;
        CellType cellType = formula.getCachedResultTypeEnum();
        try {
            formulaValue = HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])formula.getParsedExpression());
        }
        catch (Throwable e) {
            logger.debug("Get formula value error.", e);
        }
        switch (cellType) {
            case ERROR: {
                this.checkErrorFormulaRecord(formula, formulaValue);
                break;
            }
            case STRING: {
                if (XlsxValidator.validateStringValue(formulaValue)) break;
                throw new CsvInjectionException("illegal text found.");
            }
        }
    }

    private void checkErrorFormulaRecord(FormulaRecord formula, String formulaValue) {
        if (formulaValue == null) {
            try {
                formulaValue = FormulaError.forInt((int)formula.getCachedErrorValue()).getString();
            }
            catch (Throwable e) {
                logger.debug("[US-FILE] get formula value error.");
                return;
            }
            if ("#REF!".equals(formulaValue)) {
                throw new CsvInjectionException("illegal text found.");
            }
        }
    }
}

