/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.us.common.file.UsFileExcelUtils;
import com.huawei.us.common.file.UsFileForCompress;
import com.huawei.us.common.file.UsFileForCsv;
import com.huawei.us.common.file.UsFileForRar;
import com.huawei.us.common.file.UsFileForSevenZ;
import com.huawei.us.common.file.UsFileLiteUtils;
import com.huawei.us.common.file.UsFileWsfTools;
import com.huawei.us.common.file.api.CompressedFileCheckList;
import com.huawei.us.common.file.api.FileParameter;
import com.huawei.us.common.file.api.OverrideProps;
import com.huawei.us.common.file.csv.CsvFileReader;
import com.huawei.us.common.resource.SystemConfigUtil;
import com.huawei.us.common.string.UsStringUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsFileUtils {
    public static final String FILE_CHECK_OK = "0";
    public static final String FILE_NAME_ERROR = "1";
    public static final String FILE_TYPE_ERROR = "2";
    public static final String FILE_SIZE_ERROR = "3";
    public static final String FILE_INJECTION_ERROR = "4";
    public static final String FILE_TYPE_NOT_SUPPORTED_RAR5_ERROR = "2001";
    public static final String FILE_IO_ERROR = "9";
    private static final Logger logger = LoggerFactory.getLogger(UsFileUtils.class);
    private static final String TMP_TYPE = "tmp";
    private static final int FILE_TYPE_MAX_LENGTH = 100;
    private static final char[] CSV_ILLEGAL_CHAR = new char[]{'+', '=', '@'};
    private static final String ZIP_TYPE = "zip";
    private static final String TAR_BZ_TYPE = "tar.bz2";
    private static final String TAR_GZ_TYPE = "tar.gz";
    private static final String TGZ_TYPE = "tgz";
    private static final String TAR_TYPE = "tar";
    private static final String JAR_TYPE = "jar";
    private static final String RAR_TYPE = "rar";
    private static final String GZ_TYPE = "gz";
    private static final String BZ2_TYPE = "bz2";
    private static final String SEVEN_Z_TYPE = "7z";
    private static final String WHL_TYPE = "whl";
    private static final String WAR_TYPE = "war";
    private static final String[] COMPRESSED_TYPE = new String[]{"rar", "zip", "tar.bz2", "tar.gz", "tar", "jar", "gz", "tgz", "bz2", "7z", "whl", "war"};
    private static final String CAR_TYPE = "car";
    private static final String CAB_TYPE = "cab";
    private static final String[] NONSUPPORT_COMPRESSED_TYPE = new String[]{"car", "cab"};
    private static final String CSV_TYPE = "csv";
    public static final String XLSX_TYPE = "xlsx";
    public static final String XLS_TYPE = "xls";
    private static final String[] CSV_FILE_TYPE = new String[]{"csv", "xls", "xlsx"};
    private static Map<String, String> fileTypeMap = new HashMap<String, String>();

    public static String checkFile(String fileName, String fileType, long size) {
        return UsFileUtils.checkFile(fileName, fileType, size, null, UsStringUtils.strToArray((String)SystemConfigUtil.getStringValueByName((String)"us.file.trusted_file_type", (String)"txt,xml,json,xls,xlsx,doc,docx,csv,png,jpg,bmp")));
    }

    public static String checkFile(String fileName, String tempDir, String fileType, long size) {
        return UsFileUtils.checkFile(fileName, tempDir, fileType, size, null, UsStringUtils.strToArray((String)SystemConfigUtil.getStringValueByName((String)"us.file.trusted_file_type", (String)"txt,xml,json,xls,xlsx,doc,docx,csv,png,jpg,bmp")));
    }

    public static String checkFile(String fileName, String fileType, long size, Charset charset) {
        return UsFileUtils.checkFile(fileName, fileType, size, charset, UsStringUtils.strToArray((String)SystemConfigUtil.getStringValueByName((String)"us.file.trusted_file_type", (String)"txt,xml,json,xls,xlsx,doc,docx,csv,png,jpg,bmp")));
    }

    public static String checkFile(String fileName, String tempDir, String fileType, long size, Charset charset) {
        return UsFileUtils.checkFile(fileName, tempDir, fileType, size, charset, UsStringUtils.strToArray((String)SystemConfigUtil.getStringValueByName((String)"us.file.trusted_file_type", (String)"txt,xml,json,xls,xlsx,doc,docx,csv,png,jpg,bmp")));
    }

    public static String checkFile(String fileName, String fileType, long size, String ... subFileTypes) {
        return UsFileUtils.checkFile(fileName, fileType, size, null, subFileTypes);
    }

    public static String checkFile(String fileName, String fileType, long size, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        return UsFileUtils.checkFile(fileName, null, fileType, fileType, size, null, null, checkSubFileByWhiteList, subFileTypes);
    }

    public static String checkFile(String fileName, String tempDir, String fileType, long size, String ... subFileTypes) {
        return UsFileUtils.checkFile(fileName, tempDir, fileType, size, null, subFileTypes);
    }

    public static String checkFile(String fileName, String fileType, long size, Charset charset, String ... subFileTypes) {
        return UsFileUtils.checkFile(fileName, null, fileType, fileType, size, charset, subFileTypes);
    }

    public static String checkFile(String fileName, String tempDir, String fileType, long size, Charset charset, String ... subFileTypes) {
        return UsFileUtils.checkFile(fileName, tempDir, fileType, fileType, size, charset, subFileTypes);
    }

    public static String checkFile(String fileName, String tempDir, String fileType, String realFileType, long size, Charset charset, String ... subFileTypes) {
        return UsFileUtils.checkFile(fileName, tempDir, fileType, realFileType, size, charset, null, true, subFileTypes);
    }

    public static String checkFile(String fileName, String tempDir, String fileType, String realFileType, long size, Charset charset, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        return UsFileUtils.checkFile(fileName, tempDir, fileType, realFileType, size, charset, null, checkSubFileByWhiteList, subFileTypes);
    }

    public static String checkFile(String fileName, String tempDir, String fileType, String realFileType, long size, Charset charset, String isCheckCsv, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        return UsFileUtils.checkFile(fileName, tempDir, fileType, realFileType, size, 0L, charset, isCheckCsv, checkSubFileByWhiteList, subFileTypes);
    }

    public static String checkFile(String fileName, String tempDir, String fileType, String realFileType, long size, long compressedSize, Charset charset, String isCheckCsv, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        try {
            String result;
            fileName = UsFileUtils.normalizeString(fileName);
            fileType = UsFileUtils.normalizeString(fileType).toLowerCase();
            realFileType = UsFileUtils.normalizeString(realFileType).toLowerCase();
            subFileTypes = UsFileUtils.normalizeString(subFileTypes);
            if (!UsFileLiteUtils.isSecurityFileName(fileName, tempDir)) {
                logger.error("checkFile failed: FILE_NAME_ERROR");
                return FILE_NAME_ERROR;
            }
            File file = new File(fileName);
            if (!file.exists()) {
                logger.error("checkFile failed: file not exists, {}", (Object)fileName);
                return FILE_IO_ERROR;
            }
            if (UsFileUtils.chekFileType(fileName, fileType, realFileType)) {
                return FILE_TYPE_ERROR;
            }
            if (UsFileUtils.isCompressedFile(realFileType)) {
                if (compressedSize > 0L && !UsFileUtils.checkFileSize(file, compressedSize)) {
                    return FILE_SIZE_ERROR;
                }
                result = UsFileUtils.checkCompressedFile(file, realFileType, size, Long.parseLong(SystemConfigUtil.getStringValueByName((String)"us.file.file_number_limit", (String)"10240")), charset, isCheckCsv, checkSubFileByWhiteList, subFileTypes);
                if (!FILE_CHECK_OK.equals(result)) {
                    logger.error("checkFile failed: {}", (Object)result);
                    return result;
                }
            } else if (!UsFileUtils.checkFileSize(file, size)) {
                return FILE_SIZE_ERROR;
            }
            if (UsFileUtils.isCsvOrExcelFile(realFileType) && "on".equalsIgnoreCase(SystemConfigUtil.getStringValueByName((String)"is.check.csv", (String)"on")) && !"off".equalsIgnoreCase(isCheckCsv) && !FILE_CHECK_OK.equals(result = UsFileUtils.checkFileCvsInjection(file, realFileType))) {
                logger.error("checkFile failed: {}", (Object)result);
                return result;
            }
            return UsFileUtils.checkFileByWSF(file, realFileType, size);
        }
        catch (Throwable e) {
            logger.error("checkFile failed", e);
            return FILE_IO_ERROR;
        }
    }

    public static String checkFile(FileParameter parameter, OverrideProps props) {
        try {
            String result;
            UsFileUtils.buildParameter(parameter);
            props = props != null ? props : OverrideProps.builder().build();
            String fileName = parameter.getFileName();
            String fileType = parameter.getFileType();
            String realFileType = parameter.getRealFileType();
            long size = parameter.getSize();
            long compressedSize = parameter.getCompressedSize();
            Charset charset = parameter.getCharset();
            boolean checkSubFileByWhiteList = parameter.getCheckSubFileByWhiteList();
            String[] subFileTypes = parameter.getSubFileType();
            if (!UsFileLiteUtils.isSecurityFileName(fileName)) {
                logger.error("[US-FILE] Check file name failed: {}", (Object)fileName);
                return FILE_NAME_ERROR;
            }
            File file = new File(fileName);
            if (!file.exists()) {
                logger.error("[US-FILE] Check file failed: file not exists, {}", (Object)fileName);
                return FILE_IO_ERROR;
            }
            if (UsFileUtils.chekFileType(fileName, fileType, realFileType)) {
                return FILE_TYPE_ERROR;
            }
            if (UsFileUtils.isCompressedFile(realFileType)) {
                if (compressedSize > 0L && !UsFileUtils.checkFileSize(file, compressedSize)) {
                    return FILE_SIZE_ERROR;
                }
                result = UsFileUtils.checkCompressedFile(file, realFileType, size, Long.parseLong(SystemConfigUtil.getStringValueByName((String)"us.file.file_number_limit", (String)"10240")), charset, checkSubFileByWhiteList, subFileTypes, props);
                if (!FILE_CHECK_OK.equals(result)) {
                    logger.error("[US-FILE] Check file failed: {}, file name: {}", (Object)result, (Object)fileName);
                    return result;
                }
            } else if (!UsFileUtils.checkFileSize(file, size)) {
                return FILE_SIZE_ERROR;
            }
            if (!FILE_CHECK_OK.equals(result = UsFileUtils.checkFileCvsInjection(file, realFileType, props))) {
                logger.error("[US-FILE] Check file failed: {}, file name: {}", (Object)result, (Object)fileName);
                return result;
            }
            return UsFileUtils.checkFileByWSF(file, realFileType, size);
        }
        catch (Throwable e) {
            logger.error("[US-FILE] Check file failed", e);
            return FILE_IO_ERROR;
        }
    }

    private static String checkFileByWSF(File file, String realFileType, long size) throws FileNotFoundException, RuleLoadingException {
        try {
            Class.forName("com.huawei.security.checkengine.RuleEngineManager");
            if ("on".equals(SystemConfigUtil.getStringValueByName((String)"is.check.file.by.wsf", (String)"on")) && file.length() > 0L) {
                return UsFileWsfTools.checkFileByWsf(file, realFileType, size);
            }
            logger.warn("if you want to use wsf to check file, please open is.check.file.by.wsf property.");
        }
        catch (ClassNotFoundException e) {
            logger.warn("if you want to use wsf to check file, please import huawei-secure-checkengine", (Throwable)e);
        }
        return FILE_CHECK_OK;
    }

    private static boolean chekFileType(String fileName, String fileType, String realFileType) {
        if (!UsFileUtils.checkFileType(fileName, fileType)) {
            logger.error("checkFile failed: FILE_TYPE_ERROR");
            return true;
        }
        if (!UsFileUtils.isSecFileType(realFileType)) {
            logger.error("realFileType is not security!");
            return true;
        }
        if (UsFileUtils.isUnSupportCompressedFile(realFileType)) {
            logger.error("unsupported compressed file type found!");
            return true;
        }
        if (!UsFileUtils.checkFileHeader(fileName, realFileType)) {
            logger.error("checkFile failed: FILE_HEADER_ERROR");
            return true;
        }
        return false;
    }

    private static void buildParameter(FileParameter parameter) {
        parameter.setFileName(UsFileUtils.normalizeString(parameter.getFileName()));
        parameter.setFileType(UsFileUtils.normalizeString(parameter.getFileType()).toLowerCase(Locale.ENGLISH));
        if (parameter.getRealFileType() == null) {
            parameter.setRealFileType(parameter.getFileType());
        } else {
            parameter.setRealFileType(UsFileUtils.normalizeString(parameter.getRealFileType()).toLowerCase(Locale.ENGLISH));
        }
        if (parameter.getCheckSubFileByWhiteList() == null) {
            parameter.setCheckSubFileByWhiteList(true);
        }
        parameter.setSubFileType(UsFileUtils.normalizeString(parameter.getSubFileType()));
    }

    public static String getFileType(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName) || StringUtils.lastIndexOf((CharSequence)fileName, (CharSequence)".") < 0) {
            return null;
        }
        return fileName.substring(StringUtils.lastIndexOf((CharSequence)fileName, (CharSequence)".") + 1);
    }

    public static String checkInputStream(InputStream inputStream, String fileName, String fileType, long size) {
        return UsFileUtils.checkInputStream(inputStream, fileName, fileType, size, null, UsStringUtils.strToArray((String)SystemConfigUtil.getStringValueByName((String)"us.file.trusted_file_type", (String)"txt,xml,json,xls,xlsx,doc,docx,csv,png,jpg,bmp")));
    }

    public static String checkInputStream(InputStream inputStream, String fileName, String fileType, long size, String ... subFileTypes) {
        return UsFileUtils.checkInputStream(inputStream, fileName, fileType, size, null, subFileTypes);
    }

    public static String checkInputStream(InputStream inputStream, String fileName, String fileType, long size, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        return UsFileUtils.checkInputStream(inputStream, fileName, fileType, size, null, null, checkSubFileByWhiteList, subFileTypes);
    }

    public static String checkInputStream(InputStream inputStream, String fileName, String fileType, long size, Charset charset, String ... subFileTypes) {
        return UsFileUtils.checkInputStream(inputStream, fileName, fileType, size, charset, null, true, subFileTypes);
    }

    public static String checkInputStream(InputStream inputStream, String fileName, String fileType, long size, Charset charset, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        return UsFileUtils.checkInputStream(inputStream, fileName, fileType, size, charset, null, checkSubFileByWhiteList, subFileTypes);
    }

    public static String checkInputStream(InputStream inputStream, String fileName, String fileType, long size, Charset charset, String isCheckCsv, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        return UsFileUtils.checkInputStream(inputStream, fileName, fileType, size, charset, isCheckCsv, null, checkSubFileByWhiteList, subFileTypes);
    }

    public static String checkInputStream(InputStream inputStream, String fileName, String fileType, long size, Charset charset, String isCheckCsv, String targetFilePath, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        return UsFileUtils.checkInputStream(inputStream, fileName, fileType, size, 0L, charset, isCheckCsv, targetFilePath, checkSubFileByWhiteList, subFileTypes);
    }

    public static String checkInputStream(InputStream inputStream, String fileName, String fileType, long size, long compressedSize, Charset charset, String isCheckCsv, String targetFilePath, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        String tempDir;
        fileName = UsFileUtils.normalizeString(fileName);
        fileType = UsFileUtils.normalizeString(fileType).toLowerCase();
        subFileTypes = UsFileUtils.normalizeString(subFileTypes);
        if (!UsFileUtils.checkFileType(fileName, fileType)) {
            logger.error("checkFile failed: FILE_TYPE_ERROR");
            return FILE_TYPE_ERROR;
        }
        String tmpDirPrefix = SystemConfigUtil.getStringValueByName((String)"us.file.check.temp.dir", (String)"");
        if (StringUtils.isEmpty((CharSequence)tmpDirPrefix)) {
            tmpDirPrefix = UsFileUtils.createTempDir();
        }
        if (!UsFileLiteUtils.isSecurityFileName(tempDir = tmpDirPrefix + File.separator + UUID.randomUUID().toString()) && !UsFileLiteUtils.isSecurityFileName(targetFilePath)) {
            logger.error("checkFile failed: FILE_NAME_ERROR");
            return FILE_NAME_ERROR;
        }
        File tempDirFile = new File(tempDir);
        if (!tempDirFile.mkdir()) {
            try {
                logger.error("mkdir failed: {}", (Object)tempDirFile.getCanonicalPath());
            }
            catch (IOException e) {
                logger.error("getCanonicalPath failed!", (Throwable)e);
                return FILE_IO_ERROR;
            }
            return FILE_IO_ERROR;
        }
        if (inputStream.markSupported()) {
            inputStream.mark(Integer.MAX_VALUE);
        } else {
            logger.warn("InputStream Cannot be reset!");
        }
        String result = UsFileUtils.dealTempFile(tempDir, tempDirFile, inputStream, fileType, size, compressedSize, charset, isCheckCsv, checkSubFileByWhiteList, targetFilePath, subFileTypes);
        if (!FILE_CHECK_OK.equals(result)) {
            return result;
        }
        return FILE_CHECK_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dealTempFile(String tempDir, File tempDirFile, InputStream inputStream, String fileType, long size, long compressedSize, Charset charset, String isCheckCsv, boolean checkSubFileByWhiteList, String targetPath, String ... subFileTypes) {
        String result = FILE_CHECK_OK;
        int buffer = Integer.parseInt(SystemConfigUtil.getStringValueByName((String)"us.file.extract_buffer_size", (String)"512"));
        boolean finallyFailed = false;
        FileOutputStream outputStream = null;
        File temp = UsFileUtils.getFile(tempDir + File.separator + UUID.randomUUID().toString() + "." + TMP_TYPE);
        try {
            outputStream = new FileOutputStream(temp);
            byte[] buf = new byte[buffer];
            int count = 0;
            while (true) {
                if ((long)(buffer * count) > size) {
                    logger.error("checkFile failed: FILE_SIZE_ERROR");
                    String string = FILE_SIZE_ERROR;
                    return string;
                }
                int read = inputStream.read(buf);
                if (read == -1) break;
                outputStream.write(buf, 0, read);
                ++count;
            }
            result = UsFileUtils.checkFile(temp.getCanonicalPath(), null, TMP_TYPE, fileType, size, compressedSize, charset, isCheckCsv, checkSubFileByWhiteList, subFileTypes);
            if (!FILE_CHECK_OK.equals(result)) {
                String string = result;
                return string;
            }
        }
        catch (Throwable e) {
            logger.error("checkFile failed", e);
            String string = FILE_IO_ERROR;
            return string;
        }
        finally {
            try {
                UsFileUtils.closeStream(inputStream, outputStream);
                if (FILE_CHECK_OK.equals(result) && StringUtils.isNotEmpty((CharSequence)targetPath)) {
                    UsFileUtils.copyfile(temp, new File(targetPath));
                }
                UsFileUtils.deleteDir(tempDirFile);
            }
            catch (IOException e) {
                logger.error("checkFile failed", (Throwable)e);
                finallyFailed = true;
            }
        }
        if (finallyFailed) {
            return FILE_IO_ERROR;
        }
        return FILE_CHECK_OK;
    }

    private static void copyfile(File source, File dest) throws IOException {
        if (dest.exists()) {
            logger.error("the targetFile is already exist,please check the targetFilePath!");
            throw new IOException("targetFile is already exist");
        }
        UsFileUtils.makeDirIfNotExist(dest.getParentFile().getCanonicalPath());
        try (FileChannel input = new FileInputStream(source).getChannel();
             FileChannel output = new FileOutputStream(dest).getChannel();){
            output.transferFrom(input, 0L, input.size());
        }
    }

    private static void closeStream(InputStream inputStream, FileOutputStream outputStream) throws IOException {
        if (null != outputStream) {
            outputStream.close();
        }
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
    }

    private static String createTempDir() {
        String tmpDirPrefix = UsFileUtils.class.getResource("/").getPath();
        if (tmpDirPrefix.contains(".jar!") && tmpDirPrefix.contains("file:")) {
            tmpDirPrefix = tmpDirPrefix.substring(0, tmpDirPrefix.indexOf(".jar!"));
            tmpDirPrefix = tmpDirPrefix.substring(0, tmpDirPrefix.lastIndexOf("/") + 1);
            tmpDirPrefix = tmpDirPrefix.replaceFirst("file:", "");
        }
        return tmpDirPrefix;
    }

    public static String[] normalizeString(String ... strs) {
        if (strs != null) {
            String[] newStrs = new String[strs.length];
            int index = 0;
            for (String str : strs) {
                newStrs[index] = Normalizer.normalize(str, Normalizer.Form.NFC).toLowerCase(Locale.ENGLISH);
                ++index;
            }
            return newStrs;
        }
        return null;
    }

    public static String normalizeStringByNFKC(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Normalizer.normalize(str, Normalizer.Form.NFKC);
        }
        return str;
    }

    public static String normalizeString(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Normalizer.normalize(str, Normalizer.Form.NFC);
        }
        return str;
    }

    private static Boolean checkTypeByRegex(String fileName, String regex) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(fileName.trim());
        return matcher.matches();
    }

    private static boolean isSecFileType(String suffix) {
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            if (suffix.length() > 100) {
                logger.error("the length of file type is larger than {}", (Object)100);
                return false;
            }
            Pattern pattern = Pattern.compile("[.A-Za-z0-9\\-_]+", 2);
            Matcher matcher = pattern.matcher(suffix);
            return matcher.matches();
        }
        return true;
    }

    private static boolean checkFileType(String fileName, String suffix) {
        if (StringUtils.isNotEmpty((CharSequence)fileName) && StringUtils.isNotEmpty((CharSequence)suffix)) {
            if (!UsFileUtils.isSecFileType(suffix)) {
                return false;
            }
            return UsFileUtils.checkTypeByRegex(fileName, ".*\\.(" + suffix.replaceAll("\\.", "\\\\.") + ")$");
        }
        return false;
    }

    public static boolean checkFileType(String fileName, String ... suffixs) {
        boolean result = false;
        if (StringUtils.isNotEmpty((CharSequence)fileName) && suffixs != null && suffixs.length > 0) {
            for (String suffix : suffixs) {
                result = result || UsFileUtils.checkFileType(fileName, suffix);
            }
        }
        return result;
    }

    public static boolean checkFileTypeForZip(String fileName, boolean checkSubFileByWhiteList, String ... suffixs) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return false;
        }
        File file = new File(fileName);
        if (!file.getName().contains(".")) {
            return true;
        }
        boolean result = false;
        if (suffixs != null && suffixs.length > 0) {
            for (String suffix : suffixs) {
                result = result || UsFileUtils.checkFileType(fileName, suffix);
            }
        }
        if (checkSubFileByWhiteList) {
            if (result) {
                return true;
            }
            return UsFileUtils.checkSubFileNameByRegexp(fileName);
        }
        return !result;
    }

    private static boolean checkSubFileNameByRegexp(String fileName) {
        String regexp = SystemConfigUtil.getStringValueByName((String)"us.trust.sub.file.name.regexp", (String)"");
        if (StringUtils.isNotEmpty((CharSequence)regexp)) {
            return fileName.matches(regexp);
        }
        return false;
    }

    private static boolean checkFileSize(File file, long size) {
        if (file == null) {
            return false;
        }
        if (file.length() < size) {
            return true;
        }
        logger.error("checkFile failed: FILE_SIZE_ERROR");
        return false;
    }

    private static String checkCompressedFile(File file, String fileType, long maxSize, long maxCount, Charset charset, String isCheckCsv, boolean checkSubFileByWhiteList, String ... subFileTypes) {
        File tempDirFile = null;
        try {
            CompressedFileCheckList cfcl;
            String sysTempDir;
            String tempDir;
            String result;
            if (file.length() > maxSize) {
                return FILE_SIZE_ERROR;
            }
            if (subFileTypes == null || subFileTypes.length <= 0) {
                subFileTypes = UsFileUtils.getSubFileType(checkSubFileByWhiteList);
            }
            if (charset == null) {
                charset = Charset.forName("GBK");
            }
            if (!FILE_CHECK_OK.equals(result = UsFileUtils.checkCompressedFile(file, fileType, tempDirFile = new File(tempDir = StringUtils.isEmpty((CharSequence)(sysTempDir = SystemConfigUtil.getStringValueByName((String)"us.file.check.temp.dir", (String)""))) ? file.getParent() + File.separator + UUID.randomUUID().toString() : sysTempDir + File.separator + UUID.randomUUID().toString()), cfcl = new CompressedFileCheckList(maxSize, maxCount), charset, checkSubFileByWhiteList, subFileTypes))) {
                UsFileUtils.deleteDir(tempDirFile);
                return result;
            }
            result = UsFileUtils.checkDirWithAtMostFiveLevel(tempDirFile, cfcl, charset, isCheckCsv, checkSubFileByWhiteList, subFileTypes);
            if (!FILE_CHECK_OK.equals(result)) {
                return result;
            }
            UsFileUtils.deleteDir(tempDirFile);
        }
        catch (Throwable e) {
            try {
                UsFileUtils.deleteDir(tempDirFile);
            }
            catch (IOException ioe) {
                logger.error("delete temp dir failed!", (Throwable)ioe);
            }
            logger.error("IO ERROR!", e);
            return FILE_IO_ERROR;
        }
        return FILE_CHECK_OK;
    }

    private static String checkCompressedFile(File file, String fileType, long maxSize, long maxCount, Charset charset, boolean checkSubFileByWhiteList, String[] subFileTypes, OverrideProps props) {
        File tempDirFile = null;
        try {
            CompressedFileCheckList cfcl;
            String sysTempDir;
            String tempDir;
            String result;
            if (file.length() > maxSize) {
                return FILE_SIZE_ERROR;
            }
            if (subFileTypes == null || subFileTypes.length <= 0) {
                subFileTypes = UsFileUtils.getSubFileType(checkSubFileByWhiteList);
            }
            if (charset == null) {
                charset = Charset.forName("GBK");
            }
            if (!FILE_CHECK_OK.equals(result = UsFileUtils.checkCompressedFile(file, fileType, tempDirFile = new File(tempDir = StringUtils.isEmpty((CharSequence)(sysTempDir = SystemConfigUtil.getStringValueByName((String)"us.file.check.temp.dir", (String)""))) ? file.getParent() + File.separator + UUID.randomUUID().toString() : sysTempDir + File.separator + UUID.randomUUID().toString()), cfcl = new CompressedFileCheckList(maxSize, maxCount), charset, checkSubFileByWhiteList, subFileTypes))) {
                UsFileUtils.deleteDir(tempDirFile);
                return result;
            }
            result = UsFileUtils.checkDirWithAtMostFiveLevel(tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes, props);
            if (!FILE_CHECK_OK.equals(result)) {
                return result;
            }
            UsFileUtils.deleteDir(tempDirFile);
        }
        catch (Throwable e) {
            try {
                UsFileUtils.deleteDir(tempDirFile);
            }
            catch (IOException ioe) {
                logger.error("delete temp dir failed!", (Throwable)ioe);
            }
            logger.error("IO ERROR!", e);
            return FILE_IO_ERROR;
        }
        return FILE_CHECK_OK;
    }

    private static String[] getSubFileType(boolean checkSubFileByWhiteList) {
        String[] subFileTypes = checkSubFileByWhiteList ? UsStringUtils.strToArray((String)SystemConfigUtil.getStringValueByName((String)"us.file.trusted_file_type", (String)"txt,xml,json,xls,xlsx,doc,docx,csv,png,jpg,bmp")) : UsStringUtils.strToArray((String)SystemConfigUtil.getStringValueByName((String)"us.file.untrusted_file_type", (String)""));
        return subFileTypes;
    }

    private static String checkDirWithAtMostFiveLevel(File tempDirFile, CompressedFileCheckList cfcl, Charset charset, String isCheckCsv, boolean checkSubFileByWhiteList, String ... subFileTypes) throws IOException {
        int level = 1;
        int maxLevel = UsFileUtils.getMaxLevel();
        while (true) {
            ArrayList<String> allFiles = new ArrayList<String>();
            UsFileUtils.getAllDirFiles(tempDirFile, allFiles);
            for (String string : allFiles) {
                if (UsFileUtils.checkFileHeader(string, UsFileUtils.getFileType(string))) continue;
                UsFileUtils.deleteDir(tempDirFile);
                logger.error("check file header failed:{}", (Object)string);
                return FILE_TYPE_ERROR;
            }
            String checkCSVAndExcelFileResult = UsFileUtils.checkCSVAndExcelFile(tempDirFile, isCheckCsv);
            if (!FILE_CHECK_OK.equals(checkCSVAndExcelFileResult)) {
                return checkCSVAndExcelFileResult;
            }
            ArrayList<File> compressedFiles = new ArrayList<File>();
            if (!UsFileUtils.getCompressedFiles(tempDirFile, compressedFiles, cfcl)) {
                UsFileUtils.deleteDir(tempDirFile);
                logger.error("unsupported compressed file type found in origin compressed file");
                return FILE_TYPE_ERROR;
            }
            if (compressedFiles.size() == 0) break;
            if (level > maxLevel) {
                UsFileUtils.deleteDir(tempDirFile);
                logger.error("compress level > {}!", (Object)maxLevel);
                return FILE_SIZE_ERROR;
            }
            for (File compressedFile : compressedFiles) {
                String innerTempDir = compressedFile.getParent() + File.separator + UUID.randomUUID().toString();
                File innerTempDirFile = new File(innerTempDir);
                String result = UsFileUtils.checkCompressedFile(compressedFile, UsFileUtils.getCompressedFileType(compressedFile), innerTempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
                if (!FILE_CHECK_OK.equals(result)) {
                    UsFileUtils.deleteDir(tempDirFile);
                    return result;
                }
                UsFileUtils.deleteDir(compressedFile);
            }
            ++level;
        }
        return FILE_CHECK_OK;
    }

    private static String checkDirWithAtMostFiveLevel(File tempDirFile, CompressedFileCheckList cfcl, Charset charset, boolean checkSubFileByWhiteList, String[] subFileTypes, OverrideProps props) throws IOException {
        int level = 1;
        int maxLevel = UsFileUtils.getMaxLevel();
        while (true) {
            ArrayList<String> allFiles = new ArrayList<String>();
            UsFileUtils.getAllDirFiles(tempDirFile, allFiles);
            for (String string : allFiles) {
                if (UsFileUtils.checkFileHeader(string, UsFileUtils.getFileType(string))) continue;
                UsFileUtils.deleteDir(tempDirFile);
                logger.error("check file header failed:{}", (Object)string);
                return FILE_TYPE_ERROR;
            }
            String checkCSVAndExcelFileResult = UsFileUtils.checkCSVAndExcelFile(tempDirFile, props);
            if (!FILE_CHECK_OK.equals(checkCSVAndExcelFileResult)) {
                return checkCSVAndExcelFileResult;
            }
            ArrayList<File> compressedFiles = new ArrayList<File>();
            if (!UsFileUtils.getCompressedFiles(tempDirFile, compressedFiles, cfcl)) {
                UsFileUtils.deleteDir(tempDirFile);
                logger.error("unsupported compressed file type found in origin compressed file");
                return FILE_TYPE_ERROR;
            }
            if (compressedFiles.size() == 0) break;
            if (level > maxLevel) {
                UsFileUtils.deleteDir(tempDirFile);
                logger.error("compress level > {}!", (Object)maxLevel);
                return FILE_SIZE_ERROR;
            }
            for (File compressedFile : compressedFiles) {
                String innerTempDir = compressedFile.getParent() + File.separator + UUID.randomUUID().toString();
                File innerTempDirFile = new File(innerTempDir);
                String result = UsFileUtils.checkCompressedFile(compressedFile, UsFileUtils.getCompressedFileType(compressedFile), innerTempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
                if (!FILE_CHECK_OK.equals(result)) {
                    UsFileUtils.deleteDir(tempDirFile);
                    return result;
                }
                UsFileUtils.deleteDir(compressedFile);
            }
            ++level;
        }
        return FILE_CHECK_OK;
    }

    private static int getMaxLevel() {
        int maxLevel = Integer.parseInt(SystemConfigUtil.getStringValueByName((String)"us.file.compressed_file_max_level", (String)"5"));
        if (maxLevel > 20) {
            maxLevel = 20;
        }
        return maxLevel;
    }

    private static String checkCSVAndExcelFile(File tempDirFile, String isCheckCsv) throws IOException {
        if ("off".equalsIgnoreCase(SystemConfigUtil.getStringValueByName((String)"is.check.csv", (String)"on")) && !"on".equalsIgnoreCase(isCheckCsv) || "off".equalsIgnoreCase(isCheckCsv)) {
            return FILE_CHECK_OK;
        }
        ArrayList<File> csvAndExcelFiles = new ArrayList<File>();
        UsFileUtils.getCsvAndExcelFiles(tempDirFile, csvAndExcelFiles);
        for (File csvOrExcelFile : csvAndExcelFiles) {
            String csvInjectionResult = UsFileUtils.checkFileCvsInjection(csvOrExcelFile);
            if (FILE_CHECK_OK.equals(csvInjectionResult)) continue;
            UsFileUtils.deleteDir(tempDirFile);
            logger.error("checkFile failed: {}", (Object)csvInjectionResult);
            return csvInjectionResult;
        }
        return FILE_CHECK_OK;
    }

    private static String checkCSVAndExcelFile(File tempDirFile, OverrideProps props) throws IOException {
        if (!props.isCheckCsv()) {
            return FILE_CHECK_OK;
        }
        ArrayList<File> csvAndExcelFiles = new ArrayList<File>();
        UsFileUtils.getCsvAndExcelFiles(tempDirFile, csvAndExcelFiles);
        for (File csvOrExcelFile : csvAndExcelFiles) {
            String csvInjectionResult = UsFileUtils.checkFileCvsInjection(csvOrExcelFile, props);
            if (FILE_CHECK_OK.equals(csvInjectionResult)) continue;
            UsFileUtils.deleteDir(tempDirFile);
            logger.error("checkFile failed: {}", (Object)csvInjectionResult);
            return csvInjectionResult;
        }
        return FILE_CHECK_OK;
    }

    private static String checkCompressedFile(File file, String fileType, File tempDirFile, CompressedFileCheckList cfcl, Charset charset, boolean checkSubFileByWhiteList, String[] subFileTypes) {
        switch (fileType) {
            case "zip": 
            case "war": 
            case "whl": 
            case "jar": {
                return UsFileUtils.checkZipCompressedFile(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
            }
            case "tgz": 
            case "tar.gz": {
                return UsFileForCompress.checkTarGzCompressedFile(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
            }
            case "tar.bz2": {
                return UsFileForCompress.checkTarBzCompressedFile(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
            }
            case "tar": {
                return UsFileForCompress.checkTarCompressedFile(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
            }
            case "rar": {
                return UsFileForRar.checkRarCompressedFile(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
            }
            case "bz2": {
                return UsFileForCompress.checkBz2CompressedFile(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
            }
            case "gz": {
                return UsFileForCompress.checkGzCompressedFile(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
            }
            case "7z": {
                return UsFileForSevenZ.checkSevenZCompressedFile(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypes);
            }
        }
        return FILE_TYPE_ERROR;
    }

    static String sanitizeFileName(String entryName, String intendedDir) throws IOException, IllegalStateException {
        File iD;
        String canonicalID;
        if (!UsFileLiteUtils.isNoAttackFileName(entryName)) {
            logger.error("[US-FILE] Unsecure file name: {}", (Object)entryName);
            throw new IOException("Unsecure file name!");
        }
        File file = new File(intendedDir, entryName);
        String canonicalPath = file.getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return canonicalPath;
        }
        logger.error("File is outside extraction target directory: {}", (Object)entryName);
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    private static void getCsvAndExcelFiles(File tempFile, List<File> csvAndExcelFiles) throws IOException {
        if (tempFile.isDirectory()) {
            File[] files = tempFile.listFiles();
            if (files != null) {
                for (File file : files) {
                    UsFileUtils.getCsvAndExcelFiles(file, csvAndExcelFiles);
                }
            }
        } else if (UsFileUtils.isCsvOrExcelFile(tempFile)) {
            csvAndExcelFiles.add(tempFile);
        }
    }

    private static boolean getCompressedFiles(File tempFile, List<File> compressedFiles, CompressedFileCheckList cfcl) throws IOException {
        if (tempFile.isDirectory()) {
            File[] files = tempFile.listFiles();
            if (files == null) {
                return true;
            }
            for (File file : files) {
                if (UsFileUtils.getCompressedFiles(file, compressedFiles, cfcl)) continue;
                return false;
            }
        } else if (UsFileUtils.isCompressedFile(tempFile)) {
            compressedFiles.add(tempFile);
            if ("true".equals(SystemConfigUtil.getStringValueByName((String)"us.file.size.check.skip.compress", (String)"false"))) {
                cfcl.setMaxSize(cfcl.getMaxSize() + tempFile.length());
            }
        } else {
            if (UsFileUtils.isUnSupportCompressedFile(tempFile)) {
                UsFileUtils.deleteDir(tempFile);
                return false;
            }
            UsFileUtils.deleteDir(tempFile);
        }
        return true;
    }

    private static void getAllDirFiles(File dir, List<String> allFiles) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isDirectory()) {
                    allFiles.add(f.getCanonicalPath());
                    continue;
                }
                UsFileUtils.getAllDirFiles(f, allFiles);
            }
        }
    }

    private static boolean isCompressedFile(File file) throws IOException {
        return UsFileUtils.checkFileType(file.getCanonicalPath().toLowerCase(), COMPRESSED_TYPE);
    }

    private static boolean isCompressedFile(String fileType) {
        return Arrays.asList(COMPRESSED_TYPE).contains(fileType.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isUnSupportCompressedFile(String fileType) {
        return Arrays.asList(NONSUPPORT_COMPRESSED_TYPE).contains(fileType.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isUnSupportCompressedFile(File file) throws IOException {
        String path = file.getCanonicalPath();
        for (String type : NONSUPPORT_COMPRESSED_TYPE) {
            if (!UsFileUtils.checkFileType(path.toLowerCase(Locale.ENGLISH), type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCsvOrExcelFile(File file) throws IOException {
        return UsFileUtils.checkFileType(file.getCanonicalPath().toLowerCase(), CSV_FILE_TYPE);
    }

    public static boolean isCsvOrExcelFile(String fileType) {
        return Arrays.asList(CSV_FILE_TYPE).contains(fileType.toLowerCase());
    }

    private static String getCompressedFileType(File file) throws IOException {
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), ZIP_TYPE)) {
            return ZIP_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), JAR_TYPE)) {
            return JAR_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), TAR_BZ_TYPE)) {
            return TAR_BZ_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), TAR_GZ_TYPE)) {
            return TAR_GZ_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), TAR_TYPE)) {
            return TAR_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), RAR_TYPE)) {
            return RAR_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), GZ_TYPE)) {
            return GZ_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), SEVEN_Z_TYPE)) {
            return SEVEN_Z_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), WHL_TYPE)) {
            return WHL_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), TGZ_TYPE)) {
            return TGZ_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), WAR_TYPE)) {
            return WAR_TYPE;
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), BZ2_TYPE)) {
            return BZ2_TYPE;
        }
        logger.error("unsupported file type: {}", (Object)file.getName());
        throw new IOException("unsupported file type");
    }

    private static String checkZipCompressedFile(File file, File tempDirFile, CompressedFileCheckList cfcl, Charset charset, boolean checkSubFileByWhiteList, String[] subFileTypeList) {
        try {
            if (null != Class.forName("org.apache.commons.compress.archivers.zip.ZipFile")) {
                logger.info("unzip file by compress!");
                return UsFileForCompress.checkZipCompressedFileByCompress(file, tempDirFile, cfcl, checkSubFileByWhiteList, subFileTypeList);
            }
        }
        catch (ClassNotFoundException e) {
            logger.info("if you want check zip by commons-compress, you need import commons-compress!", (Throwable)e);
        }
        logger.info("unzip file by jdk!");
        return UsFileUtils.checkZipCompressedFileByJdk(file, tempDirFile, cfcl, charset, checkSubFileByWhiteList, subFileTypeList);
    }

    /*
     * Exception decompiling
     */
    private static String checkZipCompressedFileByJdk(File file, File tempDirFile, CompressedFileCheckList cfcl, Charset charset, boolean checkSubFileByWhiteList, String[] subFileTypeList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String checkZipDir(ZipEntry entry, ZipInputStream zis, FileOutputStream fos, BufferedOutputStream dest, long maxSize, long maxCount, int buffer, File tempDirFile, CompressedFileCheckList cfcl, boolean checkSubFileByWhiteList, String[] subFileTypeList, byte[] data) throws IOException {
        long entries = 0L;
        long total = 0L;
        while ((entry = zis.getNextEntry()) != null) {
            try {
                int count;
                if (++entries > maxCount) {
                    logger.error("entries count check failed: {}", (Object)entries);
                    String string = FILE_SIZE_ERROR;
                    return string;
                }
                String name = UsFileUtils.sanitizeFileName(entry.getName(), tempDirFile.getCanonicalPath());
                if (entry.isDirectory()) {
                    if (UsFileUtils.makeDirIfNotExist(name)) continue;
                    logger.error("mkdir failed: {}", (Object)name);
                    String string = FILE_IO_ERROR;
                    return string;
                }
                if (!UsFileUtils.checkFileTypeForZip(entry.getName(), checkSubFileByWhiteList, subFileTypeList)) {
                    logger.error("checkFileType failed: {}", (Object)entry.getName());
                    String string = FILE_TYPE_ERROR;
                    return string;
                }
                UsFileUtils.makeParentDirIfNotExist(name);
                fos = new FileOutputStream(name);
                dest = new BufferedOutputStream(fos, buffer);
                while (total + (long)buffer <= maxSize && (count = zis.read(data, 0, buffer)) != -1) {
                    dest.write(data, 0, count);
                    total += (long)count;
                }
                if (total + (long)buffer <= maxSize) continue;
                logger.error("total size check failed: {}", (Object)total);
                String string = FILE_SIZE_ERROR;
                return string;
            }
            finally {
                UsFileUtils.closeInputStream(zis, fos, dest);
            }
        }
        cfcl.setMaxCount(cfcl.getMaxCount() - entries);
        cfcl.setMaxSize(cfcl.getMaxSize() - total);
        return FILE_CHECK_OK;
    }

    private static void closeInputStream(ZipInputStream zis, FileOutputStream fos, BufferedOutputStream dest) throws IOException {
        if (dest != null) {
            dest.flush();
            dest.close();
        }
        if (fos != null) {
            fos.close();
        }
        zis.closeEntry();
    }

    static String getFileName(File file) {
        return file != null ? file.getName() : "unknown file name";
    }

    static void deleteDir(File dir) throws IOException {
        String[] files;
        if (dir == null || !dir.exists()) {
            return;
        }
        if (dir.isDirectory() && (files = dir.list()) != null) {
            for (String file : files) {
                UsFileUtils.deleteDir(new File(dir, file));
            }
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
            throw new IOException("delete temp dir failed");
        }
    }

    public static boolean isImage(File imageFile) {
        if (!imageFile.exists()) {
            return false;
        }
        try {
            BufferedImage img = ImageIO.read(imageFile);
            return img != null && ((Image)img).getWidth(null) > 0 && ((Image)img).getHeight(null) > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean validateCsvStringBlack(String string) {
        if ("off".equalsIgnoreCase(SystemConfigUtil.getStringValueByName((String)"is.check.csv", (String)"on"))) {
            return true;
        }
        String str = String.valueOf(string);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return true;
        }
        str = UsFileUtils.normalizeStringByNFKC(str).trim();
        while (str.startsWith("\"")) {
            str = str.substring(1);
            str = str.trim();
        }
        for (char tmp : CSV_ILLEGAL_CHAR) {
            if (!str.startsWith(String.valueOf(tmp)) || UsFileUtils.validateCsvStringWhiteList(str)) continue;
            return false;
        }
        if (str.startsWith(String.valueOf('-')) && !str.matches("-\\d+[-+.eE\\d]*(,.*)?") && !UsFileUtils.validateCsvStringWhiteList(str)) {
            return false;
        }
        while (str.contains(",") && str.indexOf(",") < str.length() - 1) {
            str = str.substring(str.indexOf(",") + 1);
            str = str.trim();
            while (str.startsWith("\"")) {
                str = str.substring(1);
                str = str.trim();
            }
            for (char tmp : CSV_ILLEGAL_CHAR) {
                if (!str.startsWith(String.valueOf(tmp)) || UsFileUtils.validateCsvStringWhiteList(str)) continue;
                return false;
            }
            if (!str.startsWith(String.valueOf('-')) || str.matches("-\\d+[-+.eE\\d]*(,.*)?") || UsFileUtils.validateCsvStringWhiteList(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateExcelCellString(String string) {
        if ("off".equalsIgnoreCase(SystemConfigUtil.getStringValueByName((String)"is.check.csv", (String)"on"))) {
            return true;
        }
        String str = String.valueOf(string);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return true;
        }
        str = UsFileUtils.normalizeStringByNFKC(str).trim();
        while (str.startsWith("\"")) {
            str = str.substring(1);
            str = str.trim();
        }
        for (char tmp : CSV_ILLEGAL_CHAR) {
            if (!str.startsWith(String.valueOf(tmp)) || UsFileUtils.validateCsvStringWhiteList(str)) continue;
            return false;
        }
        return !str.startsWith(String.valueOf('-')) || str.matches("-\\d+[-+.eE\\d]*(,.*)?") || UsFileUtils.validateCsvStringWhiteList(str);
    }

    public static boolean validateCsvStringWhiteList(String str) {
        String whiteRegexp = SystemConfigUtil.getStringValueByName((String)"csv.cell.whitelist.regexp", (String)"");
        if (StringUtils.isNotEmpty((CharSequence)whiteRegexp)) {
            return str.matches(whiteRegexp);
        }
        return false;
    }

    public static boolean validateCsvString(String string) {
        if (!UsFileUtils.validateCsvStringBlack(string)) {
            String whiteRegexp = SystemConfigUtil.getStringValueByName((String)"csv.cell.whitelist.regexp", (String)"");
            if (StringUtils.isNotEmpty((CharSequence)whiteRegexp)) {
                return string.matches(whiteRegexp);
            }
            return false;
        }
        return true;
    }

    public static String checkFileCvsInjection(File file, String fileType) {
        if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)CSV_TYPE)) {
            return UsFileUtils.checkCvsFile(file);
        }
        return UsFileExcelUtils.check(file, fileType);
    }

    private static String checkFileCvsInjection(File file, String fileType, OverrideProps props) {
        if (!props.isCheckCsv()) {
            return FILE_CHECK_OK;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)CSV_TYPE)) {
            return UsFileUtils.checkCvsFile(file);
        }
        return UsFileExcelUtils.check(file, fileType, props);
    }

    private static String checkFileCvsInjection(File file) throws IOException {
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), CSV_TYPE)) {
            return UsFileUtils.checkCvsFile(file);
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), XLSX_TYPE)) {
            return UsFileExcelUtils.check(file, XLSX_TYPE);
        }
        return UsFileExcelUtils.check(file, XLS_TYPE);
    }

    private static String checkFileCvsInjection(File file, OverrideProps props) throws IOException {
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), CSV_TYPE)) {
            return UsFileUtils.checkCvsFile(file);
        }
        if (UsFileUtils.checkFileType(file.getCanonicalPath(), XLSX_TYPE)) {
            return UsFileExcelUtils.check(file, XLSX_TYPE, props);
        }
        return UsFileExcelUtils.check(file, XLS_TYPE, props);
    }

    private static String checkCvsFile(File file) {
        try {
            Class.forName("com.opencsv.CSVParser");
            return UsFileForCsv.checkCsvFile(file);
        }
        catch (ClassNotFoundException e) {
            logger.info("csv file found! you need import opencsv!");
            return CsvFileReader.checkCsvFile(file);
        }
    }

    public static boolean makeDirIfNotExist(String path) {
        File dir = UsFileLiteUtils.getFile(path);
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    public static boolean makeParentDirIfNotExist(String filePath) {
        File file = UsFileLiteUtils.getFile(filePath);
        if (!file.getParentFile().exists()) {
            return file.getParentFile().mkdirs();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkFileHeader(String filePath, String fileType) {
        String[] headers;
        if (StringUtils.isEmpty((CharSequence)fileType)) {
            return true;
        }
        String wantedHeader = fileTypeMap.get(fileType.toLowerCase(Locale.ENGLISH));
        if (null == wantedHeader) {
            return true;
        }
        File file = new File(filePath);
        if (file.length() == 0L) {
            return true;
        }
        byte[] txtContent = new byte[20];
        try (FileInputStream is = new FileInputStream(file);){
            if (((InputStream)is).read(txtContent, 0, txtContent.length) == -1) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            logger.error("create or read io failed!", (Throwable)e);
            return false;
        }
        StringBuilder builder = new StringBuilder();
        for (byte index : txtContent) {
            String hv = Integer.toHexString(index & 0xFF);
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        String realHeader = builder.toString().toLowerCase(Locale.ENGLISH);
        String[] stringArray = headers = wantedHeader.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            if (realHeader.startsWith(header)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void setFileHeader(String type, String header) {
        fileTypeMap.put(type, header);
    }

    public static List<String> getHeaderTypes() {
        Set<String> set = fileTypeMap.keySet();
        return new ArrayList<String>(set);
    }

    public static File getFile(String pathname) {
        return UsFileLiteUtils.getFile(pathname);
    }

    public static File getFile(String parent, String child) {
        return UsFileLiteUtils.getFile(parent, child);
    }

    public static File getFile(File parent, String child) {
        return UsFileLiteUtils.getFile(parent, child);
    }

    public static File getFile(URI uri) {
        return UsFileLiteUtils.getFile(uri);
    }

    public static File getFile(String ... names) {
        return UsFileLiteUtils.getFile(names);
    }

    public static FileInputStream getFileInputStream(String name) throws FileNotFoundException {
        return UsFileLiteUtils.getFileInputStream(name);
    }

    public static FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        return UsFileLiteUtils.getFileInputStream(file);
    }

    public static FileInputStream getFileInputStream(FileDescriptor fdObj) {
        return UsFileLiteUtils.getFileInputStream(fdObj);
    }

    public static FileOutputStream getFileOutputStream(String name) throws FileNotFoundException {
        return UsFileLiteUtils.getFileOutputStream(name);
    }

    public static FileOutputStream getFileOutputStream(String name, boolean append) throws FileNotFoundException {
        return UsFileLiteUtils.getFileOutputStream(name, append);
    }

    public static FileOutputStream getFileOutputStream(File file) throws FileNotFoundException {
        return UsFileLiteUtils.getFileOutputStream(file);
    }

    public static FileOutputStream getFileOutputStream(File file, boolean append) throws FileNotFoundException {
        return UsFileLiteUtils.getFileOutputStream(file, append);
    }

    public static FileOutputStream getFileOutputStream(FileDescriptor fdObj) {
        return UsFileLiteUtils.getFileOutputStream(fdObj);
    }

    public static FileReader getFileReader(String name) throws FileNotFoundException {
        return UsFileLiteUtils.getFileReader(name);
    }

    public static FileReader getFileReader(File file) throws FileNotFoundException {
        return UsFileLiteUtils.getFileReader(file);
    }

    public static FileReader getFileReader(FileDescriptor fdObj) {
        return UsFileLiteUtils.getFileReader(fdObj);
    }

    public static FileWriter getFileWriter(String name) throws IOException {
        return UsFileLiteUtils.getFileWriter(name);
    }

    public static FileWriter getFileWriter(String name, boolean append) throws IOException {
        return UsFileLiteUtils.getFileWriter(name, append);
    }

    public static FileWriter getFileWriter(File file) throws IOException {
        return UsFileLiteUtils.getFileWriter(file);
    }

    public static FileWriter getFileWriter(File file, boolean append) throws IOException {
        return UsFileLiteUtils.getFileWriter(file, append);
    }

    public static FileWriter getFileWriter(FileDescriptor fdObj) {
        return UsFileLiteUtils.getFileWriter(fdObj);
    }

    public static PrintWriter getPrintWriter(File file) throws IOException {
        return UsFileLiteUtils.getPrintWriter(file);
    }

    public static PrintWriter getPrintWriter(File file, String csn) throws IOException {
        return UsFileLiteUtils.getPrintWriter(file, csn);
    }

    public static PrintWriter getPrintWriter(String fileName) throws IOException {
        return UsFileLiteUtils.getPrintWriter(fileName);
    }

    public static PrintWriter getPrintWriter(String fileName, String csn) throws IOException {
        return UsFileLiteUtils.getPrintWriter(fileName, csn);
    }

    public static PrintWriter getPrintWriter(Writer out) {
        return UsFileLiteUtils.getPrintWriter(out);
    }

    public static PrintWriter getPrintWriter(Writer out, boolean autoFlush) {
        return UsFileLiteUtils.getPrintWriter(out, autoFlush);
    }

    public static PrintWriter getPrintWriter(OutputStream out) {
        return UsFileLiteUtils.getPrintWriter(out);
    }

    public static PrintWriter getPrintWriter(OutputStream out, boolean autoFlush) {
        return UsFileLiteUtils.getPrintWriter(out, autoFlush);
    }

    public static PrintStream getPrintStream(File file) throws IOException {
        return UsFileLiteUtils.getPrintStream(file);
    }

    public static PrintStream getPrintStream(File file, String csn) throws IOException {
        return UsFileLiteUtils.getPrintStream(file, csn);
    }

    public static PrintStream getPrintStream(String fileName) throws IOException {
        return UsFileLiteUtils.getPrintStream(fileName);
    }

    public static PrintStream getPrintStream(String fileName, String csn) throws IOException {
        return UsFileLiteUtils.getPrintStream(fileName, csn);
    }

    public static PrintStream getPrintStream(OutputStream out) {
        return UsFileLiteUtils.getPrintStream(out);
    }

    public static PrintStream getPrintStream(OutputStream out, boolean autoFlush) {
        return UsFileLiteUtils.getPrintStream(out, autoFlush);
    }

    public static PrintStream getPrintStream(OutputStream out, boolean autoFlush, String encoding) throws IOException {
        return UsFileLiteUtils.getPrintStream(out, autoFlush, encoding);
    }

    public static RandomAccessFile getRandomAccessFile(String fileName, String mode) throws FileNotFoundException {
        return UsFileLiteUtils.getRandomAccessFile(fileName, mode);
    }

    public static RandomAccessFile getRandomAccessFile(File file, String mode) throws FileNotFoundException {
        return UsFileLiteUtils.getRandomAccessFile(file, mode);
    }

    public static FilePermission getFilePermission(String fileName, String actions) {
        return UsFileLiteUtils.getFilePermission(fileName, actions);
    }

    static {
        fileTypeMap.put("jpg", "ffd8ff");
        fileTypeMap.put("jpeg", "ffd8ff");
        fileTypeMap.put("png", "89504e47");
        fileTypeMap.put("gif", "47494638");
        fileTypeMap.put("tif", "49492a00");
        fileTypeMap.put("bmp", "424d");
        fileTypeMap.put(TAR_GZ_TYPE, "1f8b");
        fileTypeMap.put(TGZ_TYPE, "1f8b");
        fileTypeMap.put(RAR_TYPE, "52617221");
        fileTypeMap.put(ZIP_TYPE, "504b");
        fileTypeMap.put(JAR_TYPE, "504b");
        fileTypeMap.put(GZ_TYPE, "1f8b");
        fileTypeMap.put(BZ2_TYPE, "425a");
        fileTypeMap.put(XLSX_TYPE, "504b0304");
        fileTypeMap.put(XLS_TYPE, "d0cf11e0");
        fileTypeMap.put("doc", "d0cf11e0");
        fileTypeMap.put("docx", "504b0304");
        fileTypeMap.put("pptx", "504b0304");
        fileTypeMap.put("ppt", "d0cf11e0");
        fileTypeMap.put("pst", "2142444e");
        fileTypeMap.put("mdb", "5374616e64617264204a");
        fileTypeMap.put("wpd", "ff575043");
        fileTypeMap.put("eps", "252150532d41646f6265");
        fileTypeMap.put("ps", "252150532d41646f6265");
        fileTypeMap.put("pdf", "255044462d312e");
        fileTypeMap.put("qdf", "ac9ebd8f");
        fileTypeMap.put("wav", "524946");
        fileTypeMap.put("avi", "524946");
        fileTypeMap.put("ram", "2e7261fd");
        fileTypeMap.put("rm", "2e524d46");
        fileTypeMap.put("mpg", "000001b");
        fileTypeMap.put("mov", "6d6f6f76");
        fileTypeMap.put("asf", "3026b2758e66cf11");
        fileTypeMap.put("mid", "4d546864");
        fileTypeMap.put("dwg", "41433130");
        fileTypeMap.put("psd", "38425053");
        fileTypeMap.put("rtf", "7b5c727466");
        fileTypeMap.put("dbx", "cfad12fec5fd746f");
        fileTypeMap.put("pwl", "e3828596");
    }
}

