/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.api;

import java.nio.charset.Charset;
import java.util.Arrays;

public class FileParameter {
    private String fileName;
    private String fileType;
    private String realFileType;
    private long size;
    private long compressedSize;
    private Charset charset;
    private Boolean checkSubFileByWhiteList;
    private String[] subFileType;

    FileParameter(String fileName, String fileType, String realFileType, long size, long compressedSize, Charset charset, Boolean checkSubFileByWhiteList, String[] subFileType) {
        this.fileName = fileName;
        this.fileType = fileType;
        this.realFileType = realFileType;
        this.size = size;
        this.compressedSize = compressedSize;
        this.charset = charset;
        this.checkSubFileByWhiteList = checkSubFileByWhiteList;
        this.subFileType = subFileType;
    }

    public static FileParameterBuilder builder() {
        return new FileParameterBuilder();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getRealFileType() {
        return this.realFileType;
    }

    public long getSize() {
        return this.size;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Boolean getCheckSubFileByWhiteList() {
        return this.checkSubFileByWhiteList;
    }

    public String[] getSubFileType() {
        return this.subFileType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setRealFileType(String realFileType) {
        this.realFileType = realFileType;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setCheckSubFileByWhiteList(Boolean checkSubFileByWhiteList) {
        this.checkSubFileByWhiteList = checkSubFileByWhiteList;
    }

    public void setSubFileType(String[] subFileType) {
        this.subFileType = subFileType;
    }

    public static class FileParameterBuilder {
        private String fileName;
        private String fileType;
        private String realFileType;
        private long size;
        private long compressedSize;
        private Charset charset;
        private Boolean checkSubFileByWhiteList;
        private String[] subFileType;

        FileParameterBuilder() {
        }

        public FileParameterBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public FileParameterBuilder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public FileParameterBuilder realFileType(String realFileType) {
            this.realFileType = realFileType;
            return this;
        }

        public FileParameterBuilder size(long size) {
            this.size = size;
            return this;
        }

        public FileParameterBuilder compressedSize(long compressedSize) {
            this.compressedSize = compressedSize;
            return this;
        }

        public FileParameterBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public FileParameterBuilder checkSubFileByWhiteList(Boolean checkSubFileByWhiteList) {
            this.checkSubFileByWhiteList = checkSubFileByWhiteList;
            return this;
        }

        public FileParameterBuilder subFileType(String[] subFileType) {
            this.subFileType = subFileType;
            return this;
        }

        public FileParameter build() {
            return new FileParameter(this.fileName, this.fileType, this.realFileType, this.size, this.compressedSize, this.charset, this.checkSubFileByWhiteList, this.subFileType);
        }

        public String toString() {
            return "FileParameter.FileParameterBuilder(fileName=" + this.fileName + ", fileType=" + this.fileType + ", realFileType=" + this.realFileType + ", size=" + this.size + ", compressedSize=" + this.compressedSize + ", charset=" + this.charset + ", checkSubFileByWhiteList=" + this.checkSubFileByWhiteList + ", subFileType=" + Arrays.deepToString(this.subFileType) + ")";
        }
    }
}

