/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.api;

import com.huawei.us.common.file.api.RarOversizeException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RarCheckOutputstream
extends OutputStream {
    private long max_size;
    private long count = 0L;
    private FileOutputStream file;

    public RarCheckOutputstream(long max_size) {
        this.max_size = max_size;
    }

    @Override
    public void write(int b) {
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.count += (long)len;
        if (this.count > this.max_size) {
            this.file.close();
            throw new RarOversizeException("total size check failed: " + this.count);
        }
        this.file.write(bytes, off, len);
    }

    public void setFile(String path) throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        this.file = new FileOutputStream(path);
    }

    public long getSize() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        super.close();
    }
}

