/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.bom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteOrderMark {
    private static final Logger logger = LoggerFactory.getLogger(ByteOrderMark.class);
    private static final int[] UTF_8 = new int[]{239, 187, 191};
    private static final int[] UTF_16LE = new int[]{255, 254};
    private static final int[] UTF_32LE = new int[]{255, 254, 0, 0};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset getBOMCharset(File file) {
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            int[] head = new int[4];
            for (int i = 0; i < head.length; ++i) {
                head[i] = is.read();
            }
            if (head[0] == UTF_32LE[0] && head[1] == UTF_32LE[1] && head[2] == UTF_32LE[2] && head[3] == UTF_32LE[3]) {
                Charset charset = Charset.forName("UTF-32LE");
                return charset;
            }
            if (head[0] == UTF_16LE[0] && head[1] == UTF_16LE[1]) {
                Charset charset = StandardCharsets.UTF_16LE;
                return charset;
            }
            if (head[0] == UTF_8[0] && head[1] == UTF_8[1] && head[2] == UTF_8[2]) {
                Charset charset = StandardCharsets.UTF_8;
                return charset;
            }
            Charset charset = null;
            return charset;
        }
        catch (IOException e) {
            logger.error("[US-FILE] Read file failed!", (Throwable)e);
            return null;
        }
    }
}

