/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.excel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalLink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.ExternalLinkDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XlsxDdeChecker {
    private static final Logger logger = LoggerFactory.getLogger(XlsxDdeChecker.class);

    XlsxDdeChecker() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isContainDdeLink(OPCPackage pkg) {
        ArrayList packageParts = pkg.getPartsByContentType(XSSFRelation.EXTERNAL_LINKS.getContentType());
        Iterator iterator = packageParts.iterator();
        while (iterator.hasNext()) {
            PackagePart packagePart = (PackagePart)iterator.next();
            try {
                InputStream in = packagePart.getInputStream();
                Throwable throwable = null;
                try {
                    ExternalLinkDocument doc = (ExternalLinkDocument)ExternalLinkDocument.Factory.parse(in, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                    CTExternalLink link = doc.getExternalLink();
                    if (link == null || !link.isSetDdeLink()) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                logger.warn("[US-FILE] External link file parse failed: {}", (Object)e.getMessage());
            }
        }
        return false;
    }
}

