/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.excel;

import com.huawei.us.common.file.excel.XlsxValidator;
import com.huawei.us.common.file.exception.CsvInjectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XlsxPoiSheetHandler
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(XlsxPoiSheetHandler.class);
    private static final String CELL_TAG = "c";
    private static final String X_CELL_TAG = "x:c";
    private static final String CELL_FORMULA_TAG = "f";
    private static final String X_CELL_FORMULA_TAG = "x:f";
    private String cellPosition;
    private String lastContents;

    XlsxPoiSheetHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (CELL_TAG.equals(name) || X_CELL_TAG.equals(name)) {
            this.cellPosition = attributes.getValue("r");
        }
        this.lastContents = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ((CELL_FORMULA_TAG.equals(name) || X_CELL_FORMULA_TAG.equals(name)) && !XlsxValidator.validateFormula(this.lastContents)) {
            logger.error("[US-FILE] Illegal text found... {}", (Object)this.cellPosition);
            throw new CsvInjectionException("Illegal text found...");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }
}

