/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.excel;

import com.alibaba.excel.cache.ReadCache;
import com.huawei.us.common.file.api.OverrideProps;
import com.huawei.us.common.file.excel.XlsxValidator;
import com.huawei.us.common.file.exception.CsvInjectionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.model.StylesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XlsxSheetHandler
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(XlsxSheetHandler.class);
    private static final String CELL_TAG = "c";
    private static final String X_CELL_TAG = "x:c";
    private static final String NS2_CELL_TAG = "ns2:c";
    private static final String CELL_VALUE_TAG = "v";
    private static final String X_CELL_VALUE_TAG = "x:v";
    private static final String NS2_CELL_VALUE_TAG = "ns2:v";
    private static final String CELL_FORMULA_TAG = "f";
    private static final String X_CELL_FORMULA_TAG = "x:f";
    private static final String NS2_CELL_FORMULA_TAG = "ns2:f";
    private static final String CELL_POSITION_ATTRIBUTE = "r";
    private static final String CELL_STYLE_ATTRIBUTE = "s";
    private ReadCache readCache;
    private StylesTable stylesTable;
    private OverrideProps props;
    private int nextXfsIndex;
    private String cellPosition;
    private String lastContents;

    public XlsxSheetHandler() {
        this.props = OverrideProps.builder().build();
    }

    public XlsxSheetHandler(ReadCache readCache, StylesTable stylesTable) {
        this.readCache = readCache;
        this.stylesTable = stylesTable;
        this.props = OverrideProps.builder().build();
    }

    public XlsxSheetHandler(ReadCache readCache, StylesTable stylesTable, OverrideProps props) {
        this.readCache = readCache;
        this.stylesTable = stylesTable;
        this.props = props;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.lastContents = "";
        if (CELL_TAG.equals(name) || X_CELL_TAG.equals(name) || NS2_CELL_TAG.equals(name)) {
            this.cellPosition = attributes.getValue(CELL_POSITION_ATTRIBUTE);
            try {
                String cellXfs = attributes.getValue(CELL_STYLE_ATTRIBUTE);
                this.nextXfsIndex = StringUtils.isNotEmpty((CharSequence)cellXfs) ? Integer.parseInt(cellXfs) : 0;
            }
            catch (Throwable e) {
                logger.debug("[US-FILE] Get next CellXfs failed: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (CELL_VALUE_TAG.equals(name) || X_CELL_VALUE_TAG.equals(name) || NS2_CELL_VALUE_TAG.equals(name)) {
            if (!this.props.isCheckExcelStringValue()) {
                return;
            }
            if (this.isTextStyle()) {
                return;
            }
            String stringValue = this.getSstValue();
            if (!XlsxValidator.validateStringValue(stringValue)) {
                logger.error("[US-FILE] Illegal text found: {}", (Object)this.cellPosition);
                throw new CsvInjectionException("Illegal text found.");
            }
            return;
        }
        if ((CELL_FORMULA_TAG.equals(name) || X_CELL_FORMULA_TAG.equals(name) || NS2_CELL_FORMULA_TAG.equals(name)) && !XlsxValidator.validateFormula(this.lastContents)) {
            logger.error("[US-FILE] Illegal text found: {}", (Object)this.cellPosition);
            throw new CsvInjectionException("Illegal text found.");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }

    private boolean isTextStyle() {
        if (this.stylesTable != null && this.stylesTable.getCellXfAt(this.nextXfsIndex) != null) {
            if (this.stylesTable.getCellXfAt(this.nextXfsIndex).getQuotePrefix()) {
                return true;
            }
            return 49L == this.stylesTable.getCellXfAt(this.nextXfsIndex).getNumFmtId();
        }
        return false;
    }

    private String getSstValue() {
        if (this.readCache != null) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                return this.readCache.get(Integer.valueOf(idx));
            }
            catch (Throwable e) {
                return this.lastContents;
            }
        }
        return this.lastContents;
    }
}

