/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.excel;

import com.huawei.us.common.file.UsFileUtils;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class XlsxValidator {
    private static final String CSV_FORMULA_REGEXP = SystemConfigUtil.getStringValueByName((String)"csv.formula.regexp", (String)"[\\S\\s]+\\|[\\S\\s]+![\\S\\s]+");
    private static final String[] CSV_ILLEGAL_CHAR = new String[]{"+", "-", "=", "@"};

    public static boolean validateStringValue(String value) {
        if (!XlsxValidator.isCheckCsv()) {
            return true;
        }
        if (XlsxValidator.validateString(value)) {
            return true;
        }
        return XlsxValidator.validateCsvStringWhiteList(value);
    }

    private static boolean validateString(String value) {
        String str = String.valueOf(value);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return true;
        }
        str = UsFileUtils.normalizeStringByNFKC(str);
        for (String temp : CSV_ILLEGAL_CHAR) {
            if (!str.startsWith(temp)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateFormula(String formula) {
        if (!XlsxValidator.isCheckCsv()) {
            return true;
        }
        if (XlsxValidator.validateFormulaString(formula)) {
            return true;
        }
        return XlsxValidator.validateCsvStringWhiteList(formula);
    }

    private static boolean validateFormulaString(String formula) {
        String str = String.valueOf(formula);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return true;
        }
        return !Pattern.matches(CSV_FORMULA_REGEXP, str = UsFileUtils.normalizeStringByNFKC(str).trim());
    }

    private static boolean validateCsvStringWhiteList(String str) {
        String whiteRegexp = SystemConfigUtil.getStringValueByName((String)"csv.cell.whitelist.regexp", (String)"");
        if (StringUtils.isNotEmpty((CharSequence)whiteRegexp)) {
            return str.matches(whiteRegexp);
        }
        return false;
    }

    private static boolean isCheckCsv() {
        return "on".equalsIgnoreCase(SystemConfigUtil.getStringValueByName((String)"is.check.csv", (String)"on"));
    }
}

