/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.excel;

import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XmlParser {
    private static final Logger logger = LoggerFactory.getLogger(XmlParser.class);
    private static final String SAX_PARSER_FACTORY = SystemConfigUtil.getStringValueByName((String)"sax.parser.factory", (String)"");

    XmlParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parseXmlSource(InputStream inputStream, ContentHandler handler) throws IOException, SAXException, ParserConfigurationException {
        try {
            InputSource inputSource = new InputSource(inputStream);
            SAXParserFactory saxFactory = StringUtils.isNotEmpty((CharSequence)SAX_PARSER_FACTORY) ? SAXParserFactory.newInstance(SAX_PARSER_FACTORY, null) : SAXParserFactory.newInstance();
            try {
                saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException e) {
                logger.error("[US-FILE] Failed to set Feature: ", (Throwable)e);
            }
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(inputSource);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

