#!/bin/bash

PRODUCT_NAME=""
function GetProductName()
{
    if [ "$PRODUCT_NAME" == "" ];then
        PRODUCT_NAME=$(dmidecode -t 1 | grep "Product Name:" | awk -F: '{print $2}' | sed 's/^\s*//;s/\s*$//')
    fi
}

GetProductName

function LOG() 
{
    logFile="/var/log/inspect.log"
    echo [$(date)][$$]$@ >> $logFile

}

function IsT3000Node()
{
    if [ "$PRODUCT_NAME"X = "T3200 G3"X -o "$PRODUCT_NAME"X = "T3500 G3"X -o "$PRODUCT_NAME"X = "T3000 G3"X ]; then
        return 0
    else
        return 1
    fi
}

function IsStandardNode()
{
    local name=''
    local saspci=''
    name=$(dmidecode -t 1 | grep "Product Name:" | awk '{print $3}')
    if [ "$name" = "Standard" -o "$name" = "OpenStack" ]; then
        saspci=$(lspci |grep "SAS")
        if [ "$saspci" != "" ]; then
            return 0
        else
            return 1
        fi
    else
        return 1
    fi
}

function IsRHV3Node()
{
    if [ "$PRODUCT_NAME"X = "RH2288 V3"X -o "$PRODUCT_NAME"X = "5288 V3"X -o "$PRODUCT_NAME"X = "RH2288H V3"X ]; then
        #touch /opt/.tmp_RHNode_flag
        return 0
    else
        IsStandardNode
        if [ $? -eq 0 ]; then
            return 0
        else
            return 1
        fi
    fi
}
function IsRHV5Node()
{
    if [ "$PRODUCT_NAME"X = "2288H V5"X -o "$PRODUCT_NAME"X = "2288 V5"X -o "$PRODUCT_NAME"X = "5288 V5"X ]; then
        return 0
    else
        return 1
    fi
}
function IsC72Node()
{
    dmidecode -t 4 | grep -q "Family: Atom"
    return $?
}

function IsVirtualNode()
{
    IsStandardNode
    if [ $? -eq 0 ] ; then
        return 1
    fi
    local VMwareFlag=$(echo "${PRODUCT_NAME}" |grep VMware)
    local OpenStackFlag=$(echo "${PRODUCT_NAME}" |grep OpenStack)
    local ManufacturerFlag=$(dmidecode -t 1 | grep "Manufacturer" | awk -F : '{print $2}' | sed 's/^[ \t]*//g' | sed 's/[ \t]*$//g')

    if [ "$VMwareFlag"X != ""X ] || [ "$OpenStackFlag"X != ""X ] || [ "$ManufacturerFlag" == "QEMU" ] || [ "$ManufacturerFlag" == "Xen" ];then
        return 0
    elif lsmod | grep -q virtio ;then
        return 0
    else
        return 1
    fi
}
function IsRHNode()
{
    IsRHV3Node
    local isV3=$?
    IsRHV5Node
    local isV5=$?
    if [ $isV3 -eq 0 -o $isV5 -eq 0 ];then
        return 0
    else
        return 1
    fi
}
function IsRH2288Node()
{
    if [ "$PRODUCT_NAME"X = "RH2288 V3"X -o "$PRODUCT_NAME"X = "RH2288H V3"X -o "$PRODUCT_NAME"X = "2288H V5"X -o "$PRODUCT_NAME"X = "2288 V5"X ]; then
        return 0
    else
        return 1
    fi
}
function IsTSNode()
{ 
    if [ "$PRODUCT_NAME"X = "TaiShan 5280"X -o "$PRODUCT_NAME"X = "TaiShan 2280"X -o "$PRODUCT_NAME"X = "TaiShan 2280 V2"X -o "$PRODUCT_NAME"X = "TaiShan 5280 V2"X -o "$PRODUCT_NAME"X = "TaiShan 5290"X -o "$PRODUCT_NAME"X = "TaiShan 5290 v2"X ]; then
        return 0
    else
        return 1
    fi
}
