#/bin/bash
set +x

function getThisLogFileName()
{
    echo "/var/log/inspect_period.log"
}

function LOG()
{
    local logFile=$(getThisLogFileName)
    echo [$(date)][$$][$0][${FUNCNAME[1]}]"$@" >> ${logFile}
}

function clearThisLog()
{
    local logFile=$(getThisLogFileName)
    local sum=0
    local keepNum=14000 #inspect once take up 1400 lines
    local maxNum=20000
    local clrNum=0

    if [ ! -f "${logFile}" ]; then
        return #dont need clear
    fi
    sum=$(sed -n '$=' ${logFile})
    sum=${sum:=0}
    if [ ${sum} -gt ${maxNum} ]; then
        clrNum=$((sum - keepNum))
        sed -i "1,${clrNum}d" ${logFile}
    fi
}

function getMemUsedHisRecFile()
{
    echo "/tmp/memUsedHisRecord"
}

function getModuleMemUsed()
{
    local module=$1
    local command=$2
    local filter=$3
    local testInfo=$4
    local memUsed=0
    local memTemp=0
    local count=$(echo ${testInfo} | awk -F',' '{print $1}')
    local thrd=$(echo ${testInfo} | awk -F',' '{print $2}')
    local hisInfo=""
    local memInfo=""
    local isAlarm=0
    if [ ${count:-0} -eq 0 ]; then
        return #No need successive inspect.
    fi
    memInfo=$(eval "${command}" | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' 2>&1)
    LOG "${module} ${command} ${memInfo}"
    memInfo=$(echo "${memInfo}" | sed -n "s/${filter}/p")
    memTemp=$(echo ${memInfo}|sed 's/\s\+$//')
    if [[ ${memInfo} =~ ^[0-9]+\ [0-9]+$ ]]; then
        memUsed=$(echo ${memInfo} | awk '{if($1 > $2){print $1-$2;} else{print "0";}}')
    elif [[ "${memTemp}" =~ ^[0-9]+$ ]]; then
        memUsed=${memTemp}
    else
        memUsed=0
    fi
    hisInfo=$(sed -n "/${module}\s/p" $(getMemUsedHisRecFile))
    if [ -z "${hisInfo}" ]; then
        echo "${module} 0 0 ${memUsed}B 0B 0B 0B 0B 0B 0B 0B 0B 0B" >>$(getMemUsedHisRecFile)
    elif [ "$(echo "${hisInfo}" | wc -l)" -gt 1 ]; then
        #Exception of multi-line
        sed "/${module}\s/d" -i $(getMemUsedHisRecFile)
        echo "${module} 0 0 ${memUsed}B 0B 0B 0B 0B 0B 0B 0B 0B 0B" >>$(getMemUsedHisRecFile)
    else
        hisInfo=$(echo ${hisInfo} | 
            awk -v module="${module}" -v count="${count}" -v thrd="${thrd}" -v memUsed="${memUsed}" \
                'BEGIN{ \
                    isAlarm=0; \
                    successive=0; \
                } \
                { \
                    isAlarm=$2; \
                    successive=$3; \
                    lastMemUsed=$4; \
                    sub(/B/, "", lastMemUsed); \
                    if ((memUsed + 0) >= (lastMemUsed + thrd)) { \
                        successive++; \
                        if (successive >= count) { \
                            isAlarm=1; \
                            successive=count; \
                        } \
                    } \
                    else { \
                        isAlarm=0; \
                        successive=0; \
                    } \
                } \
                END{ \
                    print module" "isAlarm" "successive" "memUsed"B "$4" "$5" "$6" "$7" "$8" "$9" "$10" "$11" "$12; \
                }' \
            )
        sed "s/^${module}\s.*$/${hisInfo}/" -i $(getMemUsedHisRecFile)
        LOG "memUsedHisRecord: ${hisInfo}"
    fi
}

function getMONmemUsed()
{
    local commands=(
'/usr/local/bin/MmlBatch 988 "mem show stat 3"'
'/usr/local/bin/MmlBatch 4004 "mem show stat 5"'
'/usr/local/bin/MmlBatch 4104 "mem show stat 21"'
'/usr/local/bin/MmlBatch 4108 "mem show stat 21"'
'/usr/local/bin/MmlBatch 988 "mem show stat 3"'
'/usr/local/bin/MmlBatch 988 "mem show stat 3"'
'/usr/local/bin/MmlBatch 988 "mem show stat 1"'
'/usr/local/bin/MmlBatch 988 "mem show stat 1"'
'/usr/local/bin/MmlBatch 988 "mem show stat 17"'
'/usr/local/bin/MmlBatch 988 "mem show stat 2"'
'/usr/local/bin/MmlBatch 988 "mem show stat 9"'
'/usr/local/bin/MmlBatch 988 "mem show stat 8"'
'/usr/local/bin/MmlBatch 4016 "mem show stat 7"'
'/usr/local/bin/MmlBatch 988 "nvmem show stat 5"'
'/usr/local/bin/MmlBatch 988 "nvmem show stat 6"'
'/usr/local/bin/MmlBatch 988 "nvmem show stat 7"'
'/usr/local/bin/MmlBatch 988 "mem show stat 4"'
'/usr/local/bin/MmlBatch 988 "mem show stat 15"'
'/usr/local/bin/MmlBatch 988 "mem show stat 6"'
'ps -C snas_bjm_manager v'
'ps -C snas_mon v'
'ps -C snas_bjm_server v'
'ps -C snas_bjm_worker v'
)
    local modules=(
"CA_LDB"
"MON"
"BJM_Server"
"BJM_Worker"
"ca.0"
"ca.2"
"mds.0"
"mds.2"
"DAB"
"DS"
"OBS"
"CM_Kernel"
"CM_User"
"NV"
"TRNS"
"TRNS_LOG"
"MONC"
"nofs.6"
"DLM"
"BJM_Manager"
"MON_pid"
"BJM_Server_pid"
"BJM_Worker_pid"
)
    local filters=(
".*PooId 0,.*AllocFailTimes \([0-9]\+\).*/\1"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 2, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 2, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*total size : [0-9]\+ MB (\([0-9]\+\) B), free size : [0-9]\+ MB (\([0-9]\+\) B).*/\1 \2"
".*total size : [0-9]\+ MB (\([0-9]\+\) B), free size : [0-9]\+ MB (\([0-9]\+\) B).*/\1 \2"
".*total size : [0-9]\+ MB (\([0-9]\+\) B), free size : [0-9]\+ MB (\([0-9]\+\) B).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 6, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*PooId 0, Total \([0-9]\+\), Free \([0-9]\+\).*/\1 \2"
".*\s\([0-9]\+\)\s\+\([0-9]\)[0-9\.]\+\s\+[^0-9]*snas_bjm_manager.*/\1 \2"
".*\s\([0-9]\+\)\s\+\([0-9]\)[0-9\.]\+\s\+[^0-9]*snas_mon.*/\1 \2"
".*\s\([0-9]\+\)\s\+\([0-9]\)[0-9\.]\+\s\+[^0-9]*snas_bjm_server.*/\1 \2"
".*\s\([0-9]\+\)\s\+\([0-9]\)[0-9\.]\+\s\+[^0-9]*snas_bjm_worker.*/\1 \2"
)
    local thrds=(
1,1,CA_LDB
10,31457280,MON
10,52428800,BJM_Server
10,52428800,BJM_Worker
5,52428800,CA
5,52428800,CA
5,52428800,MDS
5,52428800,MDS
5,31457280,DAB
5,41943040,DS
5,26214400,OBS
0,1,CM_Kernel
0,1,CM_User
5,31457280,NV
5,3145728,TRANS
5,10485760,TRANS_LOG
10,31457280,MONC
0,1,NOFS
10,31457280,DLM
10,15728640,BJM_Manager
10,31457280,MON_pid
10,52428800,BJM_Server_pid
10,52428800,BJM_Worker_pid
)
    for i in $(seq 0 $((${#modules[@]}-1))); do
        getModuleMemUsed "${modules[$i]}" "${commands[$i]}" "${filters[$i]}" "${thrds[$i]}"
    done
    
}

function addPeriodInspect()
{
    local taskInCrontab=$(sed -n '/inspect_mml\/dynamic_mem_inspect.sh/p' /etc/crontab)
    if [ -z "${taskInCrontab}" ]; then
        #Inspect every hour
        echo "30 */1 * * * root nice --adjustment=19 /opt/huawei/snas/script/inspect_mml/dynamic_mem_inspect.sh >> /dev/null 2>&1" >> /etc/crontab
        service cron restart >/dev/null 2>&1
        service cron reload  >/dev/null 2>&1
        LOG "Service cron restart and reload."
    elif [ "$(echo "${taskInCrontab}" | wc -l)" -gt 1 ]; then
        #Exception of multi-line
        sed "/inspect_mml\/dynamic_mem_inspect.sh/d" -i $(getMemUsedHisRecFile)
        echo "30 */1 * * * root nice --adjustment=19 /opt/huawei/snas/script/inspect_mml/dynamic_mem_inspect.sh >> /dev/null 2>&1" >> /etc/crontab
        service cron restart >/dev/null 2>&1
        service cron reload  >/dev/null 2>&1
        LOG "Service cron restart and reload."
    fi
}

function main()
{
    local module
    local command
    local filter
    local thrd
    local isInit=$1
    if [ -n "${isInit}" ]; then
        if [ "${isInit}" == "init" ]; then
            addPeriodInspect
        fi #Else wrong parameter
        return
    fi #Else there is no parameter

    if [ ! -e $(getMemUsedHisRecFile) ]; then
        touch $(getMemUsedHisRecFile)
    fi
    clearThisLog
 
    #inspect once every hour
    module="RPC"
    command='cat /proc/sys/lnet/memused'
    filter="[^0-9]*\([0-9]\+\)\(\s\+\)[0-9]\+.*/\1 \2"
    thrd="5,104857600,RPC"
    getModuleMemUsed "${module}" "${command}" "${filter}" "${thrd}"
    module="RPC_Page"
    command='cat /proc/sys/lnet/pageused'
    getModuleMemUsed "${module}" "${command}" "${filter}" "${thrd}"

    #inspect once every day
    local hour=$(date +%k)
    if [ ${hour} -eq 1 ]; then
        getMONmemUsed
    fi
}

main $@

